/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.ImplicitJoinInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertNaturalJoinToOnIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertNaturalJoinToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1864#2,3:54\n*S KotlinDebug\n*F\n+ 1 SqlConvertNaturalJoinToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention\n*L\n33#1:54,3\n*E\n"})
public final class SqlConvertNaturalJoinToOnIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.natural.join.with.on.clause", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JoinUtilsKt.getNaturalJoinInfo(element2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        ImplicitJoinInfo implicitJoinInfo = JoinUtilsKt.getNaturalJoinInfo(element2);
        if (implicitJoinInfo == null) {
            return;
        }
        ImplicitJoinInfo info2 = implicitJoinInfo;
        PsiElement psiElement = element2.getParent();
        SqlJoinExpression sqlJoinExpression = psiElement instanceof SqlJoinExpression ? (SqlJoinExpression)psiElement : null;
        if (sqlJoinExpression == null) {
            return;
        }
        SqlJoinExpression joinExpression = sqlJoinExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)joinExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo join bar ").keyword("on ");
        if (!((Collection)info2.getColumns()).isEmpty()) {
            Iterable $this$forEachIndexed$iv = info2.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String string;
                void column2;
                String string2;
                String string3;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DasColumn dasColumn = (DasColumn)item$iv;
                int i2 = n;
                boolean bl = false;
                if (i2 > 0) {
                    builder.keyword(" and ");
                }
                SqlIdentifier sqlIdentifier = info2.getLeftTableRef().getIdentifier();
                String string4 = string3 = sqlIdentifier != null ? sqlIdentifier.getText() : null;
                if (string4 == null) {
                    string2 = "?";
                } else {
                    Intrinsics.checkNotNull((Object)string4);
                    string2 = string3;
                }
                builder.plain(string2 + ".");
                builder.identifier((DasObject)column2);
                builder.symbol(" = ");
                SqlIdentifier sqlIdentifier2 = info2.getRightTableRef().getIdentifier();
                String string5 = string3 = sqlIdentifier2 != null ? sqlIdentifier2.getText() : null;
                if (string5 == null) {
                    string = "?";
                } else {
                    Intrinsics.checkNotNull((Object)string5);
                    string = string3;
                }
                builder.plain(string + ".");
                builder.identifier((DasObject)column2);
            }
        } else {
            builder.keyword("true");
        }
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText(builder.getStatement(), (SqlLanguageDialect)dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlJoinConditionClause.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        SqlJoinConditionClause onClause = (SqlJoinConditionClause)psiElement2;
        joinExpression.add((PsiElement)onClause);
        element2.delete();
    }
}

