/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertJoinUsingToOnIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertJoinUsingToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1864#2,3:46\n*S KotlinDebug\n*F\n+ 1 SqlConvertJoinUsingToOnIntention.kt\ncom/intellij/sql/intentions/SqlConvertJoinUsingToOnIntention\n*L\n31#1:46,3\n*E\n"})
public final class SqlConvertJoinUsingToOnIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.using.with.on", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JoinUtilsKt.getJoinUsingInfo(element2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JoinConditionInfo<SqlUsingClause> joinConditionInfo = JoinUtilsKt.getJoinUsingInfo(element2);
        if (joinConditionInfo == null) {
            return;
        }
        JoinConditionInfo<SqlUsingClause> info2 = joinConditionInfo;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)info2.getClause());
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        String joinOp = dialect.getDbms().isClickHouse() ? "all inner join" : "join";
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo " + joinOp + " bar ").keyword("on ");
        Iterable $this$forEachIndexed$iv = info2.getColumnRefs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            String string2;
            String columnName;
            String string3;
            void columnRef;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv;
            int i2 = n;
            boolean bl = false;
            SqlIdentifier sqlIdentifier = columnRef.getIdentifier();
            String string4 = string3 = sqlIdentifier != null ? sqlIdentifier.getText() : null;
            if (string4 == null) {
                v4 = "?";
            } else {
                Intrinsics.checkNotNull((Object)string4);
                v4 = columnName = string3;
            }
            if (i2 > 0) {
                builder.keyword(" and ");
            }
            SqlIdentifier sqlIdentifier2 = info2.getLeftTableRef().getIdentifier();
            String string5 = string3 = sqlIdentifier2 != null ? sqlIdentifier2.getText() : null;
            if (string5 == null) {
                string2 = "?";
            } else {
                Intrinsics.checkNotNull((Object)string5);
                string2 = string3;
            }
            builder.plain(string2 + "." + columnName);
            builder.symbol(" = ");
            SqlIdentifier sqlIdentifier3 = info2.getRightTableRef().getIdentifier();
            String string6 = string3 = sqlIdentifier3 != null ? sqlIdentifier3.getText() : null;
            if (string6 == null) {
                string = "?";
            } else {
                Intrinsics.checkNotNull((Object)string6);
                string = string3;
            }
            builder.plain(string + "." + columnName);
        }
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String queryText2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText(queryText2, (SqlLanguageDialect)dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlJoinConditionClause.class);
        Intrinsics.checkNotNull((Object)psiElement);
        SqlJoinConditionClause onClause = (SqlJoinConditionClause)psiElement;
        info2.getClause().replace((PsiElement)onClause);
    }
}

