/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getTargetExpression", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertBetweenToComparisonIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertBetweenToComparisonIntention.kt\ncom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1747#2,3:58\n*S KotlinDebug\n*F\n+ 1 SqlConvertBetweenToComparisonIntention.kt\ncom/intellij/sql/intentions/SqlConvertBetweenToComparisonIntention\n*L\n29#1:58,3\n*E\n"})
public final class SqlConvertBetweenToComparisonIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.between.expression.with.comparisons", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getTargetExpression(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        boolean bl;
        SqlExpression upperBound;
        SqlExpression lowerBound;
        SqlExpression subject;
        SqlLanguageDialectEx dialect;
        SqlBetweenExpression betweenExpr;
        block9: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            SqlBetweenExpression sqlBetweenExpression = this.getTargetExpression(element2);
            if (sqlBetweenExpression == null) {
                return;
            }
            betweenExpr = sqlBetweenExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)betweenExpr);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            dialect = sqlLanguageDialectEx;
            SqlExpression sqlExpression = betweenExpr.getSubject();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getSubject(...)");
            subject = sqlExpression;
            lowerBound = betweenExpr.getLowerBound();
            upperBound = betweenExpr.getUpperBound();
            JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren(betweenExpr.getOperation());
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_NOT)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isNot = bl;
        boolean needsParentheses = isNot || betweenExpr.getParent() instanceof SqlOperatorExpression;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        if (isNot) {
            builder.keyword("not ");
        }
        if (needsParentheses) {
            builder.symbol("(");
        }
        builder.plain(subject.getText());
        builder.symbol(" >= ");
        SqlExpression sqlExpression = lowerBound;
        String string = sqlExpression != null ? sqlExpression.getText() : null;
        if (string == null) {
            string = "";
        }
        builder.plain(string);
        builder.plain(" and ");
        builder.plain(subject.getText());
        builder.symbol(" <= ");
        SqlExpression sqlExpression2 = upperBound;
        String string2 = sqlExpression2 != null ? sqlExpression2.getText() : null;
        if (string2 == null) {
            string2 = "";
        }
        builder.plain(string2);
        if (needsParentheses) {
            builder.symbol(")");
        }
        SqlExpression sqlExpression3 = SqlPsiElementFactory.createExpressionFromText(builder.getStatement(), dialect, project, null);
        Intrinsics.checkNotNull((Object)sqlExpression3);
        SqlExpression comparisonExpr = sqlExpression3;
        betweenExpr.replace((PsiElement)comparisonExpr);
    }

    private final SqlBetweenExpression getTargetExpression(PsiElement element2) {
        JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBetweenExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return (SqlBetweenExpression)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
    }
}

