/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBinaryInstruction;
import com.intellij.sql.inspections.dataflow.types.SqlDfAbstractRangeType;
import com.intellij.sql.inspections.dataflow.types.SqlDfBigIntType;
import com.intellij.sql.inspections.dataflow.types.SqlDfIntegralType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J;\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlNumericBinaryInstruction;", "Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlBinaryInstruction;", "binOp", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "(Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;Lcom/intellij/sql/psi/SqlExpression;)V", "balanceTypes", "Lkotlin/Pair;", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "right", "left", "doAccept", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "nullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;", "stateBefore", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlNumericBinaryInstruction
extends SqlBinaryInstruction {
    @Nullable
    private final LongRangeBinOp binOp;

    public SqlNumericBinaryInstruction(@Nullable LongRangeBinOp binOp, @NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super(expression);
        this.binOp = binOp;
    }

    @Override
    @NotNull
    public DfaInstructionState[] doAccept(@NotNull DfaValue left, @NotNull DfaValue right, @NotNull SqlDfaNullability nullability, @NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        SqlDfIntegralType rightType;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)stateBefore, (String)"stateBefore");
        DfaValueFactory dfaValueFactory = interpreter.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)dfaValueFactory, (String)"getFactory(...)");
        DfaValueFactory factory = dfaValueFactory;
        DfType dfType = stateBefore.getDfType(left);
        SqlDfIntegralType leftType = dfType instanceof SqlDfIntegralType ? (SqlDfIntegralType)dfType : null;
        DfType dfType2 = stateBefore.getDfType(right);
        SqlDfIntegralType sqlDfIntegralType = rightType = dfType2 instanceof SqlDfIntegralType ? (SqlDfIntegralType)dfType2 : null;
        if (this.binOp == null || leftType == null || rightType == null) {
            this.pushResult(interpreter, stateBefore, SqlDfTypesKt.unknown(nullability), new DfaValue[0]);
            DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
            Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
            return dfaInstructionStateArray;
        }
        SqlDfAbstractRangeType resultType = leftType instanceof SqlDfBigIntType || rightType instanceof SqlDfBigIntType ? (SqlDfAbstractRangeType)SqlDfTypesKt.getBIGINT() : (SqlDfAbstractRangeType)SqlDfTypesKt.getINT();
        this.pushResult(interpreter, stateBefore, factory.getBinOpFactory().create(left, right, stateBefore, (DfIntegralType)resultType, this.binOp), new DfaValue[0]);
        DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
        Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
        return dfaInstructionStateArray;
    }

    @Override
    @NotNull
    public Pair<DfType, DfType> balanceTypes(@NotNull DfType right, @NotNull DfType left) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        LongRangeBinOp longRangeBinOp = this.binOp;
        boolean bl = longRangeBinOp != null ? longRangeBinOp.isShift() : false;
        if (bl) {
            if (this.getDialect().getDbms().isMysql()) {
                return TuplesKt.to(null, null);
            }
            return TuplesKt.to((Object)SqlDfTypesKt.tryCastToInt(right, this.getDialect()), (Object)SqlDfTypesKt.tryCastToIntegral(left, this.getDialect()));
        }
        if (this.binOp == LongRangeBinOp.DIV && this.getDialect().getDbms().isMysql()) {
            return TuplesKt.to((Object)SqlDfTypesKt.tryCastToNumeric(right, this.getDialect()), (Object)SqlDfTypesKt.tryCastToNumeric(left, this.getDialect()));
        }
        return SqlDfTypesKt.balanceTypes(right, left, this.getDialect());
    }

    @NotNull
    public String toString() {
        return this.binOp == null ? "UNKNOWN_NUMERIC_OP" : "NUMERIC_OP " + this.binOp;
    }
}

