/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J;\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlBinaryInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ExpressionPushingInstruction;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "(Lcom/intellij/sql/psi/SqlExpression;)V", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "accept", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;", "stateBefore", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "(Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "balanceTypes", "Lkotlin/Pair;", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "right", "left", "computeNullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "doAccept", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "nullability", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "intellij.database.sql.core.impl"})
public abstract class SqlBinaryInstruction
extends ExpressionPushingInstruction {
    @NotNull
    private final SqlExpression expression;
    @NotNull
    private final SqlLanguageDialectEx dialect;

    public SqlBinaryInstruction(@NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(expression));
        this.expression = expression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)this.expression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        this.dialect = sqlLanguageDialectEx;
    }

    @NotNull
    public final SqlExpression getExpression() {
        return this.expression;
    }

    @NotNull
    protected final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    @NotNull
    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)stateBefore, (String)"stateBefore");
        DfaValue dfaValue = stateBefore.pop();
        Intrinsics.checkNotNullExpressionValue((Object)dfaValue, (String)"pop(...)");
        DfaValue right = dfaValue;
        DfaValue dfaValue2 = stateBefore.pop();
        Intrinsics.checkNotNullExpressionValue((Object)dfaValue2, (String)"pop(...)");
        DfaValue left = dfaValue2;
        DfType dfType = stateBefore.getDfType(right);
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType rightType = dfType;
        DfType dfType2 = stateBefore.getDfType(left);
        Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"getDfType(...)");
        DfType leftType = dfType2;
        Pair<DfType, DfType> balancedTypes = this.balanceTypes(rightType, leftType);
        if (balancedTypes.getFirst() == null || balancedTypes.getSecond() == null) {
            this.pushResult(interpreter, stateBefore, DfType.TOP, new DfaValue[0]);
            DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
            Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
            return dfaInstructionStateArray;
        }
        DfaValueFactory dfaValueFactory = interpreter.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)dfaValueFactory, (String)"getFactory(...)");
        DfaValueFactory factory = dfaValueFactory;
        Object object = balancedTypes.getFirst();
        Intrinsics.checkNotNull((Object)object);
        right = SqlDfaUtilKt.castToType(right, (DfType)object, factory, stateBefore);
        Object object2 = balancedTypes.getSecond();
        Intrinsics.checkNotNull((Object)object2);
        left = SqlDfaUtilKt.castToType(left, (DfType)object2, factory, stateBefore);
        DfType dfType3 = stateBefore.getDfType(left);
        Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"getDfType(...)");
        DfType dfType4 = stateBefore.getDfType(right);
        Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"getDfType(...)");
        SqlDfaNullability nullability = this.computeNullability(dfType3, dfType4);
        if (nullability == SqlDfaNullability.NULL) {
            this.pushResult(interpreter, stateBefore, SqlDfTypesKt.getNULL(), new DfaValue[0]);
            DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
            Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
            return dfaInstructionStateArray;
        }
        return this.doAccept(left, right, nullability, interpreter, stateBefore);
    }

    @NotNull
    public abstract DfaInstructionState[] doAccept(@NotNull DfaValue var1, @NotNull DfaValue var2, @NotNull SqlDfaNullability var3, @NotNull DataFlowInterpreter var4, @NotNull DfaMemoryState var5);

    @NotNull
    public SqlDfaNullability computeNullability(@NotNull DfType left, @NotNull DfType right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return SqlDfTypesKt.nullability(left).eval(SqlDfTypesKt.nullability(right));
    }

    @NotNull
    public Pair<DfType, DfType> balanceTypes(@NotNull DfType right, @NotNull DfType left) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return TuplesKt.to((Object)right, (Object)left);
    }
}

