/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeReference;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.SqlScalarDescriptor;
import com.intellij.sql.inspections.dataflow.SqlTableDescriptor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlVariableDescriptor;", "Lcom/intellij/codeInspection/dataFlow/value/VariableDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "_dasType", "Lcom/intellij/database/types/DasType;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/database/types/DasType;)V", "equals", "", "other", "", "getDasType", "getDfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "qualifier", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "getPsiElement", "hashCode", "", "isStable", "toString", "", "Companion", "intellij.database.sql.core.impl"})
public abstract class SqlVariableDescriptor
implements VariableDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement element;
    @Nullable
    private final DasType _dasType;

    public SqlVariableDescriptor(@NotNull PsiElement element2, @Nullable DasType _dasType) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.element = element2;
        this._dasType = _dasType;
    }

    public boolean isStable() {
        return true;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier) {
        DasType dasType = this.getDasType();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(this.element);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        return SqlDfTypesKt.typedObject(dasType, sqlLanguageDialectEx, SqlDfaNullability.Companion.getElementNullability(this.element));
    }

    @NotNull
    public PsiElement getPsiElement() {
        return this.element;
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = this._dasType;
        if (dasType == null) {
            dasType = SqlVariableDescriptor.Companion.getDasType(this.element);
        }
        return dasType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.SqlVariableDescriptor");
        SqlVariableDescriptor cfr_ignored_0 = (SqlVariableDescriptor)other;
        return Intrinsics.areEqual((Object)this.element, (Object)((SqlVariableDescriptor)other).element);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.element instanceof DasNamed) {
            String string2 = ((DasNamed)this.element).getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        } else {
            string = this.getDasType().toString();
        }
        return string;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    @JvmStatic
    private static final DasType getDasType(PsiElement element2) {
        return SqlVariableDescriptor.Companion.getDasType(element2);
    }

    @JvmStatic
    @Nullable
    public static final SqlVariableDescriptor createVariableDescriptor(@NotNull PsiElement target2, @NotNull DasType dasType) {
        return Companion.createVariableDescriptor(target2, dasType);
    }

    @JvmStatic
    @Nullable
    public static final SqlVariableDescriptor createVariableDescriptor(@NotNull PsiElement target2) {
        return Companion.createVariableDescriptor(target2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0003\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlVariableDescriptor$Companion;", "", "()V", "createVariableDescriptor", "Lcom/intellij/sql/inspections/dataflow/SqlVariableDescriptor;", "target", "Lcom/intellij/psi/PsiElement;", "dasType", "Lcom/intellij/database/types/DasType;", "getDasType", "element", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final DasType getDasType(PsiElement element2) {
            DasType dasType;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            PsiElement psiElement = element2;
            if (psiElement instanceof SqlExpression) {
                DasType dasType2 = ((SqlExpression)element2).getDasType();
                dasType = dasType2;
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            } else if (psiElement instanceof DasTypedObject) {
                DasType dasType3 = ((DasTypedObject)element2).getDasType();
                dasType = dasType3;
                Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
            } else {
                dasType = dialect.getTypeSystem().getDasType(null, element2, null);
            }
            return dasType;
        }

        @JvmStatic
        @Nullable
        public final SqlVariableDescriptor createVariableDescriptor(@NotNull PsiElement target2, @NotNull DasType dasType) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
            return dasType instanceof SqlTableType ? (SqlVariableDescriptor)new SqlTableDescriptor(target2, (SqlTableType)dasType) : (dasType instanceof DasBuiltinType || dasType instanceof DasTypeReference ? (SqlVariableDescriptor)new SqlScalarDescriptor(target2, dasType) : null);
        }

        @JvmStatic
        @Nullable
        public final SqlVariableDescriptor createVariableDescriptor(@NotNull PsiElement target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            return this.createVariableDescriptor(target2, this.getDasType(target2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

