/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlBooleanLiteralExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001a\u001a\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001d\u001a\u0015\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010 \u001a\u0015\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010#\u001a\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0019\u001a\u00020\t\u001a\u0015\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010(\u001a\u0016\u0010)\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006*"}, d2={"fromLiteral", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expr", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getNumericValue", "", "value", "", "dasType", "Lcom/intellij/database/types/DasType;", "getRelationByToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "type", "Lcom/intellij/psi/tree/IElementType;", "dbms", "Lcom/intellij/database/Dbms;", "getRelationForIsExpression", "expression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "opElement", "Lcom/intellij/psi/PsiElement;", "parseBigInt", "", "text", "(Ljava/lang/String;)Ljava/lang/Long;", "parseBoolean", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseNumeric", "Ljava/math/BigDecimal;", "parseReal", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getValue", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDfaPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDfaPsiUtil.kt\ncom/intellij/sql/inspections/dataflow/SqlDfaPsiUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1747#2,3:164\n*S KotlinDebug\n*F\n+ 1 SqlDfaPsiUtil.kt\ncom/intellij/sql/inspections/dataflow/SqlDfaPsiUtilKt\n*L\n44#1:164,3\n*E\n"})
public final class SqlDfaPsiUtilKt {
    @Nullable
    public static final RelationType getRelationByToken(@NotNull IElementType type2, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return SqlPsiUtilKt.isEq(type2, dbms) ? RelationType.EQ : (SqlPsiUtilKt.isNotEq(type2, dbms) ? RelationType.NE : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_GT) ? RelationType.GT : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_LT) ? RelationType.LT : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_LE) ? RelationType.LE : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_GE) ? RelationType.GE : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_NOT_GT) && dbms.isMicrosoft() ? RelationType.LE : (Intrinsics.areEqual((Object)type2, (Object)SqlCommonTokens.SQL_OP_NOT_LT) && dbms.isMicrosoft() ? RelationType.GE : null)))))));
    }

    @NotNull
    public static final RelationType getRelationForIsExpression(@NotNull SqlBinaryExpression expression, @NotNull PsiElement opElement) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)opElement, (String)"opElement");
        return expression.isNot() ^ SqlDfaPsiUtilKt.getRelationForIsExpression$isDistinctFrom(opElement) ? RelationType.NE : RelationType.EQ;
    }

    @NotNull
    public static final DfType fromLiteral(@NotNull SqlLiteralExpression expr, @NotNull SqlLanguageDialectEx dialect) {
        Object value2;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        DasType dasType = expr.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.UNKNOWN)) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"TOP");
            return dfType;
        }
        if (Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.NULL)) {
            return SqlDfTypesKt.getNULL();
        }
        if (DasTypeUtilsKt.getCategory(dasType2) == DasTypeCategory.BOOLEAN && SqlPsiUtilKt.isUnknown((PsiElement)expr)) {
            return SqlDfTypesKt.getNULL();
        }
        Object object = value2 = SqlDfaPsiUtilKt.getValue(expr, dialect);
        return object == null ? (DfType)SqlDfTypesKt.getNOT_NULL() : SqlDfTypesKt.constant(object);
    }

    private static final Object getValue(SqlLiteralExpression $this$getValue, SqlLanguageDialectEx dialect) {
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        String string = $this$getValue.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String text2 = string3;
        string2 = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)$this$getValue));
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL)) {
            boolean bl;
            if (!($this$getValue instanceof SqlBooleanLiteralExpression)) {
                return null;
            }
            if (((SqlBooleanLiteralExpression)$this$getValue).isTrue()) {
                bl = true;
            } else if (((SqlBooleanLiteralExpression)$this$getValue).isFalse()) {
                bl = false;
            } else {
                return null;
            }
            boolean value2 = bl;
            return dbms2.isPostgres() ? (Comparable<Boolean>)Boolean.valueOf(value2) : (Comparable<Boolean>)(dbms2.isMysql() ? Integer.valueOf(SqlUtilFun.toInt(value2)) : null);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL)) {
            DasType dasType = $this$getValue.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return SqlDfaPsiUtilKt.getNumericValue(text2, dasType, dialect);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL)) {
            SqlStringLiteralExpression sqlStringLiteralExpression = $this$getValue instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)$this$getValue : null;
            return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
        }
        return null;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object getNumericValue(String value2, DasType dasType, SqlLanguageDialectEx dialect) {
        Number number;
        block35: {
            block34: {
                DasTypeSystemBase typeSystem;
                Dbms dbms;
                DataType type2;
                block31: {
                    block32: {
                        block33: {
                            block29: {
                                DataType dataType = dasType.toDataType();
                                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                                type2 = dataType;
                                Dbms dbms2 = dialect.getDbms();
                                Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
                                dbms = dbms2;
                                DasTypeSystemBase dasTypeSystemBase = dialect.getTypeSystem();
                                Intrinsics.checkNotNullExpressionValue((Object)dasTypeSystemBase, (String)"getTypeSystem(...)");
                                typeSystem = dasTypeSystemBase;
                                if (!dbms.isPostgres()) break block29;
                                String string = type2.typeName;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                                switch (typeSystem.getNormalizedTypeName(string)) {
                                    case "integer": {
                                        Integer n = SqlDfaPsiUtilKt.parseInt(value2);
                                        number = n;
                                        if (n != null) return number;
                                        number = SqlDfaPsiUtilKt.parseBigInt(value2);
                                        return number;
                                    }
                                    case "bigint": {
                                        number = SqlDfaPsiUtilKt.parseBigInt(value2);
                                        return number;
                                    }
                                    case "numeric": {
                                        number = SqlDfaPsiUtilKt.parseNumeric(value2);
                                        return number;
                                    }
                                    default: {
                                        return null;
                                    }
                                }
                            }
                            if (!dbms.isMicrosoft()) break block31;
                            String string = type2.typeName;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                            String string2 = typeSystem.getNormalizedTypeName(string);
                            switch (string2.hashCode()) {
                                case -2000413939: {
                                    if (!string2.equals("numeric")) {
                                        return null;
                                    }
                                    break block32;
                                }
                                case 97526364: {
                                    if (!string2.equals("float")) {
                                        return null;
                                    }
                                    break block33;
                                }
                                case -1389167889: {
                                    if (string2.equals("bigint")) break;
                                    return null;
                                }
                                case 104431: {
                                    if (!string2.equals("int")) return null;
                                    number = SqlDfaPsiUtilKt.parseInt(value2);
                                    return number;
                                }
                            }
                            number = SqlDfaPsiUtilKt.parseBigInt(value2);
                            return number;
                        }
                        number = SqlDfaPsiUtilKt.parseDouble(value2);
                        return number;
                    }
                    number = SqlDfaPsiUtilKt.parseNumeric(value2);
                    return number;
                    return null;
                }
                if (!dbms.isMysql()) return null;
                String string = type2.typeName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
                String string3 = typeSystem.getNormalizedTypeName(string);
                switch (string3.hashCode()) {
                    case -1325958191: {
                        if (!string3.equals("double")) {
                            return null;
                        }
                        break block34;
                    }
                    case 1542263633: {
                        if (!string3.equals("decimal")) {
                            return null;
                        }
                        break block35;
                    }
                    case -1389167889: {
                        if (string3.equals("bigint")) break;
                        return null;
                    }
                    case 104431: {
                        if (!string3.equals("int")) return null;
                        Integer n = SqlDfaPsiUtilKt.parseInt(value2);
                        number = n;
                        if (n != null) return number;
                        number = SqlDfaPsiUtilKt.parseBigInt(value2);
                        return number;
                    }
                }
                number = SqlDfaPsiUtilKt.parseBigInt(value2);
                return number;
            }
            number = SqlDfaPsiUtilKt.parseDouble(value2);
            return number;
        }
        number = SqlDfaPsiUtilKt.parseNumeric(value2);
        return number;
        return null;
    }

    @Nullable
    public static final Integer parseInt(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            return Integer.parseInt(text2);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static final Long parseBigInt(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            return Long.parseLong(text2);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static final Float parseReal(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            float value2;
            float f = value2 = Float.parseFloat(text2);
            return !Float.isInfinite(f) && !Float.isNaN(f) ? Float.valueOf(value2) : null;
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static final Double parseDouble(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            double value2;
            double d2 = value2 = Double.parseDouble(text2);
            return !Double.isInfinite(d2) && !Double.isNaN(d2) ? Double.valueOf(value2) : null;
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static final BigDecimal parseNumeric(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            return new BigDecimal(text2);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static final Boolean parseBoolean(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string = text2;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        return Intrinsics.areEqual((Object)string3, (Object)"true") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string3, (Object)"false") ? Boolean.valueOf(false) : null);
    }

    private static final boolean getRelationForIsExpression$isDistinctFrom(PsiElement $opElement) {
        boolean bl;
        block3: {
            JBIterable jBIterable = SyntaxTraverser.psiApi().children((Object)$opElement);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"children(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_DISTINCT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

