/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiElement;
import com.intellij.sql.inspections.dataflow.sql.SqlDfaListener;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlDfaAnchor;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblemKind;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0014\u001a\u00020\u001dH\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor;", "Lcom/intellij/sql/inspections/dataflow/sql/SqlDfaListener;", "()V", "constantExpressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor$ConstantResult;", "getConstantExpressions", "()Ljava/util/Map;", "nullabilityProblems", "", "Lcom/intellij/sql/inspections/dataflow/sql/problems/SqlNullabilityProblem;", "getNullabilityProblems", "()Ljava/util/List;", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "getConstantResult", "dfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "removeOverlaps", "Lcom/intellij/psi/PsiElement;", "ConstantResult", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDataFlowInstructionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDataFlowInstructionVisitor.kt\ncom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n1855#2,2:77\n*S KotlinDebug\n*F\n+ 1 SqlDataFlowInstructionVisitor.kt\ncom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor\n*L\n33#1:75,2\n59#1:77,2\n*E\n"})
public final class SqlDataFlowInstructionVisitor
implements SqlDfaListener {
    @NotNull
    private final Map<SqlExpression, ConstantResult> constantExpressions = new HashMap();
    @NotNull
    private final List<SqlNullabilityProblem<?>> nullabilityProblems = new ArrayList();

    @NotNull
    public final Map<SqlExpression, ConstantResult> getConstantExpressions() {
        return this.constantExpressions;
    }

    @NotNull
    public final List<SqlNullabilityProblem<?>> getNullabilityProblems() {
        return this.nullabilityProblems;
    }

    public void beforePush(@NotNull DfaValue[] args2, @NotNull DfaValue value2, @NotNull DfaAnchor anchor2, @NotNull DfaMemoryState state) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)anchor2, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        DfType dfType = state.getDfType(value2);
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType dfType2 = dfType;
        if (!(anchor2 instanceof SqlDfaAnchor)) {
            return;
        }
        PsiElement element2 = ((SqlDfaAnchor)anchor2).getElement();
        if (element2 instanceof SqlExpression && dfType2 instanceof DfConstantType) {
            ConstantResult constantResult = this.getConstantResult(dfType2);
            this.removeOverlaps(this.constantExpressions, element2);
            this.constantExpressions.put((SqlExpression)element2, constantResult);
            if (constantResult == ConstantResult.NULL) {
                JBIterable jBIterable = SqlImplUtil.sqlTraverser(element2).filter(SqlExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlExpression child = (SqlExpression)element$iv;
                    boolean bl = false;
                    this.nullabilityProblems.removeIf(arg_0 -> SqlDataFlowInstructionVisitor.beforePush$lambda$1$lambda$0((Function1)new Function1<SqlNullabilityProblem<?>, Boolean>(child){
                        final /* synthetic */ SqlExpression $child;
                        {
                            this.$child = $child;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull SqlNullabilityProblem<?> it2) {
                            Intrinsics.checkNotNullParameter(it2, (String)"it");
                            return Intrinsics.areEqual(it2.getAnchor(), (Object)this.$child);
                        }
                    }, arg_0));
                }
                if (element2 instanceof SqlReferenceExpression) {
                    SqlNullabilityProblem<PsiElement> sqlNullabilityProblem;
                    ConstantResult targetConstantRes;
                    PsiElement target2 = ((SqlReferenceExpression)element2).resolve();
                    if (target2 instanceof SqlAsExpression) {
                        target2 = (PsiElement)((SqlAsExpression)target2).getExpression();
                    }
                    if ((targetConstantRes = this.constantExpressions.get(target2)) == ConstantResult.NULL) {
                        SqlNullabilityProblemKind sqlNullabilityProblemKind = SqlNullabilityProblemKind.NullExpression.INSTANCE;
                        PsiElement psiElement = target2;
                        Intrinsics.checkNotNull((Object)psiElement);
                        sqlNullabilityProblem = new SqlNullabilityProblem<PsiElement>(element2, sqlNullabilityProblemKind, psiElement);
                    } else {
                        sqlNullabilityProblem = new SqlNullabilityProblem<PsiElement>(element2, SqlNullabilityProblemKind.NullExpression.INSTANCE, element2);
                    }
                    this.nullabilityProblems.add(sqlNullabilityProblem);
                } else {
                    this.nullabilityProblems.add(new SqlNullabilityProblem<PsiElement>(element2, SqlNullabilityProblemKind.NullExpression.INSTANCE, element2));
                }
            }
        }
    }

    private final void removeOverlaps(Map<SqlExpression, ConstantResult> $this$removeOverlaps, PsiElement anchor2) {
        JBIterable jBIterable = SqlImplUtil.sqlTraverser(anchor2).filter(SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlExpression it2 = (SqlExpression)element$iv;
            boolean bl = false;
            $this$removeOverlaps.remove(it2);
        }
    }

    private final ConstantResult getConstantResult(DfType dfType) {
        DfType dfType2 = dfType;
        return Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getTRUE()) ? ConstantResult.TRUE : (Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getFALSE()) ? ConstantResult.FALSE : (Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getNULL()) ? ConstantResult.NULL : ConstantResult.UNKNOWN));
    }

    private static final boolean beforePush$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor$ConstantResult;", "", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "NULL", "UNKNOWN", "intellij.database.sql.core.impl"})
    public static final class ConstantResult
    extends Enum<ConstantResult> {
        public static final /* enum */ ConstantResult TRUE = new ConstantResult();
        public static final /* enum */ ConstantResult FALSE = new ConstantResult();
        public static final /* enum */ ConstantResult NULL = new ConstantResult();
        public static final /* enum */ ConstantResult UNKNOWN = new ConstantResult();
        private static final /* synthetic */ ConstantResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstantResult[] values() {
            return (ConstantResult[])$VALUES.clone();
        }

        public static ConstantResult valueOf(String value2) {
            return Enum.valueOf(ConstantResult.class, value2);
        }

        @NotNull
        public static EnumEntries<ConstantResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constantResultArray = new ConstantResult[]{ConstantResult.TRUE, ConstantResult.FALSE, ConstantResult.NULL, ConstantResult.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

