/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiListItemFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlUnusedCteInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlReturningExpressionImpl;
import com.intellij.util.Query;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedCteInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "Holder", "intellij.database.sql.impl"})
public final class SqlUnusedCteInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<? extends ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlWithQueryExpression(@NotNull SqlWithQueryExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlWithQueryExpression(o2);
                SqlWithClause sqlWithClause = o2.getWithClause();
                Intrinsics.checkNotNullExpressionValue((Object)sqlWithClause, (String)"getWithClause(...)");
                SqlWithClause withClause = sqlWithClause;
                if (o2.getExpression() == null) {
                    return;
                }
                PsiElement psiElement = withClause.getParent();
                if (psiElement == null) {
                    psiElement = (PsiElement)withClause;
                }
                PsiElement scope = psiElement;
                JBIterable jBIterable = withClause.getQueryDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getQueryDefinitions(...)");
                JBIterable queryDefinitions = jBIterable;
                if (queryDefinitions.isEmpty()) {
                    return;
                }
                JBIterable jBIterable2 = queryDefinitions.filter(arg_0 -> createAnnotationVisitor.1.visitSqlWithQueryExpression$lambda$0((Function1)new Function1<SqlAsExpression, Boolean>(this, scope){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;
                    final /* synthetic */ PsiElement $scope;
                    {
                        this.this$0 = $receiver;
                        this.$scope = $scope;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(SqlAsExpression query) {
                        boolean bl;
                        SqlExpression expression = query.getExpression();
                        if (expression != null && !createAnnotationVisitor.1.access$shouldSkipQueryDef(this.this$0, expression)) {
                            boolean bl2;
                            block5: {
                                Query query2 = ReferencesSearch.search((PsiElement)((PsiElement)query), (SearchScope)((SearchScope)new LocalSearchScope(this.$scope)));
                                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"search(...)");
                                Iterable $this$none$iv = (Iterable)query2;
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl2 = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        PsiReference it2 = (PsiReference)element$iv;
                                        boolean bl3 = false;
                                        if (!(!Intrinsics.areEqual((Object)it2.getElement(), (Object)query))) continue;
                                        bl2 = false;
                                        break block5;
                                    }
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                JBIterable unusedQueries2 = jBIterable2;
                Iterable $this$forEach$iv = (Iterable)unusedQueries2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlAsExpression it2 = (SqlAsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    SqlIdentifier sqlIdentifier = it2.getNameElement();
                    this.reportProblem((PsiElement)it2, (TextRange)(sqlIdentifier != null ? sqlIdentifier.getTextRangeInParent() : null), Holder.INSTANCE.getDROP_QUERY_DEFINITION_FIX());
                }
            }

            private final boolean shouldSkipQueryDef(SqlExpression queryBody) {
                return this.$dialect.getDbms().isPostgres() && queryBody instanceof SqlReturningExpressionImpl;
            }

            private final void reportProblem(PsiElement element2, TextRange range, LocalQuickFix fix) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                this.addDescriptor(this.myManager.createProblemDescriptor(element2, range, SqlBundle.message((String)"inspection.message.unused.common.table.expression", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$onTheFly, localQuickFixArray));
            }

            private static final boolean visitSqlWithQueryExpression$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            public static final /* synthetic */ boolean access$shouldSkipQueryDef(createAnnotationVisitor.1 $this, SqlExpression queryBody) {
                return $this.shouldSkipQueryDef(queryBody);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/inspections/SqlUnusedCteInspection$Holder;", "", "()V", "DROP_QUERY_DEFINITION_FIX", "Lcom/intellij/codeInspection/LocalQuickFix;", "getDROP_QUERY_DEFINITION_FIX", "()Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.database.sql.impl"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final LocalQuickFix DROP_QUERY_DEFINITION_FIX = new DropPsiListItemFix("query definition", SqlAsExpression.class, false, 4, null);

        private Holder() {
        }

        @NotNull
        public final LocalQuickFix getDROP_QUERY_DEFINITION_FIX() {
            return DROP_QUERY_DEFINITION_FIX;
        }
    }
}

