/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlUnicodeStringLiteralInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "MakeNationalFix", "intellij.database.sql.impl"})
public final class SqlUnicodeStringLiteralInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isMicrosoft()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlStringLiteralExpression(@NotNull SqlStringLiteralExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                String string = o2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith((CharSequence)string, (char)'n', (boolean)true) || this.isPureAscii(o2.getText())) {
                    return;
                }
                this.addDescriptor(this.myManager.createProblemDescriptor(o2.getNavigationElement(), SqlBundle.message((String)"inspection.message.unicode.strings.should.have.n.prefix", (Object[])new Object[0]), (LocalQuickFix)MakeNationalFix.INSTANCE, ProblemHighlightType.WARNING, this.$onTheFly));
            }

            private final boolean isPureAscii(String testText) {
                return Charset.forName("US-ASCII").newEncoder().canEncode(testText);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlUnicodeStringLiteralInspection$MakeNationalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    public static final class MakeNationalFix
    implements LocalQuickFix {
        @NotNull
        public static final MakeNationalFix INSTANCE = new MakeNationalFix();

        private MakeNationalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.add.n.prefix", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            SqlStringLiteralExpression sqlStringLiteralExpression = psiElement instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)psiElement : null;
            if (sqlStringLiteralExpression == null) {
                return;
            }
            SqlStringLiteralExpression literal = sqlStringLiteralExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)literal);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText("N" + literal.getText(), dialect, project, null);
            if (sqlExpression == null) {
                return;
            }
            SqlExpression newLiteral = sqlExpression;
            literal.replace((PsiElement)newLiteral);
        }
    }
}

