/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.TrigEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlTriggerTransitionInspection;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlAlterTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.TriggerCorrelationKind;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlTriggerTransitionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlTriggerTransitionInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, problems){

            private final SqlCreateTriggerStatementWithFakeTables.FakeSynonym resolveCorrelation(SqlReferenceExpression ref2) {
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym fakeSynonym;
                PsiElement refTarget = ref2.resolve();
                if (refTarget instanceof SqlCreateTriggerStatementWithFakeTables.FakeSynonym) {
                    fakeSynonym = (SqlCreateTriggerStatementWithFakeTables.FakeSynonym)refTarget;
                } else if (refTarget instanceof SqlAsExpression) {
                    PsiElement psiElement;
                    SqlExpression sqlExpression = ((SqlAsExpression)refTarget).getExpression();
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                    Object object = psiElement = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
                    fakeSynonym = psiElement instanceof SqlCreateTriggerStatementWithFakeTables.FakeSynonym ? (SqlCreateTriggerStatementWithFakeTables.FakeSynonym)psiElement : null;
                } else {
                    fakeSynonym = null;
                }
                return fakeSynonym;
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o2) {
                TrigEvent trigEvent;
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlReferenceExpression(o2);
                Class[] classArray = new Class[]{SqlCreateTriggerStatement.class, SqlAlterTriggerStatementWithFakeTables.class};
                SqlElement sqlElement = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o2), (Class[])classArray);
                if (sqlElement == null) {
                    return;
                }
                SqlElement triggerStatement = sqlElement;
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym fakeSynonym = this.resolveCorrelation(o2);
                if (fakeSynonym == null) {
                    return;
                }
                SqlCreateTriggerStatementWithFakeTables.FakeSynonym correlation = fakeSynonym;
                TriggerCorrelationKind triggerCorrelationKind = correlation.getCorrelationKind();
                switch (triggerCorrelationKind == null ? -1 : createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[triggerCorrelationKind.ordinal()]) {
                    case 1: {
                        trigEvent = TrigEvent.INSERT;
                        break;
                    }
                    case 2: {
                        trigEvent = TrigEvent.DELETE;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                TrigEvent contradictoryEvent = trigEvent;
                Set<TrigEvent> set = SqlImplUtil.getTriggerEvents(triggerStatement);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getTriggerEvents(...)");
                if (CollectionsKt.singleOrNull((Iterable)set) == contradictoryEvent) {
                    Object[] objectArray = new Object[]{o2.getName()};
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, SqlBundle.message((String)"inspection.message.will.always.be.empty", (Object[])objectArray), false, new LocalQuickFix[0], ProblemHighlightType.WARNING));
                }
            }
        };
    }
}

