/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlStringLengthExceededInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "IncreaseLengthFix", "intellij.database.sql.impl"})
public final class SqlStringLengthExceededInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression sqlExpression) {
                Object object;
                PsiElement parent2;
                Intrinsics.checkNotNullParameter((Object)sqlExpression, (String)"sqlExpression");
                PsiElement psiElement = parent2 = sqlExpression.getParent();
                if (psiElement instanceof SqlSetAssignment) {
                    it = var7_4 = ((SqlSetAssignment)parent2).getRValue();
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)((SqlSetAssignment)parent2).getLValue(), (Object)sqlExpression) ? var7_4 : null;
                } else if (psiElement instanceof SqlBinaryExpression) {
                    it = var7_4 = ((SqlBinaryExpression)parent2).getROperand();
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)((SqlBinaryExpression)parent2).getOpSign(), (Object)SqlCommonTokens.SQL_OP_ASSIGN) && Intrinsics.areEqual((Object)((SqlBinaryExpression)parent2).getLOperand(), (Object)sqlExpression) ? var7_4 : null;
                } else {
                    object = null;
                }
                SqlElement sqlElement = object;
                SqlStringLiteralExpression sqlStringLiteralExpression = sqlElement instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlElement : null;
                if (sqlStringLiteralExpression == null) {
                    return;
                }
                SqlStringLiteralExpression stringLiteralExpression = sqlStringLiteralExpression;
                psiElement = sqlExpression.resolve();
                SqlVariableDefinition sqlVariableDefinition = psiElement instanceof SqlVariableDefinition ? (SqlVariableDefinition)psiElement : null;
                if (sqlVariableDefinition == null) {
                    return;
                }
                SqlVariableDefinition variableDefinition = sqlVariableDefinition;
                this.reportProblemIfNeeded(variableDefinition, stringLiteralExpression);
                super.visitSqlVariableDefinition(variableDefinition);
            }

            public void visitSqlVariableDefinition(@NotNull SqlVariableDefinition variableDefinition) {
                Intrinsics.checkNotNullParameter((Object)variableDefinition, (String)"variableDefinition");
                SqlExpression sqlExpression = variableDefinition.getInitializer();
                SqlStringLiteralExpression sqlStringLiteralExpression = sqlExpression instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlExpression : null;
                if (sqlStringLiteralExpression == null) {
                    return;
                }
                SqlStringLiteralExpression stringLiteralExpression = sqlStringLiteralExpression;
                this.reportProblemIfNeeded(variableDefinition, stringLiteralExpression);
            }

            private final void reportProblemIfNeeded(SqlVariableDefinition variableDefinition, SqlStringLiteralExpression stringLiteral) {
                DasType dasType = variableDefinition.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                if (DasTypeCategory.STRING != DasTypeUtilsKt.getCategory(dasType)) {
                    return;
                }
                int maxLen = variableDefinition.getDasType().toDataType().getLength();
                String string = stringLiteral.getValue();
                if (string == null) {
                    return;
                }
                int literalLen = string.length();
                if (maxLen < 0 || literalLen <= maxLen) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new IncreaseLengthFix(variableDefinition, literalLen)};
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor((PsiElement)stringLiteral, SqlBundle.message((String)"inspection.message.string.will.be.truncated", (Object[])new Object[0]), true, ProblemHighlightType.WARNING, false, localQuickFixArray);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlStringLengthExceededInspection$IncreaseLengthFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "variableDefinition", "Lcom/intellij/sql/psi/SqlVariableDefinition;", "newSize", "", "(Lcom/intellij/sql/psi/SqlVariableDefinition;I)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlStringLengthExceededInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlStringLengthExceededInspection.kt\ncom/intellij/sql/inspections/SqlStringLengthExceededInspection$IncreaseLengthFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n288#2,2:87\n*S KotlinDebug\n*F\n+ 1 SqlStringLengthExceededInspection.kt\ncom/intellij/sql/inspections/SqlStringLengthExceededInspection$IncreaseLengthFix\n*L\n33#1:87,2\n*E\n"})
    private static final class IncreaseLengthFix
    extends LocalQuickFixOnPsiElement {
        private final int newSize;

        public IncreaseLengthFix(@NotNull SqlVariableDefinition variableDefinition, int newSize) {
            Intrinsics.checkNotNullParameter((Object)variableDefinition, (String)"variableDefinition");
            super((PsiElement)variableDefinition, (PsiElement)variableDefinition);
            this.newSize = newSize;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.increase.type.length", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Object v3;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                SqlVariableDefinition sqlVariableDefinition = startElement instanceof SqlVariableDefinition ? (SqlVariableDefinition)startElement : null;
                if (sqlVariableDefinition == null) {
                    return;
                }
                SqlVariableDefinition variableDefinition = sqlVariableDefinition;
                SqlLiteralExpression sqlLiteralExpression = (SqlLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)variableDefinition.getTypeElement()), SqlLiteralExpression.class);
                if (sqlLiteralExpression == null) {
                    return;
                }
                SqlLiteralExpression literalExpression = sqlLiteralExpression;
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)literalExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlTokens.SQL_INTEGER_TOKEN)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            PsiElement psiElement = v3;
            if (psiElement == null) {
                return;
            }
            PsiElement integerElement = psiElement;
            PsiElement psiElement2 = SqlPsiElementFactory.createLeafFromText(project, SqlImplUtil.getSqlDialectSafe((PsiElement)file), String.valueOf(this.newSize));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createLeafFromText(...)");
            PsiElement lengthElement = psiElement2;
            integerElement.replace(lengthElement);
        }
    }
}

