/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlSideEffectsInspection
extends SqlInspectionBase {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    ExecutionFlowAnalyzer.FlowTransformer<@InspectionMessage String> TRANSFORMER = new ExecutionFlowAnalyzer.FlowTransformer<String>(){

        @InspectionMessage
        public String common() {
            return SqlBundle.message((String)"inspection.message.this.statement.may.cause.side.effects", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String dml() {
            return SqlBundle.message((String)"inspection.message.this.statement.will.lead.to.modification.data", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String ddl() {
            return SqlBundle.message((String)"inspection.message.this.statement.will.lead.to.modification.database", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String routine() {
            return SqlBundle.message((String)"inspection.message.this.routine.may.cause.side.effects", (Object[])new Object[0]);
        }
    };

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            @Override
            public void visitSqlElement(SqlElement o2) {
                LocalDataSource dataSource2;
                super.visitSqlElement(o2);
                ExecutionFlowAnalyzer analyzer = SqlPsiFacade.getInstance((Project)o2.getProject()).getExecutionFlowAnalyzer(o2.getLanguage());
                if (analyzer == null) {
                    return;
                }
                VirtualFile file = o2.getContainingFile().getVirtualFile();
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(o2.getProject(), file);
                LocalDataSource localDataSource = dataSource2 = console == null ? null : console.getDataSource();
                if (dataSource2 == null || !dataSource2.isReadOnly() || !analyzer.isAcceptable((PsiElement)o2)) {
                    return;
                }
                ExecutionFlowAnalyzer.Flow flow = analyzer.analyze((PsiElement)o2);
                if (flow.isPure() == ThreeState.YES) {
                    return;
                }
                String reason = (String)flow.transform(TRANSFORMER);
                if (reason == null) {
                    return;
                }
                MakeDataSourceWritable fix = new MakeDataSourceWritable(dataSource2);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, reason, true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[]{fix}));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MakeDataSourceWritable
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final LocalDataSource myDataSource;

        public MakeDataSourceWritable(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(2);
            }
            this.myDataSource.setReadOnly(false);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"disable.read.only.mode", (Object[])new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

