/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.RenamePsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddAsFix", "AddCommaFix", "intellij.database.sql.impl"})
public final class SqlShadowingAliasInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(dialect, manager, result2, onTheFly){
            @NotNull
            private final Casing casing;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
                Casing casing = $dialect.getCasing(ObjectKind.COLUMN, null);
                Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
                this.casing = casing;
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (o2 instanceof SqlWithQueryExpression) {
                    super.visitSqlQueryExpression(o2);
                }
                SqlSelectClause sqlSelectClause = o2.getSelectClause();
                if (sqlSelectClause == null) {
                    return;
                }
                SqlSelectClause selectClause = sqlSelectClause;
                SqlTableExpression sqlTableExpression = o2.getTableExpression();
                if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getDasType()) == null) {
                    return;
                }
                SqlTableExpression originalType = sqlTableExpression;
                HashSet<E> columnNames = new HashSet<E>();
                for (int i2 = 0; i2 < originalType.getColumnCount(); ++i2) {
                    ((Collection)columnNames).add(SqlImplUtil.getEffectiveName(originalType.getColumnName(i2), originalType.isColumnQuoted(i2), this.casing));
                }
                for (SqlExpression expression : selectClause.getExpressions()) {
                    String effectiveName;
                    SqlIdentifier nameElement;
                    if (!(expression instanceof SqlAsExpression) || ((SqlAsExpression)expression).getNameElement() == null || !(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)((PsiElement)nameElement)) instanceof SqlExpression)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)SqlImplUtil.getEffectiveName(nameElement.getName(), nameElement.isQuotedIdentifier(), this.casing), (String)"getEffectiveName(...)");
                    if (!columnNames.contains(effectiveName)) continue;
                    this.reportProblem(nameElement);
                }
            }

            private final void reportProblem(SqlIdentifier anchor2) {
                Object[] objectArray = new Object[]{anchor2.getName()};
                String string = SqlBundle.message((String)"inspection.message.shadowing.alias", (Object[])objectArray);
                objectArray = new LocalQuickFix[]{AddCommaFix.INSTANCE, AddAsFix.INSTANCE, RenamePsiFix.INSTANCE};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)anchor2, (PsiElement)anchor2, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, (LocalQuickFix[])objectArray));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddAsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    private static final class AddAsFix
    implements LocalQuickFix {
        @NotNull
        public static final AddAsFix INSTANCE = new AddAsFix();

        private AddAsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.as", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            SqlAsExpression sqlAsExpression = psiElement2 instanceof SqlAsExpression ? (SqlAsExpression)psiElement2 : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)id);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            String string = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect()).keyword("as").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
            String keywordText = string;
            PsiFile psiFile = alias.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            IntentionUtilsKt.modifyDocument(psiFile, (Function1<? super Document, Unit>)((Function1)new Function1<Document, Unit>(id, keywordText){
                final /* synthetic */ SqlIdentifier $id;
                final /* synthetic */ String $keywordText;
                {
                    this.$id = $id;
                    this.$keywordText = $keywordText;
                    super(1);
                }

                public final void invoke(@NotNull Document $this$modifyDocument) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyDocument, (String)"$this$modifyDocument");
                    $this$modifyDocument.insertString(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.$id)), (CharSequence)(this.$keywordText + " "));
                }
            }));
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)alias);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlShadowingAliasInspection$AddCommaFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    private static final class AddCommaFix
    implements LocalQuickFix,
    HighPriorityAction {
        @NotNull
        public static final AddCommaFix INSTANCE = new AddCommaFix();

        private AddCommaFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.comma", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getStartElement();
            SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
            if (sqlIdentifier == null) {
                return;
            }
            SqlIdentifier id = sqlIdentifier;
            PsiElement psiElement2 = id.getParent();
            SqlAsExpression sqlAsExpression = psiElement2 instanceof SqlAsExpression ? (SqlAsExpression)psiElement2 : null;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression alias = sqlAsExpression;
            PsiElement parent2 = alias.getParent();
            SqlExpression sqlExpression = alias.getExpression();
            if (sqlExpression == null) {
                return;
            }
            SqlExpression expression = sqlExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)id);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            PsiElement psiElement3 = SqlPsiElementFactory.createLeafFromText(parent2.getProject(), dialect, ",");
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"createLeafFromText(...)");
            PsiElement comma = psiElement3;
            SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(id.getText(), dialect, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, parent2);
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression newRef = sqlReferenceExpression;
            PsiElement commaInPlace = parent2.addAfter(comma, (PsiElement)alias);
            PsiElement refInPlace = parent2.addAfter((PsiElement)newRef, commaInPlace);
            alias.replace((PsiElement)expression);
            CodeStyleManager.getInstance((Project)project).reformat(refInPlace);
        }
    }
}

