/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlReturnInstruction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlMissingReturnInspection;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlControlFlowHolder;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlMissingReturnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlMissingReturnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSqlCreateProcedureStatement(@NotNull SqlCreateProcedureStatement o2) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateProcedureStatement(o2);
                if (!(o2 instanceof SqlCreateFunctionStatementImpl) || ((SqlCreateFunctionStatementImpl)o2).getBody().isEmpty()) {
                    return;
                }
                SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph((SqlRoutineDefinition)o2);
                Set<SqlInstruction> unreachableInstructions = FlowUtilKt.findUnreachableInstructions(flowGraph);
                JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$0(createAnnotationVisitor.visitSqlCreateProcedureStatement.badElements.1.INSTANCE, arg_0)).withRoot((Object)flowGraph.getExitPoint())).expandAndSkip(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$1(createAnnotationVisitor.visitSqlCreateProcedureStatement.badElements.2.INSTANCE, arg_0))).postOrderDfsTraversal().filter(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$2((Function1)new Function1<SqlInstruction, Boolean>(unreachableInstructions){
                    final /* synthetic */ Set<SqlInstruction> $unreachableInstructions;
                    {
                        this.$unreachableInstructions = $unreachableInstructions;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(SqlInstruction it2) {
                        return !(it2 instanceof SqlReturnInstruction) && !this.$unreachableInstructions.contains(it2);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable iterable = (Iterable)jBIterable;
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it2;
                    SqlInstruction sqlInstruction = (SqlInstruction)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl = false;
                    collection2.add(it2.getOwnerGraph().getSource());
                }
                LinkedHashSet badElements2 = (LinkedHashSet)destination$iv;
                for (SqlControlFlowHolder badElement : badElements2) {
                    JBIterable jBIterable2 = badElement.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getBody(...)");
                    SqlElement sqlElement = (SqlElement)CollectionsKt.lastOrNull((Iterable)((Iterable)jBIterable2));
                    if (sqlElement == null || (sqlElement = this.getAnchor(sqlElement)) == null) continue;
                    this.reportProblem((PsiElement)sqlElement);
                }
            }

            private final PsiElement getAnchor(SqlElement $this$getAnchor) {
                PsiElement psiElement;
                if ($this$getAnchor instanceof SqlBlockStatement) {
                    psiElement = ((SqlBlockStatement)$this$getAnchor).getExceptionClause();
                    if (psiElement == null || (psiElement = psiElement.getFirstChild()) == null) {
                        psiElement = ((SqlBlockStatement)$this$getAnchor).getLastChild();
                    }
                } else {
                    psiElement = $this$getAnchor.getFirstChild();
                }
                return psiElement;
            }

            private final void reportProblem(PsiElement anchor2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlBundle.message((String)"inspection.message.missing.return.statement", (Object[])new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private static final Iterable visitSqlCreateProcedureStatement$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Iterable)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

