/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.ComputedInsertPolicy;
import com.intellij.sql.inspections.IdentityInsertPolicy;
import com.intellij.sql.inspections.SqlInsertIntoGeneratedColumnInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlInspectionUtilsKt;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertOverridingClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "SurroundWithSetIdentityFix", "intellij.database.sql.impl"})
public final class SqlInsertIntoGeneratedColumnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        ComputedInsertPolicy computedPolicy = SqlInspectionUtilsKt.getComputedInsertPolicy(dbms2);
        IdentityInsertPolicy identityPolicy = SqlInspectionUtilsKt.getIdentityInsertPolicy(dbms2);
        if (computedPolicy == ComputedInsertPolicy.ALWAYS && identityPolicy == IdentityInsertPolicy.ALWAYS) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, computedPolicy, identityPolicy, onTheFly){
            final /* synthetic */ ComputedInsertPolicy $computedPolicy;
            final /* synthetic */ IdentityInsertPolicy $identityPolicy;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$computedPolicy = $computedPolicy;
                this.$identityPolicy = $identityPolicy;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlInsertStatement(@NotNull SqlInsertStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o2.getDmlInstruction();
                if (sqlInsertDmlInstruction == null) {
                    return;
                }
                SqlInsertDmlInstruction dmlInstruction = sqlInsertDmlInstruction;
                SqlTableColumnsList columnsList = dmlInstruction.getColumnsList();
                SqlTableType targetType = dmlInstruction.getTargetType();
                int n = targetType.getColumnCount();
                for (int index2 = 0; index2 < n; ++index2) {
                    PsiColumn column2;
                    Object object;
                    PsiElement psiElement = targetType.getColumnElement(index2);
                    SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                    if (sqlReferenceExpression != null) {
                        PsiElement it2 = psiElement = sqlReferenceExpression;
                        boolean bl = false;
                        object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)columnsList), (PsiElement)it2, (boolean)true) ? psiElement : null;
                    } else {
                        object = null;
                    }
                    PsiElement columnRef = object;
                    PsiElement psiElement2 = targetType.getSourceColumnElement(index2);
                    if ((psiElement2 instanceof PsiColumn ? (PsiColumn)psiElement2 : null) == null) continue;
                    column2 = column2;
                    if (SqlImplUtil.isComputedVal(column2)) {
                        this.checkComputed((SqlReferenceExpression)columnRef, dmlInstruction, index2);
                        continue;
                    }
                    if (!SqlImplUtil.isAutoVal(column2)) continue;
                    this.checkIdentity(column2, (SqlReferenceExpression)columnRef, dmlInstruction, index2);
                }
            }

            private final void checkComputed(SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[this.$computedPolicy.ordinal()]) {
                    case 1: {
                        String string = SqlBundle.message((String)"inspection.message.insertion.into.generated.column.not.supported", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.reportOnColumnOrTableRef(string, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        String string = SqlBundle.message((String)"inspection.message.only.default.may.be.inserted.into.generated.column", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.checkDefault(string, dmlInstruction, index2, columnRef);
                        break;
                    }
                    case 3: {
                        return;
                    }
                }
            }

            private final void checkDefault(@InspectionMessage String message2, SqlInsertDmlInstruction dmlInstruction, int index2, SqlReferenceExpression columnRef) {
                SqlValuesExpression sqlValuesExpression = dmlInstruction.getValuesExpression();
                if (sqlValuesExpression != null && (sqlValuesExpression = sqlValuesExpression.getExpressions()) != null) {
                    Iterable $this$forEach$iv = (Iterable)sqlValuesExpression;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        boolean isDefaultExpr;
                        SqlExpression sqlExpression;
                        List list;
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl = false;
                        Object object = it2 instanceof SqlExpressionList ? (SqlExpressionList)it2 : null;
                        if (object != null && (object = (list = object.getExpressionList())) != null) {
                            Intrinsics.checkNotNull((Object)object);
                            sqlExpression = (SqlExpression)CollectionsKt.getOrNull((List)list, (int)index2);
                        } else {
                            sqlExpression = null;
                        }
                        SqlExpression columnExpr = sqlExpression;
                        boolean bl2 = isDefaultExpr = columnExpr instanceof SqlLiteralExpression && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((SqlLiteralExpression)columnExpr).getFirstChild()), (Object)SqlCommonKeywords.SQL_DEFAULT);
                        if (columnExpr == null || isDefaultExpr) continue;
                        createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnExpr, message2, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                    }
                }
                if (columnRef != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)columnRef, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, 8, null);
                }
            }

            private final void checkIdentity(PsiColumn column2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction, int index2) {
                String string = SqlBundle.message((String)"inspection.message.insertion.into.identity.autoincrement.column.not.supported", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String errorMessage = string;
                switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$1[this.$identityPolicy.ordinal()]) {
                    case 1: {
                        this.reportOnColumnOrTableRef(errorMessage, columnRef, dmlInstruction);
                        break;
                    }
                    case 2: {
                        if (columnRef == null || this.hasSetIdentityInsert(dmlInstruction)) {
                            return;
                        }
                        this.reportIssue((SqlElement)columnRef, errorMessage, ProblemHighlightType.GENERIC_ERROR, SurroundWithSetIdentityFix.INSTANCE);
                        break;
                    }
                    case 3: {
                        if (PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dmlInstruction), SqlInsertOverridingClause.class) != null) {
                            return;
                        }
                        if (!this.isForcedAutoVal(column2)) {
                            return;
                        }
                        String string2 = SqlBundle.message((String)"inspection.message.only.default.may.be.inserted.into.identity.autoincrement.column", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        this.checkDefault(string2, dmlInstruction, index2, columnRef);
                        break;
                    }
                    case 4: {
                        return;
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean isForcedAutoVal(PsiColumn $this$isForcedAutoVal) {
                boolean bl;
                block7: {
                    Object v1;
                    block6: {
                        void $this$firstOrNull$iv;
                        if (!($this$isForcedAutoVal instanceof SqlColumnDefinition)) {
                            return false;
                        }
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren($this$isForcedAutoVal);
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                        Iterable iterable = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    PsiElement psiElement = v1;
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement identityClause = psiElement;
                    JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren(identityClause);
                    Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                    Iterable $this$any$iv = (Iterable)jBIterable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it3 = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it3), (Object)SqlCommonKeywords.SQL_ALWAYS)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private final boolean hasSetIdentityInsert(SqlInsertDmlInstruction dmlInstruction) {
                for (PsiElement currentContext = dmlInstruction.getParent(); currentContext != null && !(currentContext instanceof SqlBatchBlock) && !(currentContext instanceof SqlFile); currentContext = currentContext.getParent()) {
                    Object v1;
                    block2: {
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.revSiblings(currentContext);
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"revSiblings(...)");
                        Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it2);
                            if (!this.isSetIdentityInsert(it2, dmlInstruction)) continue;
                            v1 = element$iv;
                            break block2;
                        }
                        v1 = null;
                    }
                    PsiElement setClause = v1;
                    if (setClause == null) continue;
                    return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)setClause.getLastChild()), (Object)SqlCommonKeywords.SQL_ON);
                }
                return false;
            }

            private final boolean isSetIdentityInsert(PsiElement element2, SqlInsertDmlInstruction dmlInstruction) {
                if (!(element2 instanceof SqlSetStatement)) {
                    return false;
                }
                PsiElement psiElement = ((SqlSetStatement)element2).getFirstChild();
                if (psiElement == null) {
                    return false;
                }
                PsiElement anchor2 = psiElement;
                PsiElement psiElement2 = PsiTreeUtil.findSiblingForward((PsiElement)anchor2, (IElementType)((IElementType)SqlCommonKeywords.SQL_IDENTITY_INSERT), (boolean)true, null);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement identityInsert = psiElement2;
                PsiElement psiElement3 = PsiTreeUtil.findSiblingForward((PsiElement)identityInsert, (IElementType)((IElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE), (boolean)true, null);
                SqlReferenceExpression sqlReferenceExpression = psiElement3 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement3 : null;
                if (sqlReferenceExpression == null) {
                    return false;
                }
                SqlReferenceExpression tableRef = sqlReferenceExpression;
                SqlExpression sqlExpression = dmlInstruction.getTargetExpression();
                SqlReferenceExpression sqlReferenceExpression2 = sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
                if (sqlReferenceExpression2 == null) {
                    return false;
                }
                SqlReferenceExpression insertTableRef = sqlReferenceExpression2;
                PsiElement psiElement4 = tableRef.resolve();
                if (psiElement4 == null) {
                    return false;
                }
                PsiElement affectedTable = psiElement4;
                PsiElement psiElement5 = insertTableRef.resolve();
                if (psiElement5 == null) {
                    return false;
                }
                PsiElement insertTable = psiElement5;
                return Intrinsics.areEqual((Object)affectedTable, (Object)insertTable);
            }

            private final void reportOnColumnOrTableRef(@InspectionMessage String message2, SqlReferenceExpression columnRef, SqlInsertDmlInstruction dmlInstruction) {
                SqlExpression anchor2;
                SqlReferenceExpression sqlReferenceExpression = columnRef;
                SqlExpression sqlExpression = anchor2 = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : dmlInstruction.getTargetExpression();
                if (anchor2 != null) {
                    createAnnotationVisitor.1.reportIssue$default(this, (SqlElement)anchor2, message2, ProblemHighlightType.GENERIC_ERROR, null, 8, null);
                }
            }

            private final void reportIssue(SqlElement element2, @InspectionMessage String message2, ProblemHighlightType level, LocalQuickFix fix) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element2, message2, fix, level, this.$onTheFly));
            }

            static /* synthetic */ void reportIssue$default(createAnnotationVisitor.1 var0, SqlElement sqlElement, String string, ProblemHighlightType problemHighlightType, LocalQuickFix localQuickFix, int n, Object object) {
                if ((n & 8) != 0) {
                    localQuickFix = null;
                }
                var0.reportIssue(sqlElement, string, problemHighlightType, localQuickFix);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlInsertIntoGeneratedColumnInspection$SurroundWithSetIdentityFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.sql.impl"})
    public static final class SurroundWithSetIdentityFix
    implements LocalQuickFix {
        @NotNull
        public static final SurroundWithSetIdentityFix INSTANCE = new SurroundWithSetIdentityFix();

        private SurroundWithSetIdentityFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.surround.with.set.identity.insert", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), SqlInsertStatement.class);
            if (sqlInsertStatement == null) {
                return;
            }
            SqlInsertStatement insertStatement = sqlInsertStatement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getTargetExpression()) == null) {
                return;
            }
            SqlInsertDmlInstruction targetExpression = sqlInsertDmlInstruction;
            PsiElement psiElement = insertStatement.getParent();
            if (psiElement == null) {
                return;
            }
            PsiElement parent2 = psiElement;
            PsiFile file = parent2.getContainingFile();
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)insertStatement));
            LeafPsiElement leafPsiElement = psiElement2 instanceof LeafPsiElement ? (LeafPsiElement)psiElement2 : null;
            if (leafPsiElement != null) {
                PsiElement it2 = psiElement2 = leafPsiElement;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it2.getText(), (Object)DbSqlUtil.getDelimiterAt(file, insertStatement.getTextOffset())) ? psiElement2 : null;
            } else {
                object = null;
            }
            PsiElement delimiter = object;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
            String string = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" ON").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
            String setOnText = string;
            builder.clear();
            String string2 = builder.keyword("SET IDENTITY_INSERT ").plain(targetExpression.getText()).keyword(" OFF").getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
            String setOffText = string2;
            SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText(setOnText, dialect, project, null);
            Intrinsics.checkNotNull((Object)sqlStatement);
            SqlStatement it3 = sqlStatement;
            boolean bl = false;
            PsiElement setOnStatement = parent2.addBefore((PsiElement)it3, (PsiElement)insertStatement);
            SqlStatement sqlStatement2 = SqlPsiElementFactory.createStatementFromText(setOffText, dialect, project, null);
            Intrinsics.checkNotNull((Object)sqlStatement2);
            SqlStatement it4 = sqlStatement2;
            boolean bl2 = false;
            PsiElement psiElement3 = (PsiElement)it4;
            PsiElement psiElement4 = delimiter;
            if (psiElement4 == null) {
                psiElement4 = insertStatement;
            }
            PsiElement setOffStatement = parent2.addAfter(psiElement3, psiElement4);
            if (delimiter != null) {
                parent2.addAfter(delimiter, setOnStatement);
                parent2.addAfter(delimiter, setOffStatement);
            }
        }
    }
}

