/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlDuplicateColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlDuplicateColumnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSqlSelectClause(@NotNull SqlSelectClause o2) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                List list = o2.getExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
                Iterable $this$groupBy$iv = list;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    String string;
                    SqlExpression it2 = (SqlExpression)element$iv$iv;
                    boolean bl = false;
                    Object object3 = it2 instanceof SqlAsExpression ? (SqlAsExpression)it2 : null;
                    if (object3 != null && (object3 = object3.getName()) != null) {
                        Object it3 = object3;
                        boolean bl2 = false;
                        string = StringUtil.toLowerCase((String)it3);
                    } else {
                        string = null;
                    }
                    String key$iv$iv = string;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    String name2 = (String)entry.getKey();
                    List columns2 = (List)entry.getValue();
                    if (name2 == null || !this.hasUnmatchedReferences(columns2)) continue;
                    this.reportError(name2, columns2);
                }
            }

            private final boolean hasUnmatchedReferences(List<? extends SqlExpression> columns2) {
                if (columns2.size() <= 1) {
                    return false;
                }
                PsiElement lastTarget = null;
                PsiElement lastQualifier = null;
                for (SqlExpression sqlExpression : columns2) {
                    SqlResolveResult resolveResult;
                    SqlReferenceExpression ref2;
                    ResolveResult resolveResult2;
                    SqlAsExpression sqlAsExpression = sqlExpression instanceof SqlAsExpression ? (SqlAsExpression)sqlExpression : null;
                    SqlExpression sqlExpression2 = sqlAsExpression != null ? sqlAsExpression.getExpression() : null;
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression2 : null;
                    if (sqlReferenceExpression == null || ((resolveResult2 = (ref2 = sqlReferenceExpression).getReference().resolveSingle()) instanceof SqlResolveResult ? (SqlResolveResult)resolveResult2 : null) == null) continue;
                    resolveResult = resolveResult;
                    PsiElement currentTarget = resolveResult.getElement();
                    PsiElement currentQualifier = resolveResult.getQualifier();
                    if (lastTarget != null && !Intrinsics.areEqual((Object)currentTarget, lastTarget) || lastQualifier != null && !Intrinsics.areEqual((Object)currentQualifier, lastQualifier)) {
                        return true;
                    }
                    lastTarget = currentTarget;
                    lastQualifier = currentQualifier;
                }
                return false;
            }

            private final void reportError(String name2, List<? extends SqlExpression> columns2) {
                Object[] objectArray = new Object[]{name2};
                String string = SqlBundle.message((String)"inspection.message.column.name.specified.more.than.once", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message2 = string;
                for (SqlExpression sqlExpression : columns2) {
                    this.addDescriptor(this.$manager.createProblemDescriptor((PsiElement)sqlExpression, message2, true, ProblemHighlightType.GENERIC_ERROR, this.$onTheFly, new LocalQuickFix[0]));
                }
            }
        };
    }
}

