/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.dataflow.SqlDataFlowInstructionVisitor;
import com.intellij.sql.inspections.dataflow.SqlDataFlowRunner;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlDfaProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblemKind;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlConstantExpressionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "MyConvertFix", "intellij.database.sql.impl"})
public final class SqlConstantExpressionInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            private int inQuery;
            private int inConditionClause;
            @NotNull
            private final HashSet<PsiElement> processedElements;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$dialect = $dialect;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
                this.processedElements = new HashSet<E>();
            }

            public final int getInQuery() {
                return this.inQuery;
            }

            public final void setInQuery(int n) {
                this.inQuery = n;
            }

            public final int getInConditionClause() {
                return this.inConditionClause;
            }

            public final void setInConditionClause(int n) {
                this.inConditionClause = n;
            }

            @NotNull
            public final HashSet<PsiElement> getProcessedElements() {
                return this.processedElements;
            }

            private final void runDFA(SqlStatement statement2) {
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Dbms dbms2 = dbms;
                if (dbms2.isPostgres() || dbms2.isMysql() || dbms2.isMicrosoft()) {
                    Project project = statement2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    SqlDataFlowRunner runner = new SqlDataFlowRunner(project, null, 2, null);
                    List<DfaMemoryState> list = Collections.singletonList(runner.createMemoryState());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
                    this.analyseStatement(statement2, runner, list);
                }
            }

            public void visitSqlStatement(@NotNull SqlStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlStatement(o2);
                this.inQuery = 0;
            }

            public void visitSqlSelectStatement(@NotNull SqlSelectStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlSelectStatement(o2);
                this.runDFA((SqlStatement)o2);
            }

            public void visitSqlDmlStatement(@NotNull SqlDmlStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlDmlStatement(o2);
                this.runDFA((SqlStatement)o2);
            }

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlQueryExpression(o2);
                int n = this.inQuery;
                this.inQuery = n + 1;
            }

            public void visitSqlWhereClause(@NotNull SqlWhereClause o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                this.inConditionClause((SqlElement)o2);
            }

            public void visitSqlHavingClause(@NotNull SqlHavingClause o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                this.inConditionClause((SqlElement)o2);
            }

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                this.inConditionClause((SqlElement)o2);
            }

            public void elementFinished(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                if (element2 instanceof SqlQueryExpression) {
                    int n = this.inQuery;
                    this.inQuery = n + -1;
                } else if (element2 instanceof SqlWhereClause || element2 instanceof SqlHavingClause || element2 instanceof SqlJoinExpression) {
                    int n = this.inConditionClause;
                    this.inConditionClause = n + -1;
                }
            }

            public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlElement((SqlElement)o2);
                this.checkConstantExpression(o2);
                this.checkNullComparison(o2);
            }

            private final void checkConstantExpression(SqlBinaryExpression o2) {
                for (PsiElement e2 : PsiTreeUtilKt.parents((PsiElement)((PsiElement)o2), (boolean)true)) {
                    if (!this.processedElements.contains(e2)) continue;
                    return;
                }
                if (this.inConditionClause == 0) {
                    return;
                }
                if (this.inConditionClause % 2 != this.inQuery % 2) {
                    return;
                }
                SqlExpression sqlExpression = o2.getLOperand();
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
                SqlExpression left = sqlExpression;
                SqlExpression right = o2.getROperand();
                IElementType sign = o2.getOpSign();
                if (left instanceof SqlSpecialLiteralExpression || right instanceof SqlSpecialLiteralExpression) {
                    return;
                }
                if (left instanceof SqlLiteralExpression && right instanceof SqlLiteralExpression && this.isComparisonOperator(sign) && StringUtil.equals((CharSequence)left.getText(), (CharSequence)((SqlLiteralExpression)right).getText())) {
                    this.reportProblem(o2);
                    return;
                }
                if (!(left instanceof SqlReferenceExpression) || !(right instanceof SqlReferenceExpression)) {
                    return;
                }
                if (((SqlReferenceExpression)left).getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && ((SqlReferenceExpression)right).getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && this.isComparisonOperator(sign)) {
                    if (!this.sameTargets((PsiElement)left, (PsiElement)right)) {
                        return;
                    }
                    PsiElement leftTarget = ((SqlReferenceExpression)left).resolve();
                    if (leftTarget instanceof DasColumn && !((DasColumn)leftTarget).isNotNull()) {
                        return;
                    }
                    this.reportProblem(o2);
                }
            }

            private final boolean checkNullComparison(SqlBinaryExpression o2) {
                if (this.processedElements.contains(o2)) {
                    return false;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o2), SqlFunctionCallExpression.class) != null) {
                    return false;
                }
                return this.checkNullComparison(o2, true) || this.checkNullComparison(o2, false);
            }

            public final boolean checkNullComparison(@NotNull SqlBinaryExpression o2, boolean left) {
                boolean neq;
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                IElementType sign = o2.getOpSign();
                SqlExpression r = o2.getROperand();
                SqlExpression sqlExpression = o2.getLOperand();
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
                SqlExpression l = sqlExpression;
                SqlExpression operand = left ? l : r;
                SqlExpression opposite = left ? r : l;
                boolean eq = sign == SqlCommonTokens.SQL_OP_EQ;
                boolean bl = neq = sign == SqlCommonTokens.SQL_OP_NEQ || sign == SqlCommonTokens.SQL_OP_NEQ2 || sign == SqlCommonTokens.SQL_OP_NEQ3 || sign == SqlCommonTokens.SQL_OP_NEQ_WS || sign == SqlCommonTokens.SQL_OP_NEQ2_WS || sign == SqlCommonTokens.SQL_OP_NEQ3_WS;
                if ((eq || neq) && opposite != null && operand instanceof SqlSpecialLiteralExpression && ((SqlSpecialLiteralExpression)operand).isNull()) {
                    if (this.$dialect.getDbms().isTransactSql() && opposite instanceof SqlReferenceExpression && ((SqlReferenceExpression)opposite).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE) {
                        SqlSelectClause selectClause;
                        SqlQueryExpression query;
                        SqlQueryExpression sqlQueryExpression = query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o2), SqlQueryExpression.class);
                        Object object = selectClause = sqlQueryExpression != null ? sqlQueryExpression.getSelectClause() : null;
                        if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)((PsiElement)o2), (boolean)true)) {
                            return false;
                        }
                    }
                    DdlBuilder ddlBuilder = new DdlBuilder().applyCodeStyle(o2.getProject(), SqlImplUtil.getSqlDialectSafe((PsiElement)o2)).keyword("IS");
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"keyword(...)");
                    DdlBuilder builder = ddlBuilder;
                    if (neq) {
                        builder.space().keyword("NOT");
                    }
                    String string = builder.space().keyword("NULL").getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
                    String what = string;
                    Object[] objectArray = new Object[]{what};
                    String string2 = SqlBundle.message((String)"inspection.message.suspicious.comparison.with.null.probably.operator.should.be.used", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String text2 = string2;
                    Object[] objectArray2 = new Object[]{StringUtil.toUpperCase((String)what)};
                    String string3 = SqlBundle.message((String)"intention.family.name.use.operator", (Object[])objectArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    String title = string3;
                    String replacement = opposite.getText() + " " + what;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, text2, (LocalQuickFix)new MyConvertFix(title, replacement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                    return true;
                }
                return false;
            }

            private final void reportProblem(SqlBinaryExpression expression) {
                IElementType sign = expression.getOpSign();
                boolean messageTrue = sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE;
                Object[] objectArray = new Object[]{expression.getText()};
                String string = SqlBundle.message((String)(messageTrue ? "condition.always.true" : "condition.always.false"), (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message2 = string;
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }

            private final void inConditionClause(SqlElement o2) {
                int n;
                super.visitSqlElement(o2);
                if (this.inQuery == 0) {
                    n = this.inQuery;
                    this.inQuery = n + 1;
                }
                n = this.inConditionClause;
                this.inConditionClause = n + 1;
            }

            private final boolean sameTargets(PsiElement left, PsiElement right) {
                List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(left instanceof SqlReferenceExpression ? (SqlReferenceExpression)left : null);
                Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualified(...)");
                List<Pair<PsiElement, PsiElement>> leftResolve = list;
                List<Pair<PsiElement, PsiElement>> list2 = SqlImplUtil.resolveQualified(right instanceof SqlReferenceExpression ? (SqlReferenceExpression)right : null);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"resolveQualified(...)");
                List<Pair<PsiElement, PsiElement>> rightResolve = list2;
                return leftResolve.size() == 1 && rightResolve.size() == 1 && Intrinsics.areEqual(leftResolve.get(0), rightResolve.get(0));
            }

            private final boolean isComparisonOperator(IElementType sign) {
                return sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_NEQ2;
            }

            private final void analyseStatement(SqlStatement statement2, SqlDataFlowRunner runner, List<? extends DfaMemoryState> initialStates) {
                ControlFlow flow = runner.buildFlow((PsiElement)statement2, this.$dialect);
                if (flow != null) {
                    Object it2;
                    SqlDataFlowInstructionVisitor listener2 = new SqlDataFlowInstructionVisitor();
                    if (runner.analyzeFlow(listener2, (Collection<? extends DfaMemoryState>)initialStates, flow) != RunnerResult.OK) {
                        return;
                    }
                    Object $this$forEach$iv = listener2.getConstantExpressions();
                    boolean $i$f$forEach = false;
                    for (Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult> element$iv : $this$forEach$iv.entrySet()) {
                        it2 = element$iv;
                        boolean bl = false;
                        if (!(it2.getKey() instanceof SqlBinaryExpression) && !(it2.getKey() instanceof SqlUnaryExpression)) continue;
                        this.reportConstantCondition((PsiElement)it2.getKey(), it2.getValue());
                    }
                    $this$forEach$iv = listener2.getNullabilityProblems();
                    $i$f$forEach = false;
                    Iterator<Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult>> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Object, SqlDataFlowInstructionVisitor.ConstantResult> element$iv;
                        element$iv = iterator.next();
                        it2 = (SqlNullabilityProblem)((Object)element$iv);
                        boolean bl = false;
                        if (((SqlDfaProblem)it2).getAnchor() instanceof SqlLiteralExpression) continue;
                        this.reportNullabilityProblem((SqlNullabilityProblem<?>)it2);
                    }
                }
            }

            public final void reportConstantCondition(@NotNull PsiElement element2, @NotNull SqlDataFlowInstructionVisitor.ConstantResult cResult) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)((Object)cResult), (String)"cResult");
                if (cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE || cResult == SqlDataFlowInstructionVisitor.ConstantResult.FALSE) {
                    if (!this.processedElements.add(element2)) {
                        return;
                    }
                    boolean isTrue = cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE;
                    Object[] objectArray = new Object[]{element2.getText()};
                    String string = SqlBundle.message((String)(isTrue ? "condition.always.true" : "condition.always.false"), (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message2 = string;
                    this.addDescriptor(this.$manager.createProblemDescriptor(element2, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }

            public final void reportNullabilityProblem(@NotNull SqlNullabilityProblem<?> problem) {
                Intrinsics.checkNotNullParameter(problem, (String)"problem");
                if (Intrinsics.areEqual(problem.getKind(), (Object)SqlNullabilityProblemKind.NullExpression.INSTANCE)) {
                    T expression = problem.getAnchor();
                    if (!(expression instanceof SqlBinaryExpression) || !this.checkNullComparison((SqlBinaryExpression)expression)) {
                        String string;
                        PsiElement dereferencedExpr = problem.getDereferencedExpression();
                        if (!Intrinsics.areEqual((Object)dereferencedExpr, expression)) {
                            var6_4 = new Object[]{expression.getText()};
                            string = SqlBundle.message((String)"inspection.message.null.reference", (Object[])var6_4);
                        } else {
                            var6_4 = new Object[]{expression.getText()};
                            string = SqlBundle.message((String)"inspection.message.expression.always.null", (Object[])var6_4);
                        }
                        String string2 = string;
                        Intrinsics.checkNotNull((Object)string2);
                        String message2 = string2;
                        this.addDescriptor(this.$manager.createProblemDescriptor(expression, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                    }
                    this.processedElements.add((PsiElement)expression);
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlConstantExpressionInspection$MyConvertFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "title", "", "replacement", "(Ljava/lang/String;Ljava/lang/String;)V", "myReplacement", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.database.sql.impl"})
    private static final class MyConvertFix
    implements LocalQuickFix {
        @NotNull
        private final String title;
        @NotNull
        private final String myReplacement;

        public MyConvertFix(@IntentionFamilyName @NotNull String title, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.title = title;
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            return this.title;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement element2 = descriptor2.getPsiElement();
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(this.myReplacement, SqlImplUtil.getSqlDialectSafe(element2), element2.getProject(), null);
            if (sqlExpression == null) {
                return;
            }
            SqlExpression replacementExpr = sqlExpression;
            element2.replace((PsiElement)replacementExpr);
        }
    }
}

