/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlCaseVsIfInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "preferCase", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "BranchingInfo", "Companion", "ConvertToCaseFix", "ConvertToIfFix", "FunctionKind", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public final class SqlCaseVsIfInspection
extends SqlInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public boolean preferCase;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Map map2 = SqlCaseVsIfInspection.Companion.getIfCaps(dialect, file);
        if (map2.isEmpty()) {
            boolean bl = false;
            return null;
        }
        Map caps = map2;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, problems, caps, this, onTheFly){
            final /* synthetic */ Map<FunctionKind, String> $caps;
            final /* synthetic */ SqlCaseVsIfInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$caps = $caps;
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$problems);
            }

            public void visitSqlCaseExpression(@NotNull SqlCaseExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                BranchingInfo branchingInfo = com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o2, this.$caps);
                if (branchingInfo != null) {
                    BranchingInfo branchingInfo2 = branchingInfo;
                    Map<FunctionKind, String> map2 = this.$caps;
                    SqlCaseVsIfInspection sqlCaseVsIfInspection = this.this$0;
                    BranchingInfo info2 = branchingInfo2;
                    boolean bl = false;
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)o2.getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_CASE), (boolean)false, null);
                    if (psiElement == null) {
                        psiElement = (PsiElement)o2;
                    }
                    PsiElement psiElement2 = psiElement;
                    Intrinsics.checkNotNull((Object)psiElement2);
                    PsiElement anchor2 = psiElement2;
                    for (Map.Entry entry : map2.entrySet()) {
                        boolean isApplicable;
                        FunctionKind kind = (FunctionKind)((Object)entry.getKey());
                        String name2 = (String)entry.getValue();
                        if (!(isApplicable = (switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                            case 1 -> {
                                if (info2.getConditionalBranches().size() == 1) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> true;
                            case 3 -> {
                                if (info2.getSubject() != null) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        }))) continue;
                        Object[] objectArray = new Object[]{name2};
                        String string = SqlBundle.message((String)"inspection.message.case.can.be.replaced.with.call", (Object[])objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.report(anchor2, string, !sqlCaseVsIfInspection.preferCase, (LocalQuickFix)new ConvertToIfFix(kind, name2, o2));
                    }
                }
                super.visitSqlCaseExpression(o2);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o2, this.$caps) != null) {
                    SqlReferenceExpression sqlReferenceExpression = o2.getNameElement();
                    SqlExpression anchor2 = sqlReferenceExpression == null ? (SqlExpression)o2 : (SqlExpression)sqlReferenceExpression;
                    PsiElement psiElement = (PsiElement)anchor2;
                    Object[] objectArray = new Object[]{anchor2.getName()};
                    String string = SqlBundle.message((String)"inspection.message.call.can.be.replaced.with.case.expression", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.report(psiElement, string, this.this$0.preferCase, (LocalQuickFix)new ConvertToCaseFix(o2));
                }
                super.visitSqlFunctionCallExpression(o2);
            }

            private final void report(PsiElement elementToHighlight, @InspectionMessage String message2, boolean isWarning, LocalQuickFix fix) {
                if (!isWarning && !this.$onTheFly) {
                    return;
                }
                PsiElement psiElement = elementToHighlight;
                if (psiElement == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(psiElement, message2, true, isWarning ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION, false, localQuickFixArray);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"preferCase", (String)SqlBundle.message((String)"checkbox.prefer.case.expressions.over.if.functions", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "", "subject", "Lcom/intellij/sql/psi/SqlExpression;", "conditionalBranches", "", "Lkotlin/Pair;", "elseExpression", "(Lcom/intellij/sql/psi/SqlExpression;Ljava/util/List;Lcom/intellij/sql/psi/SqlExpression;)V", "getConditionalBranches", "()Ljava/util/List;", "getElseExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "intellij.database.sql.impl"})
    private static final class BranchingInfo {
        @Nullable
        private final SqlExpression subject;
        @NotNull
        private final List<Pair<SqlExpression, SqlExpression>> conditionalBranches;
        @NotNull
        private final SqlExpression elseExpression;

        public BranchingInfo(@Nullable SqlExpression subject, @NotNull List<? extends Pair<? extends SqlExpression, ? extends SqlExpression>> conditionalBranches, @NotNull SqlExpression elseExpression) {
            Intrinsics.checkNotNullParameter(conditionalBranches, (String)"conditionalBranches");
            Intrinsics.checkNotNullParameter((Object)elseExpression, (String)"elseExpression");
            this.subject = subject;
            this.conditionalBranches = conditionalBranches;
            this.elseExpression = elseExpression;
        }

        @Nullable
        public final SqlExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final List<Pair<SqlExpression, SqlExpression>> getConditionalBranches() {
            return this.conditionalBranches;
        }

        @NotNull
        public final SqlExpression getElseExpression() {
            return this.elseExpression;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion;", "", "()V", "getBranchingInfo", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "Lcom/intellij/sql/psi/SqlCaseExpression;", "caps", "", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getIfCaps", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "file", "Lcom/intellij/sql/psi/SqlFile;", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n288#2,2:241\n*S KotlinDebug\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion\n*L\n70#1:241,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<FunctionKind, String> getIfCaps(SqlLanguageDialectEx $this$getIfCaps, SqlFile file) {
            Map map2;
            Dbms dbms = $this$getIfCaps.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if (dbms2.isMicrosoft()) {
                int[] nArray;
                Version version = SqlImplUtil.getMinDbmsVersion((PsiElement)file);
                if (version != null && version.compareTo(nArray = new int[]{11}) < 0) {
                    return MapsKt.emptyMap();
                }
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IIF"));
            } else if (dbms2.isMysql()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IF"));
            } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.SNOWFLAKE)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IFF"), TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE")};
                map2 = MapsKt.mapOf((Pair[])pairArray);
            } else if (dbms2.isHive() || dbms2.is(Dbms.SPARK)) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"));
            } else if (dbms2.isClickHouse()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"), TuplesKt.to((Object)((Object)FunctionKind.MULTI_IF), (Object)"multiIf")};
                map2 = MapsKt.mapOf((Pair[])pairArray);
            } else if (dbms2.isRedshift()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"decode"));
            } else if (dbms2.isDb2() || dbms2.isExasol() || dbms2.isHsqldb() || dbms2.isOracle() || dbms2.isVertica()) {
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE"));
            } else {
                return MapsKt.emptyMap();
            }
            return map2;
        }

        private final BranchingInfo getBranchingInfo(SqlCaseExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            SqlExpression subject = $this$getBranchingInfo.getExpression();
            boolean isSimpleSubject = subject == null || subject instanceof SqlLiteralExpression || subject instanceof SqlReferenceExpression;
            boolean supportsMulti = caps.get((Object)FunctionKind.MULTI_IF) != null && isSimpleSubject || caps.get((Object)FunctionKind.DECODE) != null;
            List list = $this$getBranchingInfo.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBranches(...)");
            List branches = list;
            ArrayList conditionalBranches = new ArrayList(branches.size());
            SqlExpression elseExpression = null;
            for (SqlClause branch : branches) {
                SqlClause sqlClause = branch;
                if (sqlClause instanceof SqlWhenThenClause) {
                    SqlExpression expression;
                    SqlElement sqlElement;
                    if (!supportsMulti && !((Collection)conditionalBranches).isEmpty()) {
                        return null;
                    }
                    SqlWhenClause sqlWhenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (sqlWhenClause == null || (sqlWhenClause = sqlWhenClause.getExpression()) == null) {
                        return null;
                    }
                    SqlWhenClause condition2 = sqlWhenClause;
                    SqlThenClause sqlThenClause = ((SqlWhenThenClause)branch).getThenClause();
                    SqlElement sqlElement2 = sqlElement = sqlThenClause != null && (sqlThenClause = sqlThenClause.getBody()) != null ? (SqlElement)CollectionsKt.singleOrNull((Iterable)((Iterable)sqlThenClause)) : null;
                    if ((sqlElement instanceof SqlExpression ? (SqlExpression)sqlElement : null) == null) {
                        return null;
                    }
                    expression = expression;
                    ((Collection)conditionalBranches).add(TuplesKt.to((Object)condition2, (Object)expression));
                    continue;
                }
                if (!(sqlClause instanceof SqlElseClause)) continue;
                if (elseExpression != null) {
                    return null;
                }
                JBIterable jBIterable = ((SqlElseClause)branch).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
                Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
                if ((object instanceof SqlExpression ? (SqlExpression)object : null) == null) {
                    return null;
                }
                elseExpression = elseExpression;
            }
            SqlExpression sqlExpression = elseExpression;
            if (sqlExpression == null) {
                return null;
            }
            return new BranchingInfo(subject, conditionalBranches, sqlExpression);
        }

        private final BranchingInfo getBranchingInfo(SqlFunctionCallExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            BranchingInfo branchingInfo;
            Object v1;
            block14: {
                Object object = $this$getBranchingInfo.getFunctionDefinition();
                if (object == null || (object = object.getName()) == null) {
                    return null;
                }
                Object functionName = object;
                Iterable $this$firstOrNull$iv = caps.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionKind it2 = (FunctionKind)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)caps.get((Object)it2), (Object)functionName)) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            FunctionKind functionKind = v1;
            if (functionKind == null) {
                return null;
            }
            FunctionKind kind = functionKind;
            Object object = $this$getBranchingInfo.getParameterList();
            if (object == null || (object = object.getExpressionList()) == null) {
                return null;
            }
            Object arguments = object;
            int n = arguments.size();
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: 
                case 2: {
                    if (n < 3 || n % 2 != 1) {
                        return null;
                    }
                    int conditionCount = n / 2;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(n - 1))), (int)2);
                    int i2 = intProgression.getFirst();
                    int n3 = intProgression.getLast();
                    int n4 = intProgression.getStep();
                    if (n4 > 0 && i2 <= n3 || n4 < 0 && n3 <= i2) {
                        while (true) {
                            ((Collection)conditionalBranches).add(TuplesKt.to(arguments.get(i2), arguments.get(i2 + 1)));
                            if (i2 == n3) break;
                            i2 += n4;
                        }
                    }
                    List list = conditionalBranches;
                    Object object2 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"last(...)");
                    branchingInfo = new BranchingInfo(null, list, (SqlExpression)object2);
                    break;
                }
                case 3: {
                    if (n < 4 || n % 2 != 0) {
                        return null;
                    }
                    int conditionCount = n / 2 - 1;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)1, (int)(n - 1))), (int)2);
                    int i3 = intProgression.getFirst();
                    int n5 = intProgression.getLast();
                    int n6 = intProgression.getStep();
                    if (n6 > 0 && i3 <= n5 || n6 < 0 && n5 <= i3) {
                        while (true) {
                            ((Collection)conditionalBranches).add(TuplesKt.to(arguments.get(i3), arguments.get(i3 + 1)));
                            if (i3 == n5) break;
                            i3 += n6;
                        }
                    }
                    SqlExpression sqlExpression = (SqlExpression)CollectionsKt.first((List)arguments);
                    List list = conditionalBranches;
                    Object object3 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"last(...)");
                    branchingInfo = new BranchingInfo(sqlExpression, list, (SqlExpression)object3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return branchingInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FunctionKind.values().length];
                try {
                    nArray[FunctionKind.IF.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FunctionKind.MULTI_IF.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FunctionKind.DECODE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToCaseFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "(Lcom/intellij/sql/psi/SqlFunctionCallExpression;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToCaseFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
    private static final class ConvertToCaseFix
    extends LocalQuickFixOnPsiElement {
        public ConvertToCaseFix(@NotNull SqlFunctionCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            super((PsiElement)callExpression);
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.replace.with.case.expression", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlFunctionCallExpression sqlFunctionCallExpression = startElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)startElement : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            BranchingInfo branchingInfo = Companion.getBranchingInfo(callExpression, (Map<FunctionKind, String>)Companion.getIfCaps(sqlLanguageDialectEx, (SqlFile)file));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info2 = branchingInfo;
            SqlLanguageDialectEx sqlLanguageDialectEx2 = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx2, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx2;
            DdlBuilder $this$invoke_u24lambda_u241 = new DdlBuilder();
            boolean bl = false;
            $this$invoke_u24lambda_u241.applyCodeStyle(project, dialect);
            $this$invoke_u24lambda_u241.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u241.keyword("CASE");
            SqlExpression sqlExpression = info2.getSubject();
            if (sqlExpression != null) {
                SqlExpression it2 = sqlExpression;
                boolean bl2 = false;
                $this$invoke_u24lambda_u241.space().plain(it2.getText());
            }
            $this$invoke_u24lambda_u241.newLine();
            for (Pair<SqlExpression, SqlExpression> pair : info2.getConditionalBranches()) {
                SqlExpression condition2 = (SqlExpression)pair.component1();
                SqlExpression expression = (SqlExpression)pair.component2();
                $this$invoke_u24lambda_u241.keyword("WHEN ").plain(condition2.getText()).space().keyword("THEN ").plain(expression.getText());
                $this$invoke_u24lambda_u241.newLine();
            }
            $this$invoke_u24lambda_u241.keyword("ELSE ").plain(info2.getElseExpression().getText());
            $this$invoke_u24lambda_u241.newLine();
            $this$invoke_u24lambda_u241.keyword("END");
            String string = $this$invoke_u24lambda_u241.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String caseText = string;
            SqlExpression sqlExpression2 = SqlPsiElementFactory.createExpressionFromText(caseText, dialect, (PsiElement)callExpression);
            if (sqlExpression2 == null) {
                return;
            }
            SqlExpression caseExpression = sqlExpression2;
            PsiElement newElement = callExpression.replace((PsiElement)caseExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0012\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToIfFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "functionKind", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "functionName", "", "caseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "(Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;Ljava/lang/String;Lcom/intellij/sql/psi/SqlCaseExpression;)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToIfFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        private final FunctionKind functionKind;
        @NotNull
        private final String functionName;

        public ConvertToIfFix(@NotNull FunctionKind functionKind, @NotNull String functionName, @NotNull SqlCaseExpression caseExpression) {
            Intrinsics.checkNotNullParameter((Object)((Object)functionKind), (String)"functionKind");
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)caseExpression, (String)"caseExpression");
            super((PsiElement)caseExpression);
            this.functionKind = functionKind;
            this.functionName = functionName;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.functionName};
            String string = SqlBundle.message((String)"intention.family.name.replace.with.call", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlCaseExpression sqlCaseExpression = startElement instanceof SqlCaseExpression ? (SqlCaseExpression)startElement : null;
            if (sqlCaseExpression == null) {
                return;
            }
            SqlCaseExpression caseExpression = sqlCaseExpression;
            BranchingInfo branchingInfo = Companion.getBranchingInfo(caseExpression, (Map<FunctionKind, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)this.functionKind), (Object)this.functionName)));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info2 = branchingInfo;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            BuiltinFunction builtinFunction = dialect.getSupportedFunctions().get(this.functionName);
            if (builtinFunction == null) {
                return;
            }
            BuiltinFunction ifFunction = builtinFunction;
            DdlBuilder $this$invoke_u24lambda_u240 = new DdlBuilder();
            boolean bl = false;
            SqlExpression sqlExpression = info2.getSubject();
            String subjectText = sqlExpression != null ? sqlExpression.getText() : null;
            $this$invoke_u24lambda_u240.applyCodeStyle(project, dialect);
            $this$invoke_u24lambda_u240.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u240.quoteIdentifiers(false);
            $this$invoke_u24lambda_u240.ref((DasObject)ifFunction, ifFunction.getName());
            $this$invoke_u24lambda_u240.plain("(");
            if (this.functionKind == FunctionKind.DECODE) {
                String string = subjectText;
                if (string == null) {
                    return;
                }
                $this$invoke_u24lambda_u240.plain(string).plain(", ");
            }
            for (Pair<SqlExpression, SqlExpression> pair : info2.getConditionalBranches()) {
                SqlExpression condition2 = (SqlExpression)pair.component1();
                SqlExpression expression = (SqlExpression)pair.component2();
                if (this.functionKind != FunctionKind.DECODE && subjectText != null) {
                    $this$invoke_u24lambda_u240.plain(subjectText + " = " + condition2.getText());
                } else {
                    $this$invoke_u24lambda_u240.plain(condition2.getText());
                }
                $this$invoke_u24lambda_u240.plain(", ");
                $this$invoke_u24lambda_u240.plain(expression.getText());
                $this$invoke_u24lambda_u240.plain(", ");
            }
            $this$invoke_u24lambda_u240.plain(info2.getElseExpression().getText());
            $this$invoke_u24lambda_u240.plain(")");
            String string = $this$invoke_u24lambda_u240.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String callText2 = string;
            SqlExpression sqlExpression2 = SqlPsiElementFactory.createExpressionFromText(callText2, dialect, (PsiElement)caseExpression);
            SqlFunctionCallExpression sqlFunctionCallExpression = sqlExpression2 instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)sqlExpression2 : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            PsiElement newElement = caseExpression.replace((PsiElement)callExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "(Ljava/lang/String;I)V", "IF", "MULTI_IF", "DECODE", "intellij.database.sql.impl"})
    private static final class FunctionKind
    extends Enum<FunctionKind> {
        public static final /* enum */ FunctionKind IF = new FunctionKind();
        public static final /* enum */ FunctionKind MULTI_IF = new FunctionKind();
        public static final /* enum */ FunctionKind DECODE = new FunctionKind();
        private static final /* synthetic */ FunctionKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FunctionKind[] values() {
            return (FunctionKind[])$VALUES.clone();
        }

        public static FunctionKind valueOf(String value2) {
            return Enum.valueOf(FunctionKind.class, value2);
        }

        @NotNull
        public static EnumEntries<FunctionKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = functionKindArray = new FunctionKind[]{FunctionKind.IF, FunctionKind.MULTI_IF, FunctionKind.DECODE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

