/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlCaseVsCoalesceInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0014J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "preferCase", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "ConvertToCaseFix", "ConvertToCoalesceFix", "Holder", "intellij.database.sql.impl"})
public final class SqlCaseVsCoalesceInspection
extends SqlInspectionBase {
    @JvmField
    public boolean preferCase;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        String string = Holder.INSTANCE.getCoalesceName(dialect);
        if (string == null) {
            return null;
        }
        String coalesceName = string;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, problems, coalesceName, this, onTheFly){
            final /* synthetic */ String $coalesceName;
            final /* synthetic */ SqlCaseVsCoalesceInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$coalesceName = $coalesceName;
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$problems);
            }

            public void visitSqlCaseExpression(@NotNull SqlCaseExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (Holder.INSTANCE.getExpressions(o2) != null) {
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)o2.getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_CASE), (boolean)false, null);
                    if (psiElement == null) {
                        psiElement = (PsiElement)o2;
                    }
                    PsiElement anchor2 = psiElement;
                    Object[] objectArray = new Object[]{this.$coalesceName};
                    String string = SqlBundle.message((String)"inspection.message.case.can.be.replaced.with.call", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.report(anchor2, string, !this.this$0.preferCase, (LocalQuickFix)new ConvertToCoalesceFix(this.$coalesceName, o2));
                }
                super.visitSqlCaseExpression(o2);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (Holder.INSTANCE.getExpressions(o2, this.$coalesceName) != null) {
                    SqlReferenceExpression sqlReferenceExpression = o2.getNameElement();
                    SqlExpression anchor2 = sqlReferenceExpression == null ? (SqlExpression)o2 : (SqlExpression)sqlReferenceExpression;
                    PsiElement psiElement = (PsiElement)anchor2;
                    Object[] objectArray = new Object[]{anchor2.getName()};
                    String string = SqlBundle.message((String)"inspection.message.call.can.be.replaced.with.case.expression", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.report(psiElement, string, this.this$0.preferCase, (LocalQuickFix)new ConvertToCaseFix(this.$coalesceName, o2));
                }
                super.visitSqlFunctionCallExpression(o2);
            }

            private final void report(PsiElement elementToHighlight, @InspectionMessage String message2, boolean isWarning, LocalQuickFix fix) {
                if (!isWarning && !this.$onTheFly) {
                    return;
                }
                PsiElement psiElement = elementToHighlight;
                if (psiElement == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(psiElement, message2, true, isWarning ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION, false, localQuickFixArray);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"preferCase", (String)SqlBundle.message((String)"checkbox.prefer.case.expressions.over.coalesce.function", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\u0003\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\f0\u0003\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$ConvertToCaseFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "coalesceName", "", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "(Ljava/lang/String;Lcom/intellij/sql/psi/SqlFunctionCallExpression;)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToCaseFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        private final String coalesceName;

        public ConvertToCaseFix(@NotNull String coalesceName, @NotNull SqlFunctionCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)coalesceName, (String)"coalesceName");
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            super((PsiElement)callExpression);
            this.coalesceName = coalesceName;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.replace.with.case.expression", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlFunctionCallExpression sqlFunctionCallExpression = startElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)startElement : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            List<SqlExpression> list = Holder.INSTANCE.getExpressions(callExpression, this.coalesceName);
            if (list == null) {
                return;
            }
            List<SqlExpression> expressions2 = list;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            DdlBuilder $this$invoke_u24lambda_u240 = new DdlBuilder();
            boolean bl = false;
            $this$invoke_u24lambda_u240.applyCodeStyle(project, dialect);
            $this$invoke_u24lambda_u240.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u240.keyword("CASE");
            $this$invoke_u24lambda_u240.newLine();
            for (SqlExpression expression : expressions2.subList(0, CollectionsKt.getLastIndex(expressions2))) {
                String expressionText = expression.getText();
                $this$invoke_u24lambda_u240.keyword("WHEN ").plain(expressionText).space().keyword("IS NOT NULL THEN ").plain(expressionText);
                $this$invoke_u24lambda_u240.newLine();
            }
            $this$invoke_u24lambda_u240.keyword("ELSE ").plain(((SqlExpression)CollectionsKt.last(expressions2)).getText());
            $this$invoke_u24lambda_u240.newLine();
            $this$invoke_u24lambda_u240.keyword("END");
            String string = $this$invoke_u24lambda_u240.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String caseText = string;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(caseText, dialect, (PsiElement)callExpression);
            if (sqlExpression == null) {
                return;
            }
            SqlExpression caseExpression = sqlExpression;
            PsiElement newElement = callExpression.replace((PsiElement)caseExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f0\u0003\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\f0\u0003\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$ConvertToCoalesceFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "coalesceName", "", "caseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "(Ljava/lang/String;Lcom/intellij/sql/psi/SqlCaseExpression;)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToCoalesceFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        private final String coalesceName;

        public ConvertToCoalesceFix(@NotNull String coalesceName, @NotNull SqlCaseExpression caseExpression) {
            Intrinsics.checkNotNullParameter((Object)coalesceName, (String)"coalesceName");
            Intrinsics.checkNotNullParameter((Object)caseExpression, (String)"caseExpression");
            super((PsiElement)caseExpression);
            this.coalesceName = coalesceName;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.coalesceName};
            String string = SqlBundle.message((String)"intention.family.name.replace.with.call", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlCaseExpression sqlCaseExpression = startElement instanceof SqlCaseExpression ? (SqlCaseExpression)startElement : null;
            if (sqlCaseExpression == null) {
                return;
            }
            SqlCaseExpression caseExpression = sqlCaseExpression;
            List<SqlExpression> list = Holder.INSTANCE.getExpressions(caseExpression);
            if (list == null) {
                return;
            }
            List<SqlExpression> expressions2 = list;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            BuiltinFunction builtinFunction = dialect.getSupportedFunctions().get(this.coalesceName);
            if (builtinFunction == null) {
                return;
            }
            BuiltinFunction coalesceFunction = builtinFunction;
            DdlBuilder $this$invoke_u24lambda_u240 = new DdlBuilder();
            boolean bl = false;
            $this$invoke_u24lambda_u240.applyCodeStyle(project, dialect);
            $this$invoke_u24lambda_u240.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u240.quoteIdentifiers(false);
            $this$invoke_u24lambda_u240.ref((DasObject)coalesceFunction, this.coalesceName);
            $this$invoke_u24lambda_u240.plain(CollectionsKt.joinToString$default((Iterable)expressions2, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)invoke.callText.1.1.INSTANCE, (int)25, null));
            String string = $this$invoke_u24lambda_u240.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String callText2 = string;
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(callText2, dialect, (PsiElement)caseExpression);
            SqlFunctionCallExpression sqlFunctionCallExpression = sqlExpression instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)sqlExpression : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            PsiElement newElement = caseExpression.replace((PsiElement)callExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0004*\u00020\u0012J\u001a\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0004*\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$Holder;", "", "()V", "IS_NOT_NULL_TOKENS", "", "Lcom/intellij/sql/psi/SqlTokenType;", "IS_NOT_TOKENS", "coalesceName", "", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getCoalesceName", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Ljava/lang/String;", "areEquivalent", "", "left", "Lcom/intellij/sql/psi/SqlExpression;", "right", "getExpressions", "Lcom/intellij/sql/psi/SqlCaseExpression;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getIsNotNullTarget", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlCaseVsCoalesceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsCoalesceInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$Holder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1747#2,3:202\n*S KotlinDebug\n*F\n+ 1 SqlCaseVsCoalesceInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsCoalesceInspection$Holder\n*L\n93#1:202,3\n*E\n"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final List<SqlTokenType> IS_NOT_TOKENS;
        @NotNull
        private static final List<SqlTokenType> IS_NOT_NULL_TOKENS;

        private Holder() {
        }

        @Nullable
        public final String getCoalesceName(@NotNull SqlLanguageDialectEx $this$coalesceName) {
            Intrinsics.checkNotNullParameter((Object)$this$coalesceName, (String)"<this>");
            Dbms dbms = $this$coalesceName.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            return dbms2.isCassandra() ? null : (dbms2.isHive() || dbms2.is(Dbms.SPARK) || dbms2.isSqlite() || dbms2.isSybase() || dbms2.isPostgres() || dbms2.isClickHouse() ? "coalesce" : "COALESCE");
        }

        private final SqlExpression getIsNotNullTarget(SqlExpression $this$getIsNotNullTarget) {
            if (!($this$getIsNotNullTarget instanceof SqlBinaryExpression)) {
                return null;
            }
            PsiElement psiElement = ((SqlBinaryExpression)$this$getIsNotNullTarget).getOpSignElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement opSign = psiElement;
            Sequence opTokens2 = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)opSign.getFirstChild(), (Function1)getIsNotNullTarget.opTokens.1.INSTANCE), (Function1)getIsNotNullTarget.opTokens.2.INSTANCE);
            List list = SequencesKt.toList((Sequence)opTokens2);
            if (Intrinsics.areEqual((Object)list, IS_NOT_TOKENS)) {
                SqlExpression sqlExpression = ((SqlBinaryExpression)$this$getIsNotNullTarget).getROperand();
                SqlLiteralExpression sqlLiteralExpression = sqlExpression instanceof SqlLiteralExpression ? (SqlLiteralExpression)sqlExpression : null;
                if (sqlLiteralExpression == null) {
                    return null;
                }
                SqlLiteralExpression rOperand = sqlLiteralExpression;
                PsiElement[] psiElementArray = rOperand.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)((PsiElement)ArraysKt.singleOrNull((Object[])psiElementArray))), (Object)SqlCommonKeywords.SQL_NULL)) {
                    return null;
                }
            } else if (Intrinsics.areEqual((Object)list, IS_NOT_NULL_TOKENS)) {
                if (((SqlBinaryExpression)$this$getIsNotNullTarget).getROperand() != null) {
                    return null;
                }
            } else {
                return null;
            }
            return ((SqlBinaryExpression)$this$getIsNotNullTarget).getLOperand();
        }

        private final boolean areEquivalent(SqlExpression left, SqlExpression right) {
            if (left instanceof SqlLiteralExpression && right instanceof SqlLiteralExpression) {
                return Intrinsics.areEqual((Object)((SqlLiteralExpression)left).getText(), (Object)((SqlLiteralExpression)right).getText());
            }
            if (left instanceof SqlReferenceExpression && right instanceof SqlReferenceExpression) {
                return UtilsKt.checkEquivalence((SqlReferenceExpression)left, (SqlReferenceExpression)right);
            }
            return false;
        }

        @Nullable
        public final List<SqlExpression> getExpressions(@NotNull SqlCaseExpression $this$getExpressions) {
            Intrinsics.checkNotNullParameter((Object)$this$getExpressions, (String)"<this>");
            if ($this$getExpressions.getExpression() != null) {
                return null;
            }
            List list = $this$getExpressions.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBranches(...)");
            List branches = list;
            ArrayList result2 = new ArrayList(branches.size());
            SqlExpression elseExpression = null;
            for (SqlClause branch : branches) {
                SqlClause sqlClause = branch;
                if (sqlClause instanceof SqlWhenThenClause) {
                    SqlExpression checkedExpression;
                    SqlWhenClause sqlWhenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (sqlWhenClause == null || (sqlWhenClause = sqlWhenClause.getExpression()) == null) {
                        return null;
                    }
                    SqlWhenClause condition2 = sqlWhenClause;
                    if (this.getIsNotNullTarget((SqlExpression)condition2) == null) {
                        return null;
                    }
                    SqlThenClause sqlThenClause = ((SqlWhenThenClause)branch).getThenClause();
                    SqlElement sqlElement = sqlThenClause != null && (sqlThenClause = sqlThenClause.getBody()) != null ? (SqlElement)CollectionsKt.singleOrNull((Iterable)((Iterable)sqlThenClause)) : null;
                    SqlExpression sqlExpression = sqlElement instanceof SqlExpression ? (SqlExpression)sqlElement : null;
                    if (sqlExpression == null) {
                        return null;
                    }
                    SqlExpression resultExpression = sqlExpression;
                    if (!this.areEquivalent(checkedExpression, resultExpression)) {
                        return null;
                    }
                    ((Collection)result2).add(resultExpression);
                    continue;
                }
                if (!(sqlClause instanceof SqlElseClause)) continue;
                if (elseExpression != null) {
                    return null;
                }
                JBIterable jBIterable = ((SqlElseClause)branch).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
                Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
                if ((object instanceof SqlExpression ? (SqlExpression)object : null) == null) {
                    return null;
                }
                elseExpression = elseExpression;
                ((Collection)result2).add(elseExpression);
            }
            return result2;
        }

        @Nullable
        public final List<SqlExpression> getExpressions(@NotNull SqlFunctionCallExpression $this$getExpressions, @NotNull String coalesceName) {
            boolean bl;
            Object arguments;
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$getExpressions, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)coalesceName, (String)"coalesceName");
                Object object = $this$getExpressions.getFunctionDefinition();
                if (object == null || (object = object.getName()) == null) {
                    return null;
                }
                Object functionName = object;
                if (!Intrinsics.areEqual((Object)functionName, (Object)coalesceName)) {
                    return null;
                }
                Object object2 = $this$getExpressions.getParameterList();
                if (object2 == null || (object2 = object2.getExpressionList()) == null) {
                    return null;
                }
                arguments = object2;
                if (arguments.size() < 2) {
                    return null;
                }
                Iterable $this$any$iv = CollectionsKt.slice((List)arguments, (IntRange)RangesKt.until((int)0, (int)CollectionsKt.getLastIndex((List)arguments)));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        if (!(!(it2 instanceof SqlLiteralExpression) && !(it2 instanceof SqlReferenceExpression))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            return arguments;
        }

        static {
            Object[] objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_NOT};
            IS_NOT_TOKENS = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_NULL};
            IS_NOT_NULL_TOKENS = CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

