/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlAmbiguousColumnInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o2) {
                if (o2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.shouldNotCheckElement((SqlElement)o2)) {
                    return;
                }
                ObjectKind type2 = o2.getReferenceElementType().getTargetKind();
                SqlExpression qualifier = o2.getQualifierExpression();
                if (type2 == ObjectKind.COLUMN && qualifier != null) {
                    SqlTableType qualifierType = (SqlTableType)ObjectUtils.tryCast((Object)qualifier.getDasType(), SqlTableType.class);
                    if (qualifierType == null) {
                        return;
                    }
                    Casing casing = dialect.getCasing(type2, null);
                    String effectiveRefName = SqlImplUtil.getEffectiveName(o2.getName(), o2.isQuoted(), casing);
                    int matches2 = 0;
                    for (int i2 = 0; i2 < qualifierType.getColumnCount() && matches2 <= 1; ++i2) {
                        String effectiveColName = SqlImplUtil.getEffectiveName(qualifierType.getColumnName(i2), qualifierType.isColumnQuoted(i2), casing);
                        if (!effectiveColName.equals(effectiveRefName)) continue;
                        ++matches2;
                    }
                    if (matches2 > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, SqlBundle.message((String)"ambiguous.column.short.reference", (Object[])new Object[]{o2.getName()}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
                if ((type2 == SqlDbElementType.ANY || type2 == ObjectKind.COLUMN) && qualifier == null) {
                    SqlJoinExpression joinExpression;
                    SqlFromClause fromClause;
                    PsiElement clause = (PsiElement)SyntaxTraverser.psiApi().parents((Object)o2).filter(e2 -> e2 instanceof SqlUsingClause || e2.getParent() instanceof SqlQueryExpression || e2.getParent() instanceof SqlTableExpression).first();
                    if (clause instanceof SqlUsingClause || clause == null) {
                        return;
                    }
                    SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o2, SqlQueryExpression.class, (boolean)true);
                    SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
                    DasType queryExpressionType = queryExpression != null ? queryExpression.getDasType() : null;
                    SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
                    if (fromClause == null) {
                        return;
                    }
                    Dbms dbms = this.myDialect.getDbms();
                    SqlTableType tableType2 = clause instanceof SqlFromClause ? ((joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)o2, SqlJoinExpression.class, (boolean)true)) == null ? tableExpression.getDasType() : joinExpression.getDasType()) : (clause instanceof SqlOrderByClause || (clause instanceof SqlGroupByClause || clause instanceof SqlHavingClause) && dbms.isMysql() ? (queryExpressionType instanceof SqlTableType ? (SqlTableType)queryExpressionType : SqlTableTypeBase.EMPTY_TABLE) : tableExpression.getDasType());
                    String columnName = o2.getName();
                    int matchedAliases = 0;
                    int matchedColumns = 0;
                    int count = tableType2.getColumnCount();
                    for (int i3 = 0; i3 < count; ++i3) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType2.getColumnName(i3), (boolean)false)) continue;
                        if (tableType2.getColumnElement(i3) instanceof SqlAsExpression) {
                            ++matchedAliases;
                            continue;
                        }
                        ++matchedColumns;
                    }
                    if (matchedAliases + matchedColumns <= 1) {
                        return;
                    }
                    if (clause instanceof SqlOrderByClause) {
                        if (dbms.isDb2() && matchedColumns == 1 && matchedAliases == 1) {
                            return;
                        }
                        if (dbms.isSybase() && matchedAliases == 0) {
                            return;
                        }
                    }
                    ArrayList<Object> names2 = new ArrayList<Object>(matchedAliases + matchedColumns);
                    int count2 = tableType2.getColumnCount();
                    for (int i4 = 0; i4 < count2; ++i4) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType2.getColumnName(i4), (boolean)false)) continue;
                        String tableAlias = tableType2.getColumnTypeAlias(i4);
                        if (tableAlias != null) {
                            names2.add(tableAlias + "." + columnName);
                            continue;
                        }
                        PsiElement c2 = tableType2.getSourceColumnElement(i4);
                        names2.add(c2 == null ? columnName : SqlAmbiguousColumnInspection.getQualifiedName(c2));
                    }
                    Collections.sort(names2);
                    for (SqlUsingClause usingClause : SqlAmbiguousColumnInspection.getAllUsingClauses(tableExpression)) {
                        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(usingClause.getReferenceList());
                        if (referenceList.isEmpty()) continue;
                        if (names2.isEmpty()) break;
                        for (SqlAsExpression expression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)usingClause.getParent(), SqlAsExpression.class)) {
                            names2.remove(expression.getName() + "." + columnName);
                        }
                        for (SqlReferenceExpression reference : referenceList) {
                            for (ResolveResult resolveResult : reference.multiResolve(false)) {
                                names2.remove(SqlAmbiguousColumnInspection.getQualifiedName(resolveResult.getElement()));
                            }
                        }
                    }
                    if (names2.size() > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o2, SqlBundle.message((String)"ambiguous.column.short.reference", (Object[])new Object[]{StringUtil.join((String[])ArrayUtilRt.toStringArray(names2), (String)",\n")}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1", "visitSqlReferenceExpression"));
            }
        };
    }

    @NotNull
    private static Collection<SqlUsingClause> getAllUsingClauses(@NotNull SqlTableExpression tableExpression) {
        SqlFromClause fromClause;
        if (tableExpression == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(3);
        }
        if ((fromClause = tableExpression.getFromClause()) == null) {
            List<SqlUsingClause> list = Collections.emptyList();
            if (list == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        final ArrayList<SqlUsingClause> result2 = new ArrayList<SqlUsingClause>();
        fromClause.acceptChildren(new SqlVisitor(){

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o2) {
                if (o2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                o2.acceptChildren((SqlVisitor)this);
            }

            public void visitSqlUsingClause(SqlUsingClause o2) {
                result2.add(o2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$2", "visitSqlJoinExpression"));
            }
        });
        ArrayList<SqlUsingClause> arrayList = result2;
        if (arrayList == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    protected boolean isDialectIgnored(SqlLanguageDialectEx dialect) {
        return super.isDialectIgnored(dialect) || dialect.getDbms() == Dbms.CLICKHOUSE;
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element2) {
        if (element2 == null) {
            return "";
        }
        if (element2 instanceof DbElement) {
            String string = QNameUtil.getQualifiedName((DbElement)element2);
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (element2 instanceof SqlDefinition) {
            String string = QNameUtil.getQualifiedName((DasObject)((SqlDefinition)element2));
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (element2 instanceof PsiNamedElement) {
            String string = StringUtil.notNullize((String)((PsiNamedElement)element2).getName());
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)element2.getText());
        if (string == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingClauses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingClauses";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

