/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.EndExcElementContinuePattern;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonExpandPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAliasBlock;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBinaryExpressionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlErrorNodeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlInsertMatrixAligner;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock$patchFormattingAttributesForChildren$;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.model.StartStopPattern;
import com.intellij.sql.formatter.model.StartUntilPattern;
import com.intellij.sql.formatter.model.TypePattern;
import com.intellij.sql.formatter.model.UntilPattern;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\u0018\u0000 -2\u00020\u0001:%,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020\u0010H\u0002J\b\u0010$\u001a\u00020\u0010H\u0014J\b\u0010%\u001a\u00020\nH\u0016J\b\u0010&\u001a\u00020\u0010H\u0014J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "commonFirstWordRightAlign", "Lcom/intellij/formatting/Alignment;", "getCommonFirstWordRightAlign", "()Lcom/intellij/formatting/Alignment;", "setCommonFirstWordRightAlign", "(Lcom/intellij/formatting/Alignment;)V", "isInsert", "", "isSubQuery", "isUnion", "allowedToCollapse", "checkIsSubquery", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "detectWhetherIntoSeparated", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugName", "", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "handleWhetherIsInsert", "handleWhetherIsSubquery", "patchFormattingAttributesForChildren", "tailFormed", "tuneNestedNodesAfterAnalysis", "userWrapSetting", "", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "CTE", "Companion", "DeleteSection", "FromSection", "GroupOrderSection", "InsertSection", "JoinCondition", "JoinPhrase", "LateralFunctionCall", "LimitSection", "OnSection", "OneLineSection", "OutputSection", "ParenthesizedJoinTableExpression", "PredicateElement", "PrimaryTableElement", "QuerySection", "ReturningSection", "SecondaryTableElement", "SectionElement", "SelectElement", "SelectElementAmendment", "SelectElementEssence", "SelectSection", "SelectSeparatedPrefix", "SetAssignment", "SetSection", "SqlCortegeLikeParenthesizedListBlock", "UnionSection", "UnknownSection", "UpdateSection", "ValuesSection", "WhereSection", "WindowEntry", "WindowSection", "WithSection", "WordAndListSection", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1708:1\n288#2,2:1709\n288#2,2:1711\n1855#2,2:1716\n1855#2,2:1721\n467#3,3:1713\n467#3,3:1718\n473#4:1723\n179#4,2:1724\n473#4:1726\n179#4,2:1727\n1#5:1729\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock\n*L\n210#1:1709,2\n211#1:1711,2\n271#1:1716,2\n272#1:1721,2\n271#1:1713,3\n272#1:1718,3\n296#1:1723\n296#1:1724,2\n297#1:1726\n297#1:1727,2\n*E\n"})
public final class SqlQueryBlock
extends SqlNodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isSubQuery;
    private boolean isInsert;
    private boolean isUnion;
    @Nullable
    private Alignment commonFirstWordRightAlign;
    @NotNull
    private static final Set<IElementType> nodesToFlatten;
    @NotNull
    private static final Set<IElementType> sectionMarkers;
    @NotNull
    private static final Set<IElementType> tableJoinWords;
    @NotNull
    private static final Set<IElementType> unionStartWords;
    @NotNull
    private static final Set<IElementType> unionGluedWords;
    @NotNull
    private static final Set<IElementType> limitStopMarker;
    @NotNull
    private static final List<FlowPattern> commonPatterns;
    @NotNull
    private static final List<FlowPattern> insertIntoTogetherPatterns;
    @NotNull
    private static final List<FlowPattern> insertIntoSeparatedPatterns;
    @NotNull
    private static final List<FlowPattern> postgresQueryPatterns;

    @Nullable
    public final Alignment getCommonFirstWordRightAlign() {
        return this.commonFirstWordRightAlign;
    }

    public final void setCommonFirstWordRightAlign(@Nullable Alignment alignment) {
        this.commonFirstWordRightAlign = alignment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        IElementType iElementType = node2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type2 = iElementType;
        if (nodesToFlatten.contains(type2)) return true;
        if (!Intrinsics.areEqual((Object)type2, (Object)SqlCompositeElementTypes.SQL_JOIN_EXPRESSION)) return false;
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
        if (!SqlUtilFun.hasChildNode(node2, (IElementType)sqlTokenType)) return false;
        return true;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        List<FlowPattern> list;
        this.handleWhetherIsSubquery();
        this.handleWhetherIsInsert();
        boolean bl = this.isInsert;
        if (!bl) {
            list = this.getContext().getDialect().getDbms().isPostgres() ? postgresQueryPatterns : commonPatterns;
        } else if (bl) {
            boolean separate;
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    boolean bl2 = true;
                    break;
                }
                case 2: {
                    boolean bl2 = false;
                    break;
                }
                default: {
                    boolean bl2 = separate = this.detectWhetherIntoSeparated();
                }
            }
            list = separate ? insertIntoSeparatedPatterns : insertIntoTogetherPatterns;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final void handleWhetherIsSubquery() {
        this.isSubQuery = this.checkIsSubquery();
    }

    private final void handleWhetherIsInsert() {
        IElementType iElementType = SqlUtilFun.firstLeaf(this.getBlockNode()).getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType firstType = iElementType;
        this.isInsert = Intrinsics.areEqual((Object)firstType, (Object)SqlTokens.SQL_INSERT) || Intrinsics.areEqual((Object)firstType, (Object)SqlTokens.SQL_REPLACE);
    }

    private final boolean detectWhetherIntoSeparated() {
        Object v1;
        ASTNode insertNode;
        block4: {
            Object v0;
            JBIterable<ASTNode> children2;
            block3: {
                children2 = SqlUtilFun.children(this.getBlockNode());
                Iterable $this$firstOrNull$iv = (Iterable)children2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ASTNode it2 = (ASTNode)element$iv;
                    boolean bl = false;
                    if (!(it2.getElementType() == SqlTokens.SQL_INSERT)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            insertNode = v0;
            Iterable $this$firstOrNull$iv = (Iterable)children2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it3 = (ASTNode)element$iv;
                boolean bl = false;
                if (!(it3.getElementType() == SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION || it3.getElementType() == SqlTokens.SQL_INTO)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode intoNode = v1;
        if (insertNode == null || intoNode == null) {
            return false;
        }
        return this.getContext().textContains(insertNode.getTextRange().getEndOffset(), intoNode.getStartOffset(), '\n');
    }

    private final boolean checkIsSubquery() {
        for (SqlBlock p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (p2 instanceof SqlQueryBlock) {
                return true;
            }
            if (!(p2 instanceof SqlCodeFlowBlock) || p2 instanceof SqlBatchBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public int userWrapSetting() {
        return switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1 -> 1;
            case 2 -> {
                if (this.isSubQuery) {
                    yield 2;
                }
                yield 1;
            }
            case 3 -> 2;
            default -> 0;
        };
    }

    @Override
    protected boolean allowedToCollapse() {
        return switch (this.getContext().getSql().QUERY_IN_ONE_STRING) {
            case 1 -> false;
            case 2 -> this.isSubQuery;
            case 3 -> true;
            default -> !this.getHasUserBreaks();
        };
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        super.tuneNestedNodesAfterAnalysis();
        if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0) {
            for (SqlBlock b2 : this.getNestedBlocks()) {
                boolean toExpand;
                if (b2 instanceof UnionSection) {
                    this.isUnion = true;
                }
                if (!(b2 instanceof WordAndListSection) || !(toExpand = ((WordAndListSection)b2).userWrapSetting() == 1 && (((WordAndListSection)b2).getCountOfElements() > ((WordAndListSection)b2).userNumberOfElementsToKeepCollapsed() || ((WordAndListSection)b2).userElementsLineSetting() == 101)) || b2.getShape().compareTo((Enum)this.getShape()) >= 0) continue;
                b2.setShape(this.getShape());
            }
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings q2 = this.getContext().getSql();
        boolean decidedToWrap = this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS || !this.allowedToCollapse();
        Wrap w = SqlFlowBlock.makeWrap$default(this, decidedToWrap ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
        for (SqlBlock b2 : this.nestedBlocksIter().skip(1)) {
            b2.setMyWrap(w);
        }
        switch (q2.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 2: {
                Indent i2 = Indent.getNormalIndent((boolean)true);
                for (SqlBlock b3 : this.getNestedBlocks()) {
                    if (!(b3 instanceof QuerySection) || !((QuerySection)b3).whetherSectionToIndent()) continue;
                    b3.setMyIndent(i2);
                }
                break;
            }
            case 8: {
                QuerySection it2;
                Iterator<SqlBlock> $this$forEach$iv;
                int thePrefixLength = 0;
                thePrefixLength = 6;
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterator $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)((Object)$this$jbi$iv$iv));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                $this$filter$iv = (Iterable)jBIterable2;
                boolean $i$f$forEach = false;
                $this$jbi$iv$iv = $this$forEach$iv.iterator();
                while ($this$jbi$iv$iv.hasNext()) {
                    Object element$iv = $this$jbi$iv$iv.next();
                    it2 = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it2.getFirstWordLength$intellij_database_sql_core_impl() <= thePrefixLength) continue;
                    thePrefixLength = it2.getFirstWordLength$intellij_database_sql_core_impl();
                }
                $this$filter$iv = this.getNestedBlocks();
                $i$f$filter = false;
                $this$jbi$iv$iv = $this$filter$iv;
                $i$f$getJbi = false;
                JBIterable jBIterable3 = JBIterable.from((Iterable)((Object)$this$jbi$iv$iv));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"from(...)");
                JBIterable jBIterable4 = jBIterable3.filter(QuerySection.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
                $this$filter$iv = (Iterable)jBIterable4;
                $i$f$forEach = false;
                $this$jbi$iv$iv = $this$forEach$iv.iterator();
                while ($this$jbi$iv$iv.hasNext()) {
                    Object element$iv = $this$jbi$iv$iv.next();
                    it2 = (QuerySection)element$iv;
                    boolean bl = false;
                    if (it2.getFirstWordLength$intellij_database_sql_core_impl() >= thePrefixLength) continue;
                    it2.setMyIndent(Indent.getSpaceIndent((int)(thePrefixLength - it2.getFirstWordLength$intellij_database_sql_core_impl())));
                }
                break;
            }
        }
        switch (q2.QUERY_SECTION_1ST_WORD_ALIGN) {
            case 1: {
                Alignment a = SqlFormattingModelFun.makeLeftAlignment();
                for (SqlBlock b4 : this.getNestedBlocks()) {
                    b4.setMyAlign(a);
                }
                break;
            }
            case 2: {
                Alignment a1 = SqlFormattingModelFun.makeLeftAlignment();
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignment();
                for (SqlBlock b5 : this.getNestedBlocks()) {
                    b5.setMyAlign(b5 instanceof QuerySection && ((QuerySection)b5).whetherSectionToIndent() ? a2 : a1);
                }
                break;
            }
            case 8: {
                this.commonFirstWordRightAlign = SqlFormattingModelFun.makeRightAlignment();
                for (SqlBlock b6 : this.getNestedBlocks()) {
                    SqlLeafBlock sqlLeafBlock = b6.getFirstLeafBlock();
                    if (sqlLeafBlock == null) continue;
                    sqlLeafBlock.setMyAlign(this.commonFirstWordRightAlign);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void patchFormattingAttributesForChildren() {
        SqlCodeStyleSettings q2 = this.getContext().getSql();
        if (this.isInsert && q2.INSERT_MATRIX_ALIGN) {
            Object v3;
            InsertSection theHeader;
            block5: {
                void $this$firstOrNull$iv;
                Object v1;
                block4: {
                    Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.getNestedBlocks());
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)patchFormattingAttributesForChildren$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Sequence $this$firstOrNull$iv2 = sequence;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv2) {
                        InsertSection it2 = (InsertSection)element$iv;
                        boolean bl = false;
                        if (!(it2.getCountOfFields() > 0)) continue;
                        v1 = element$iv;
                        break block4;
                    }
                    v1 = null;
                }
                theHeader = v1;
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.getNestedBlocks());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)patchFormattingAttributesForChildren$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = sequence;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValuesSection it3 = (ValuesSection)element$iv;
                    boolean bl = false;
                    if (!(it3.getCountOfRows$intellij_database_sql_core_impl() >= 2)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            ValuesSection theMatrix = v3;
            if (theMatrix != null) {
                InsertSection insertSection;
                boolean includeHeader = q2.INSERT_MATRIX_INCLUDING_HEADER;
                int percentile = q2.INSERT_MATRIX_MODE;
                int breakThreshold = q2.INSERT_MATRIX_BREAK_THRESHOLD;
                int minWideningThreshold = q2.INSERT_MATRIX_MIN_WIDENING_THRESHOLD;
                InsertSection it4 = insertSection = theHeader;
                boolean bl = false;
                SqlInsertMatrixAligner.alignTheMatrix(includeHeader ? insertSection : null, theMatrix, percentile, minWideningThreshold, breakThreshold);
            }
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (block1 instanceof InsertSection && block2 instanceof InsertSection) {
            switch (this.getContext().getSql().INSERT_INTO_NL) {
                case 1: {
                    spacing = SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, true, 1, null);
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    @Override
    public boolean tailFormed() {
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return false;
        }
        SqlBlock lastBlock = sqlBlock;
        SqlBlock sqlBlock2 = lastBlock;
        return sqlBlock2 instanceof SelectSection ? ((SelectSection)lastBlock).canBeSelectSectionOnly$intellij_database_sql_core_impl() : !(sqlBlock2 instanceof UnionSection);
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        SqlBlock block1;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock sqlBlock = block1 = blocks.getBlock1();
        if (sqlBlock != null) {
            sqlBlock.grow();
        }
        return block1 instanceof QuerySection ? (((QuerySection)block1).tailFormed() ? SqlFormattingContext.currIndentOf$default(this.getContext(), block1, true, false, false, 12, null) : ((QuerySection)block1).getNewLineIndent(new AdjacentBlocks(((QuerySection)block1).getLastNestedSqlBlock(), null))) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, false, false, 14, null);
    }

    @Override
    @NotNull
    public String getDebugName() {
        return super.getDebugName() + (this.isSubQuery ? "(sub)" : "");
    }

    public static final /* synthetic */ Set access$getTableJoinWords$cp() {
        return tableJoinWords;
    }

    static {
        Object[] objectArray = new IElementType[]{SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_DML_INSTRUCTION, SqlCompositeElementTypes.SQL_VALUES_EXPRESSION, SqlCompositeElementTypes.SQL_SET_CLAUSE, SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_WITH_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_INTO_CLAUSE, SqlCompositeElementTypes.SQL_SELECT_INTO_NEW_TABLE_CLAUSE, SqlCompositeElementTypes.SQL_TABLE_EXPRESSION, SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, SqlCompositeElementTypes.SQL_REFERENCE_LIST, SqlCompositeElementTypes.SQL_FROM_CLAUSE, SqlCompositeElementTypes.SQL_WHERE_CLAUSE, SqlCompositeElementTypes.SQL_HIERARCHICAL_QUERY_CLAUSE, SqlCompositeElementTypes.SQL_GROUP_BY_CLAUSE, SqlCompositeElementTypes.SQL_HAVING_CLAUSE, SqlCompositeElementTypes.SQL_QUALIFY_CLAUSE, SqlCompositeElementTypes.SQL_UNION_EXPRESSION, SqlCompositeElementTypes.SQL_ORDER_BY_CLAUSE, SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, SqlCompositeElementTypes.SQL_CONFLICT_ACTION_CLAUSE, SqlCompositeElementTypes.SQL_CLAUSE};
        nodesToFlatten = SetsKt.setOf((Object[])objectArray);
        objectArray = new IElementType[]{SqlTokens.SQL_INSERT, SqlTokens.SQL_REPLACE, SqlTokens.SQL_INTO, SqlTokens.SQL_ON, SqlTokens.SQL_UPDATE, SqlTokens.SQL_DELETE, SqlTokens.SQL_SET, SqlTokens.SQL_VALUES, SqlTokens.SQL_WITH, SqlTokens.SQL_SELECT, SqlTokens.SQL_FROM, SqlTokens.SQL_WHERE, SqlTokens.SQL_START, SqlTokens.SQL_CONNECT, SqlTokens.SQL_GROUP, SqlTokens.SQL_HAVING, SqlTokens.SQL_QUALIFY, SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT, SqlTokens.SQL_ORDER, SqlTokens.SQL_OPTION, SqlCompositeElementTypes.SQL_RETURNING_CLAUSE, SqlTokens.SQL_OFFSET, SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, SqlTokens.SQL_LIMIT, SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE, SqlCompositeElementTypes.SQL_WINDOW_CLAUSE, SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE};
        sectionMarkers = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_NATURAL, SqlTokens.SQL_LEFT, SqlTokens.SQL_RIGHT, SqlTokens.SQL_FULL, SqlTokens.SQL_INNER, SqlTokens.SQL_OUTER, SqlTokens.SQL_CROSS, SqlTokens.SQL_LOOP, SqlTokens.SQL_HASH, SqlTokens.SQL_MERGE, SqlTokens.SQL_REMOTE, SqlTokens.SQL_LOOP, SqlTokens.SQL_REDUCE, SqlTokens.SQL_REPLICATE, SqlTokens.SQL_REDISTRIBUTE, SqlTokens.SQL_ARRAY, SqlTokens.SQL_APPLY, SqlTokens.SQL_JOIN, SqlTokens.SQL_LATERAL};
        tableJoinWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT};
        unionStartWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_UNION, SqlTokens.SQL_INTERSECT, SqlTokens.SQL_MINUS, SqlTokens.SQL_EXCEPT, SqlTokens.SQL_ALL};
        unionGluedWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlTokens.SQL_OFFSET, SqlTokens.SQL_LIMIT};
        limitStopMarker = SetsKt.minus(sectionMarkers, (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new FlowPattern[21];
        SqlTokenType sqlTokenType = SqlTokens.SQL_INTO;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_INTO");
        objectArray[0] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
        SqlTokenType sqlTokenType2 = SqlTokens.SQL_ON;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_ON");
        Object[] objectArray2 = new SqlTokenType[]{SqlTokens.SQL_ON, SqlTokens.SQL_UPDATE, SqlTokens.SQL_SET};
        objectArray[1] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Iterable)SetsKt.setOf((Object[])objectArray2))), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlTokens.SQL_UPDATE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
        objectArray[2] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType3), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
        SqlTokenType sqlTokenType4 = SqlTokens.SQL_DELETE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_DELETE");
        objectArray[3] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
        SqlTokenType sqlTokenType5 = SqlTokens.SQL_SET;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_SET");
        objectArray[4] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType5), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.5.INSTANCE));
        SqlTokenType sqlTokenType6 = SqlTokens.SQL_VALUES;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_VALUES");
        objectArray[5] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType6), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.6.INSTANCE));
        SqlTokenType sqlTokenType7 = SqlTokens.SQL_WITH;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType7, (String)"SQL_WITH");
        objectArray[6] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType7), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.7.INSTANCE));
        SqlTokenType sqlTokenType8 = SqlTokens.SQL_SELECT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType8, (String)"SQL_SELECT");
        objectArray[7] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType8), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.8.INSTANCE));
        SqlTokenType sqlTokenType9 = SqlTokens.SQL_FROM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType9, (String)"SQL_FROM");
        objectArray[8] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType9), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.9.INSTANCE));
        objectArray2 = new IElementType[4];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_WHERE, (String)"SQL_WHERE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_HAVING, (String)"SQL_HAVING");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_CONNECT, (String)"SQL_CONNECT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_QUALIFY, (String)"SQL_QUALIFY");
        objectArray[9] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.10.INSTANCE));
        SqlTokenType sqlTokenType10 = SqlTokens.SQL_START;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType10, (String)"SQL_START");
        objectArray[10] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType10), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Object)SqlTokens.SQL_WITH)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.11.INSTANCE));
        objectArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_GROUP, (String)"SQL_GROUP");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_ORDER, (String)"SQL_ORDER");
        objectArray[11] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.12.INSTANCE));
        objectArray2 = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_OFFSET, (String)"SQL_OFFSET");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_LIMIT, (String)"SQL_LIMIT");
        objectArray[12] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), NodeMatcherKt.matchType(limitStopMarker), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.13.INSTANCE));
        objectArray[13] = new SimplePattern(null, null, NodeMatcherKt.matchType(unionStartWords), NodeMatcherKt.matchType(unionGluedWords), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.14.INSTANCE));
        SqlTokenType sqlTokenType11 = SqlTokens.SQL_OPTION;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType11, (String)"SQL_OPTION");
        objectArray[14] = new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType11), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.15.INSTANCE));
        objectArray2 = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_OFFSET_CLAUSE, (String)"SQL_OFFSET_CLAUSE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_LIMIT_CLAUSE, (String)"SQL_LIMIT_CLAUSE");
        Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_LIMIT_OFFSET_CLAUSE, (String)"SQL_LIMIT_OFFSET_CLAUSE");
        objectArray[15] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray2), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.16.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_RETURNING_CLAUSE");
        objectArray[16] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType, "first leaf is RETURNING", (Function1<? super ASTNode, Boolean>)((Function1)Companion.commonPatterns.17.INSTANCE)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.18.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_RETURNING_CLAUSE");
        objectArray[17] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType2, "first leaf is OUTPUT", (Function1<? super ASTNode, Boolean>)((Function1)Companion.commonPatterns.19.INSTANCE)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.20.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_RETURNING_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_RETURNING_CLAUSE");
        objectArray[18] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.21.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType4 = SqlCompositeElementTypes.SQL_QUERY_FLATTEN_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType4, (String)"SQL_QUERY_FLATTEN_CLAUSE");
        objectArray[19] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType4), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.22.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType5 = SqlCompositeElementTypes.SQL_WINDOW_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType5, (String)"SQL_WINDOW_CLAUSE");
        objectArray[20] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType5), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.23.INSTANCE));
        commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        Collection collection2 = commonPatterns;
        objectArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_INSERT, (String)"SQL_INSERT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_REPLACE, (String)"SQL_REPLACE");
        insertIntoTogetherPatterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray), NodeMatcherKt.matchType(SetsKt.minus(sectionMarkers, (Object)SqlTokens.SQL_INTO)), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoTogetherPatterns.1.INSTANCE))));
        Collection collection3 = commonPatterns;
        objectArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_INSERT, (String)"SQL_INSERT");
        Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_REPLACE, (String)"SQL_REPLACE");
        insertIntoSeparatedPatterns = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType[])objectArray), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.insertIntoSeparatedPatterns.1.INSTANCE))));
        Collection collection4 = commonPatterns;
        SqlTokenType sqlTokenType12 = SqlTokens.SQL_PERFORM;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType12, (String)"SQL_PERFORM");
        postgresQueryPatterns = CollectionsKt.plus((Collection)collection4, (Iterable)CollectionsKt.listOf((Object)new StartUntilPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType12), NodeMatcherKt.matchType(sectionMarkers), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.postgresQueryPatterns.1.INSTANCE))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
    private static final class CTE
    extends SqlNodeBlock {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                SqlFlowBlock sqlFlowBlock = sqlBlock instanceof SqlFlowBlock ? (SqlFlowBlock)sqlBlock : null;
                if (sqlFlowBlock == null) break block0;
                sqlFlowBlock.countRole$intellij_database_sql_core_impl(role);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block0: {
                SqlBlock sqlBlock;
                this.setInnerWrap(SqlFlowBlock.makeWrap$default(this, WrapType.NORMAL, false, 2, null));
                Iterable iterable = this.getNestedBlocks();
                SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
                SqlBlock sqlBlock2 = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)iterable, (IElementType)sqlTokenType);
                if (sqlBlock2 == null) break block0;
                SqlBlock it2 = sqlBlock = sqlBlock2;
                boolean bl = false;
                it2.setMyWrap(this.getInnerWrap());
            }
        }

        static {
            Object[] objectArray = new FlowPattern[3];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), BlockRole.BODY, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$CTE$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "insertIntoSeparatedPatterns", "insertIntoTogetherPatterns", "limitStopMarker", "", "Lcom/intellij/psi/tree/IElementType;", "nodesToFlatten", "postgresQueryPatterns", "sectionMarkers", "tableJoinWords", "unionGluedWords", "unionStartWords", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$DeleteSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.core.impl"})
    private static final class DeleteSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\b\u0010\u000e\u001a\u00020\u0004H\u0014J\b\u0010\u000f\u001a\u00020\nH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "hasJoins", "", "getHasJoins", "()Z", "setHasJoins", "(Z)V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "toAlignElements", "tuneNestedNodesAfterAnalysis", "userCommaSetting", "", "userElementsLineSetting", "userRequiresExpand", "userWrapSetting", "whetherSectionToIndent", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$FromSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1708:1\n248#2:1709\n467#3,3:1710\n467#3,3:1715\n467#3,3:1718\n1855#4,2:1713\n1855#4,2:1721\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$FromSection\n*L\n1079#1:1709\n1085#1:1710,3\n1101#1:1715,3\n1104#1:1718,3\n1085#1:1713,2\n1106#1:1721,2\n*E\n"})
    private static final class FromSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private boolean hasJoins;
        @NotNull
        private static final Set<SqlCompositeElementType> elementTypes;
        @NotNull
        private static final List<FlowPattern> patterns;

        public final boolean getHasJoins() {
            return this.hasJoins;
        }

        public final void setHasJoins(boolean bl) {
            this.hasJoins = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().FROM_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().FROM_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().FROM_EL_COMMA;
        }

        @Override
        protected void tuneNestedNodesAfterAnalysis() {
            super.tuneNestedNodesAfterAnalysis();
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrimaryTableElement it2 = (PrimaryTableElement)element$iv;
                boolean bl = false;
                this.hasJoins = this.hasJoins || it2.getCountOfJoins() > 0;
            }
            if (this.getCountOfElements() > 1 && this.hasJoins) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected boolean toAlignElements() {
            return this.getContext().getSql().FROM_ONLY_JOIN_INDENT > -1 && this.getCountOfElements() + this.getCountOfDelimiters() <= 1 ? false : super.toAlignElements();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            if (this.getContext().getSql().FROM_ALIGN_ALIASES) {
                void $this$filter$iv;
                void $this$filter$iv2;
                Alignment a1 = SqlFormattingModelFun.makeLeftAlignmentBS();
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignmentBS();
                Iterable iterable = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                boolean $i$f$filter = false;
                void $this$jbi$iv$iv = $this$filter$iv2;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(PrimaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                JBIterable jBIterable3 = jBIterable2.flatten(arg_0 -> FromSection.configureFormattingAttributes$lambda$1(configureFormattingAttributes.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"flatten(...)");
                Iterable iterable2 = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable3), BlockRole.ELEMENT);
                boolean $i$f$filter2 = false;
                void $this$jbi$iv$iv2 = $this$filter$iv;
                boolean $i$f$getJbi2 = false;
                JBIterable jBIterable4 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"from(...)");
                JBIterable jBIterable5 = jBIterable4.filter(SecondaryTableElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"filter(...)");
                JBIterable jBIterable6 = jBIterable5.flatten(arg_0 -> FromSection.configureFormattingAttributes$lambda$2(configureFormattingAttributes.2.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"flatten(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable6;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it2 = (SqlBlock)element$iv;
                    boolean bl = false;
                    if (it2.getRole() == BlockRole.AS) {
                        it2.setMyAlign(a1);
                    }
                    if (it2.getRole() != BlockRole.ALIAS2) continue;
                    it2.setMyAlign(a2);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.getCountOfElements() >= 2 && (this.hasJoins || this.userWrapSetting() == 1);
        }

        private static final Iterable configureFormattingAttributes$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Iterable)$tmp0.invoke(p0);
        }

        private static final Iterable configureFormattingAttributes$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Iterable)$tmp0.invoke(p0);
        }

        static {
            Object[] objectArray = new SqlCompositeElementType[]{SqlCompositeElementTypes.SQL_TABLE_REFERENCE, SqlCompositeElementTypes.SQL_AS_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION, SqlCompositeElementTypes.SQL_EXPLICIT_TABLE_EXPRESSION, SqlCompositeElementTypes.SQL_JOIN_EXPRESSION, SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION};
            elementTypes = SetsKt.setOf((Object[])objectArray);
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchType(elementTypes), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection$Companion;", "", "()V", "elementTypes", "", "Lcom/intellij/sql/psi/SqlCompositeElementType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "patchFormattingAttributesForChildren", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1708:1\n248#2:1709\n38#3:1710\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection\n*L\n1185#1:1709\n1166#1:1710\n*E\n"})
    private static final class GroupOrderSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean whetherSectionToIndent() {
            if (!this.getThisQuery$intellij_database_sql_core_impl().isUnion) return true;
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if ((aSTNode != null ? aSTNode.getElementType() : null) == SqlTokens.SQL_ORDER) return false;
            return true;
        }

        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            IElementType iElementType = node2.getElementType();
            return (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_ASC) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_DESC)) ? BlockRole.AMENDMENT : super.determineRole(node2);
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().ORDER_ALIGN_ASC_DESC) {
                this.tabify(BlockRole.AMENDMENT);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().ORDER_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().ORDER_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().ORDER_EL_COMMA;
        }

        static {
            boolean $i$f$matchElementClass = false;
            patterns = CollectionsKt.plus((Collection)WordAndListSection.Companion.getCommonPatterns(), (Iterable)CollectionsKt.listOf((Object)new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$GroupOrderSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\tH\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "countOfFields", "", "getCountOfFields", "()I", "fields", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getFields", "()Lcom/intellij/util/containers/JBIterable;", "fieldsBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "getFieldsBlock", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "setFieldsBlock", "(Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;)V", "configureFormattingAttributes", "", "considerBlock", "block", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n248#2:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection\n*L\n735#1:1709\n*E\n"})
    public static final class InsertSection
    extends QuerySection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlCortegeLikeParenthesizedListBlock fieldsBlock;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlCortegeLikeParenthesizedListBlock getFieldsBlock() {
            return this.fieldsBlock;
        }

        public final void setFieldsBlock(@Nullable SqlCortegeLikeParenthesizedListBlock sqlCortegeLikeParenthesizedListBlock) {
            this.fieldsBlock = sqlCortegeLikeParenthesizedListBlock;
        }

        @NotNull
        public final JBIterable<SqlBlock> getFields() {
            JBIterable<SqlBlock> jBIterable = this.fieldsBlock;
            if (jBIterable == null || (jBIterable = jBIterable.getNestedBlocks()) == null || (jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable), BlockRole.ELEMENT)) == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
            }
            return jBIterable;
        }

        public final int getCountOfFields() {
            SqlCortegeLikeParenthesizedListBlock sqlCortegeLikeParenthesizedListBlock = this.fieldsBlock;
            return sqlCortegeLikeParenthesizedListBlock != null ? sqlCortegeLikeParenthesizedListBlock.getCountOfElements$intellij_database_sql_core_impl() : 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_TABLE_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block instanceof SqlCortegeLikeParenthesizedListBlock) {
                this.fieldsBlock = (SqlCortegeLikeParenthesizedListBlock)block;
            }
        }

        @Override
        public boolean whetherSectionToIndent() {
            return this.getFirstWord$intellij_database_sql_core_impl() == SqlTokens.SQL_INTO;
        }

        @Override
        protected void configureFormattingAttributes() {
            block4: {
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ALIAS1);
                if (sqlBlock2 == null) break block4;
                SqlBlock it2 = sqlBlock = sqlBlock2;
                boolean bl = false;
                it2.setMyWrap(switch (this.userElementsLineSetting()) {
                    case 1 -> Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                    case 101 -> this.makeWrap(WrapType.ALWAYS, true);
                    default -> null;
                });
            }
        }

        static {
            Object[] objectArray = new FlowPattern[3];
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_TABLE_REFERENCE");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_HINT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_HINT_CLAUSE");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "keyBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getKeyBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setKeyBlock", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "configureFormattingAttributes", "", "considerBlock", "block", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,1708:1\n112#2,4:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$JoinCondition\n*L\n1676#1:1709,4\n*E\n"})
    private static final class JoinCondition
    extends SqlNodeBlock {
        @Nullable
        private SqlBlock keyBlock;

        @Nullable
        public final SqlBlock getKeyBlock() {
            return this.keyBlock;
        }

        public final void setKeyBlock(@Nullable SqlBlock sqlBlock) {
            this.keyBlock = sqlBlock;
        }

        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            IElementType iElementType = node2.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType t = iElementType;
            return t == SqlTokens.SQL_ON || t == SqlTokens.SQL_USING ? BlockRole.PREFIX : BlockRole.NOTHING;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block.getRole() == BlockRole.PREFIX && this.keyBlock == null) {
                this.keyBlock = block;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void configureFormattingAttributes() {
            block5: {
                void wrap$iv;
                void this_$iv;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = this.keyBlock;
                if (sqlBlock2 == null) break block5;
                SqlBlock kb = sqlBlock = sqlBlock2;
                boolean bl = false;
                SqlCodeStyleSettings s2 = this.getContext().getSql();
                Indent i2 = switch (s2.FROM_PLACE_ON) {
                    case 10 -> SqlFormattingFunKt.getNONE_INDENT();
                    case 11 -> SqlFormattingFunKt.getNORMAL_INDENT();
                    case 12 -> SqlFormattingFunKt.getCONTINUATION_INDENT();
                    default -> SqlFormattingFunKt.getNONE_INDENT();
                };
                SqlBlock sqlBlock3 = kb;
                Object var7_7 = null;
                Alignment align$iv = null;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent(i2);
                this_$iv.setMyAlign(align$iv);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$JoinPhrase;", "Lcom/intellij/sql/formatter/model/SqlPhraseBlock;", "()V", "intellij.database.sql.core.impl"})
    private static final class JoinPhrase
    extends SqlPhraseBlock {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LateralFunctionCall;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "intellij.database.sql.core.impl"})
    private static final class LateralFunctionCall
    extends SqlRangeBlock {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$LimitSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "()V", "intellij.database.sql.core.impl"})
    private static final class LimitSection
    extends OneLineSection {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userElementsLineSetting", "", "Companion", "intellij.database.sql.core.impl"})
    private static final class OnSection
    extends QuerySection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        static {
            Object[] objectArray = new FlowPattern[5];
            SqlTokenType sqlTokenType = SqlTokens.SQL_ON;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_ON");
            Object[] objectArray2 = new SqlTokenType[]{SqlTokens.SQL_DUPLICATE, SqlTokens.SQL_KEY, SqlTokens.SQL_CONFLICT, SqlTokens.SQL_CONSTRAINT};
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])objectArray2), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_DO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_DO");
            objectArray[1] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType2), new ElementTypeSetContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_UPDATE), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.2.INSTANCE)));
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_UPDATE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_UPDATE");
            objectArray[2] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlTokens.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.3.INSTANCE)));
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_SET;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_SET");
            objectArray[3] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType4), new EndExcElementContinuePattern(SetsKt.emptySet(), SetsKt.setOf((Object)SqlTokens.SQL_ON), BlockRole.NOTHING, (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.4.INSTANCE)));
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_CLAUSE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OnSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "preserveUserLineBreaks", "", "userElementsLineSetting", "", "userRequiresExpand", "whetherSectionToIndent", "intellij.database.sql.core.impl"})
    private static class OneLineSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }

        @Override
        protected boolean userRequiresExpand() {
            return false;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        protected boolean preserveUserLineBreaks() {
            return false;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return OneLineSection.decideSpacing$preserve(block1) ? super.decideSpacing(block1, block2) : (OneLineSection.decideSpacing$preserve(block2) ? super.decideSpacing(block1, block2) : this.getContext().makeSafeSpacing(false));
        }

        private static final boolean decideSpacing$preserve(SqlBlock b2) {
            return b2 instanceof SqlCommentBlock || b2 instanceof SqlErrorNodeBlock || b2 instanceof SqlErrorNodeBlock;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n248#2:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection\n*L\n1242#1:1709\n*E\n"})
    private static final class OutputSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new FlowPattern[2];
            objectArray[0] = new SimplePattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchAnyKeyword(), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$OutputSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ParenthesizedJoinTableExpression;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "closingBlock", "Lcom/intellij/sql/formatter/model/SqlSymbol;", "openingBlock", "considerBlock", "", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
    private static final class ParenthesizedJoinTableExpression
    extends SqlRangeBlock {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlSymbol openingBlock;
        @Nullable
        private SqlSymbol closingBlock;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    if (this.openingBlock != null || !(block instanceof SqlSymbol)) break;
                    this.openingBlock = (SqlSymbol)block;
                    break;
                }
                case 2: {
                    if (this.closingBlock != null || !(block instanceof SqlSymbol)) break;
                    this.closingBlock = (SqlSymbol)block;
                }
            }
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return Intrinsics.areEqual((Object)block1, (Object)this.openingBlock) || Intrinsics.areEqual((Object)block2, (Object)this.closingBlock) ? this.getContext().makeSpace(this.getContext().getSql().SUBQUERY_PAR_SPACE_INSIDE) : super.decideSpacing(block1, block2);
        }

        static {
            Object[] objectArray = new FlowPattern[6];
            Byte by = 0;
            Byte by2 = 1;
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[0] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by3 = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[1] = new SingletonExpandPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            Byte by4 = 1;
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_JOIN_EXPRESSION");
            objectArray[2] = new SingletonExpandPattern(by4, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            Byte by5 = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_TABLE_REFERENCE");
            objectArray[3] = new SingletonExpandPattern(by5, null, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            Byte by6 = 1;
            SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_JOIN_CONDITION_CLAUSE");
            objectArray[4] = new SingletonExpandPattern(by6, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            Byte by7 = 1;
            Byte by8 = 9;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_RIGHT_PAREN");
            objectArray[5] = new SingletonPattern(by7, by8, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.SUFFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ParenthesizedJoinTableExpression$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.SUFFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PredicateElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "blockIsEgyptian", "", "b", "Lcom/intellij/sql/formatter/model/SqlBlock;", "isEgyptian", "intellij.database.sql.core.impl"})
    private static final class PredicateElement
    extends SqlRangeBlock
    implements SectionElement {
        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (this.blockIsEgyptian(b1)) {
                return true;
            }
            return b1 != b2 && this.blockIsEgyptian(b2);
        }

        private final boolean blockIsEgyptian(SqlBlock b2) {
            if (b2 == null) {
                return false;
            }
            return b2 instanceof SqlParenthesizedSubqueryBlock || b2 instanceof SqlBinaryExpressionBlock && (this.blockIsEgyptian(((SqlBinaryExpressionBlock)b2).getFirstNestedSqlBlock()) || this.blockIsEgyptian(((SqlBinaryExpressionBlock)b2).getLastNestedSqlBlock()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u000bH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u0016\u0010(\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\b\u0010*\u001a\u00020\u000bH\u0014J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "countOfJoins", "", "getCountOfJoins", "()I", "setCountOfJoins", "(I)V", "forceWrap1", "", "getForceWrap1", "()Z", "forceWrap2", "getForceWrap2", "joinAlign", "Lcom/intellij/formatting/Alignment;", "getJoinAlign", "()Lcom/intellij/formatting/Alignment;", "setJoinAlign", "(Lcom/intellij/formatting/Alignment;)V", "parentSection", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "getParentSection", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock$FromSection;", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "isEgyptian", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "produceNestedBlocks", "nodes", "userRequiresExpand", "whetherToFlatten", "node", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1708:1\n432#2:1709\n432#2:1710\n248#3:1711\n1855#4,2:1712\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$PrimaryTableElement\n*L\n1450#1:1709\n1453#1:1710\n1470#1:1711\n1503#1:1712,2\n*E\n"})
    private static final class PrimaryTableElement
    extends SqlNodeBlock
    implements SectionElement {
        private int countOfJoins;
        @Nullable
        private Alignment joinAlign;

        @NotNull
        public final FromSection getParentSection() {
            SqlBlock sqlBlock = this.getParent();
            Intrinsics.checkNotNull((Object)sqlBlock, (String)"null cannot be cast to non-null type com.intellij.sql.formatter.model.SqlQueryBlock.FromSection");
            return (FromSection)sqlBlock;
        }

        public final int getCountOfJoins() {
            return this.countOfJoins;
        }

        public final void setCountOfJoins(int n) {
            this.countOfJoins = n;
        }

        @Nullable
        public final Alignment getJoinAlign() {
            return this.joinAlign;
        }

        public final void setJoinAlign(@Nullable Alignment alignment) {
            this.joinAlign = alignment;
        }

        public final boolean getForceWrap1() {
            return this.getContext().getSql().FROM_WRAP_JOIN_1 && this.countOfJoins >= 1;
        }

        public final boolean getForceWrap2() {
            return this.getContext().getSql().FROM_WRAP_JOIN_2 && this.countOfJoins >= 2;
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            IElementType iElementType = this.getBlockNode().getElementType();
            return (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION)) ? CollectionsKt.listOf((Object)this.getBlockNode()) : super.listTheChildren();
        }

        @Override
        protected boolean whetherToFlatten(@NotNull ASTNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            return node2.getElementType() == SqlCompositeElementTypes.SQL_JOIN_EXPRESSION;
        }

        @Override
        protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            int n = nodes.size();
            int p2 = 0;
            while (p2 < n) {
                int e2;
                IntRange join2;
                IntRange intRange = join2 = SqlFormattingModelFun.findConsequence(nodes, p2, (Function1<? super ASTNode, Boolean>)((Function1)produceNestedBlocks.join.1.INSTANCE));
                int n3 = e2 = intRange != null ? intRange.getStart() : n;
                if (p2 < e2) {
                    List<? extends ASTNode> subList = nodes.subList(p2, e2);
                    SecondaryTableElement elementBlock = new SecondaryTableElement();
                    elementBlock.setup(this, subList);
                    elementBlock.setRole(BlockRole.ELEMENT);
                    this.addNestedBlock$intellij_database_sql_core_impl(elementBlock);
                }
                if (join2 == null) break;
                JoinPhrase joinBlock = new JoinPhrase();
                IntRange $this$finish$iv = join2;
                boolean $i$f$getFinish = false;
                joinBlock.setup(this, nodes.subList(join2.getFirst(), $this$finish$iv.getEndInclusive() + 1));
                joinBlock.setRole(BlockRole.DELIMITER);
                this.addNestedBlock$intellij_database_sql_core_impl(joinBlock);
                $this$finish$iv = join2;
                $i$f$getFinish = false;
                p2 = $this$finish$iv.getEndInclusive() + 1;
            }
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            if (role == BlockRole.DELIMITER) {
                int n = this.countOfJoins;
                this.countOfJoins = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Indent defaultChildIndent(@NotNull SqlBlock block) {
            Indent indent;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (block.getRole() == BlockRole.ELEMENT) {
                void what$iv;
                void $this$change$iv;
                int n = this.getContext().getSql().FROM_EL_LINE;
                int n3 = -1;
                int with$iv = this.getContext().getSql().QUERY_EL_LINE;
                boolean $i$f$change = false;
                if (($this$change$iv == what$iv ? with$iv : n) == 1) {
                    indent = SqlFormattingFunKt.getNONE_INDENT();
                    return indent;
                }
            }
            indent = super.defaultChildIndent(block);
            return indent;
        }

        @Override
        protected void configureFormattingAttributes() {
            if (this.countOfJoins == 0) {
                return;
            }
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            Wrap w1 = null;
            Wrap w2 = null;
            if (this.getForceWrap1() == this.getForceWrap2()) {
                Wrap wrap2 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap2);
                w2 = w1 = wrap2;
            } else {
                Wrap wrap3 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap1() ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap3);
                w1 = wrap3;
                Wrap wrap4 = SqlFlowBlock.makeWrap$default(this, this.getForceWrap2() ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
                Intrinsics.checkNotNull((Object)wrap4);
                w2 = wrap4;
            }
            boolean unindentJoins = s2.FROM_ONLY_JOIN_INDENT > -1 && this.getParentSection().getCountOfElements() == 1;
            Indent i2 = unindentJoins && s2.FROM_ONLY_JOIN_INDENT == 1 ? SqlFormattingFunKt.getNORMAL_INDENT() : (unindentJoins && s2.FROM_ONLY_JOIN_INDENT == 2 ? SqlFormattingFunKt.getNONE_INDENT() : (s2.FROM_INDENT_JOIN ? Indent.getNormalIndent((boolean)true) : Indent.getSpaceIndent((int)0, (boolean)true)));
            this.joinAlign = s2.QUERY_ALIGN_ELEMENTS && !unindentJoins ? SqlFormattingModelFun.makeLeftAlignment() : null;
            JBIterable<SqlBlock> joinWords = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            Iterator iterator = joinWords.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index2 = n++;
                SqlBlock jw = (SqlBlock)iterator.next();
                if (index2 == 0) {
                    jw.setMyWrap(w1);
                }
                if (index2 >= 1) {
                    jw.setMyWrap(w2);
                }
                jw.setMyIndent(i2);
                jw.setMyAlign(this.joinAlign);
            }
            if (s2.FROM_ALIGN_JOIN_TABLES) {
                Alignment a2 = SqlFormattingModelFun.makeLeftAlignmentBS();
                JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"skip(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlBlock it2 = (SqlBlock)element$iv;
                    boolean bl = false;
                    it2.setMyAlign(a2);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.getForceWrap1() || this.getForceWrap2();
        }

        @Override
        public boolean isEgyptian() {
            if (this.getContext().getSql().SUBQUERY_CONTENT != 2) {
                return false;
            }
            SqlBlock b1 = (SqlBlock)CollectionsKt.firstOrNull(this.getNestedBlocks());
            SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
            if (b1 instanceof SecondaryTableElement && ((SecondaryTableElement)b1).isEgyptian$intellij_database_sql_core_impl()) {
                return true;
            }
            return b2 instanceof SecondaryTableElement && ((SecondaryTableElement)b2).isEgyptian$intellij_database_sql_core_impl();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\nH&J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "firstWord", "Lcom/intellij/psi/tree/IElementType;", "getFirstWord$intellij_database_sql_core_impl", "()Lcom/intellij/psi/tree/IElementType;", "setFirstWord$intellij_database_sql_core_impl", "(Lcom/intellij/psi/tree/IElementType;)V", "firstWordLength", "", "getFirstWordLength$intellij_database_sql_core_impl", "()I", "setFirstWordLength$intellij_database_sql_core_impl", "(I)V", "prefixLength", "getPrefixLength$intellij_database_sql_core_impl", "setPrefixLength$intellij_database_sql_core_impl", "prefixSize", "getPrefixSize$intellij_database_sql_core_impl", "setPrefixSize$intellij_database_sql_core_impl", "thisQuery", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "getThisQuery$intellij_database_sql_core_impl", "()Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "adjustNestedNodes", "", "userElementsLineSetting", "userRequiresExpand", "", "whetherSectionToIndent", "intellij.database.sql.core.impl"})
    public static abstract class QuerySection
    extends SqlRangeBlock {
        private int prefixSize;
        private int prefixLength;
        @Nullable
        private IElementType firstWord;
        private int firstWordLength;

        @NotNull
        public final SqlQueryBlock getThisQuery$intellij_database_sql_core_impl() {
            SqlQueryBlock sqlQueryBlock;
            SqlBlock p2 = this.getParent();
            if (p2 instanceof SqlQueryBlock) {
                sqlQueryBlock = (SqlQueryBlock)p2;
            } else if (p2 instanceof QuerySection) {
                sqlQueryBlock = ((QuerySection)p2).getThisQuery$intellij_database_sql_core_impl();
            } else {
                throw new IllegalStateException("The parent of QuerySection must be Query or QuerySection, but it is " + p2);
            }
            return sqlQueryBlock;
        }

        public final int getPrefixSize$intellij_database_sql_core_impl() {
            return this.prefixSize;
        }

        public final void setPrefixSize$intellij_database_sql_core_impl(int n) {
            this.prefixSize = n;
        }

        public final int getPrefixLength$intellij_database_sql_core_impl() {
            return this.prefixLength;
        }

        public final void setPrefixLength$intellij_database_sql_core_impl(int n) {
            this.prefixLength = n;
        }

        @Nullable
        public final IElementType getFirstWord$intellij_database_sql_core_impl() {
            return this.firstWord;
        }

        public final void setFirstWord$intellij_database_sql_core_impl(@Nullable IElementType iElementType) {
            this.firstWord = iElementType;
        }

        public final int getFirstWordLength$intellij_database_sql_core_impl() {
            return this.firstWordLength;
        }

        public final void setFirstWordLength$intellij_database_sql_core_impl(int n) {
            this.firstWordLength = n;
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            ASTNode firstNode = (ASTNode)CollectionsKt.firstOrNull(this.getNestedNodes());
            if (firstNode != null) {
                this.firstWord = firstNode.getElementType();
                this.firstWordLength = firstNode.getTextLength();
            }
        }

        public boolean whetherSectionToIndent() {
            return false;
        }

        @Override
        public abstract int userElementsLineSetting();

        @Override
        protected boolean userRequiresExpand() {
            return (this.userElementsLineSetting() == 101 || this.userWrapSetting() == 1) && !this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ReturningSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$OneLineSection;", "()V", "theIntoBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "", "considerBlock", "block", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.core.impl"})
    private static final class ReturningSection
    extends OneLineSection {
        @Nullable
        private SqlBlock theIntoBlock;

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (SqlFormattingModelFun.primaryElementType(block) == SqlTokens.SQL_INTO && this.theIntoBlock == null) {
                this.theIntoBlock = block;
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            SqlBlock sqlBlock = this.theIntoBlock;
            if (sqlBlock != null) {
                sqlBlock.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
            }
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return this.getContext().makeSafeSpacing(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\r\u0010\u001f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\nH\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "body", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getBody", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setBody", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "hasCondition", "", "getHasCondition", "()Z", "setHasCondition", "(Z)V", "adjustNestedNodes", "", "configureFormattingAttributes", "considerBlock", "block", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "isEgyptian", "isEgyptian$intellij_database_sql_core_impl", "userRequiresExpand", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1708:1\n1855#2,2:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement\n*L\n1581#1:1709,2\n*E\n"})
    private static final class SecondaryTableElement
    extends SqlRangeBlock {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock body;
        private boolean hasCondition;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlBlock getBody() {
            return this.body;
        }

        public final void setBody(@Nullable SqlBlock sqlBlock) {
            this.body = sqlBlock;
        }

        public final boolean getHasCondition() {
            return this.hasCondition;
        }

        public final void setHasCondition(boolean bl) {
            this.hasCondition = bl;
        }

        @Override
        protected void adjustNestedNodes() {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)adjustNestedNodes.1.INSTANCE));
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node2) {
            BlockRole blockRole;
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            IElementType iElementType = node2.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_AS)) {
                blockRole = BlockRole.AS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER)) {
                blockRole = BlockRole.ALIAS2;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_USING_CLAUSE)) {
                blockRole = BlockRole.AMENDMENT;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_PERIOD)) {
                blockRole = BlockRole.NOTHING;
            } else {
                void var3_3;
                BlockRole r = super.determineRole(node2);
                if (r == BlockRole.NOTHING || r == BlockRole.ELEMENT) {
                    r = BlockRole.BODY;
                }
                blockRole = var3_3;
            }
            return blockRole;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.body = block;
                    break;
                }
                case 2: {
                    this.hasCondition = true;
                }
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.AMENDMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                it2.setMyWrap(SqlFlowBlock.makeWrap$default(this, s2.FROM_WRAP_ON ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null));
                it2.setMyIndent(switch (s2.FROM_PLACE_ON) {
                    case 10 -> {
                        if (s2.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 11 -> {
                        if (s2.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 12 -> {
                        if (s2.FROM_ONLY_JOIN_INDENT == 1) {
                            yield SqlFormattingFunKt.getNORMAL_INDENT();
                        }
                        yield SqlFormattingFunKt.getNONE_INDENT();
                    }
                    case 20 -> Indent.getSpaceIndent((int)0, (boolean)true);
                    case 21 -> Indent.getNormalIndent((boolean)true);
                    default -> this.getMyIndent();
                });
                if (s2.FROM_PLACE_ON == 10) {
                    SqlBlock sqlBlock = this.getParent();
                    PrimaryTableElement primaryTableElement = sqlBlock instanceof PrimaryTableElement ? (PrimaryTableElement)sqlBlock : null;
                    object = primaryTableElement != null ? primaryTableElement.getJoinAlign() : null;
                } else {
                    object = null;
                }
                it2.setMyAlign((Alignment)object);
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            return this.hasCondition && this.getContext().getSql().FROM_WRAP_ON;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            return (r1 == BlockRole.BODY || r1 == BlockRole.AS) && r2 == BlockRole.ALIAS2 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }

        public final boolean isEgyptian$intellij_database_sql_core_impl() {
            return this.body instanceof SqlParenthesizedSubqueryBlock && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        static {
            Object[] objectArray = new FlowPattern[6];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
            objectArray[0] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType), new EndIncElementContinuePattern(SetsKt.setOf((Object)SqlTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE)));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LATERAL;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LATERAL");
            NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_FUNCTION_CALL;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_FUNCTION_CALL");
            objectArray[1] = new SimplePattern(null, null, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), true, BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            objectArray[2] = new StartStopPattern(null, null, NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_START"), NodeMatcherKt.matchTypeName("BQ_DELIMITED_TOKEN_END"), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_JOIN_CONDITION_CLAUSE, (String)"SQL_JOIN_CONDITION_CLAUSE");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_USING_CLAUSE, (String)"SQL_USING_CLAUSE");
            objectArray[3] = new SingletonPattern(null, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[4] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType2, "empty", (Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

                @NotNull
                public final Boolean invoke(@NotNull ASTNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Companion.access$emptyPar((Companion)this.receiver, p0);
                }
            })), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_PARENTHESIZED_JOIN_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_PARENTHESIZED_JOIN_EXPRESSION");
            objectArray[5] = new SingletonExpandPattern(null, null, NodeMatcherKt.matchTypeWhen((IElementType)sqlCompositeElementType3, "not empty", (Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>((Object)Companion){

                @NotNull
                public final Boolean invoke(@NotNull ASTNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Companion.access$notEmptyPar((Companion)this.receiver, p0);
                }
            })), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.8.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SecondaryTableElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "emptyPar", "", "node", "Lcom/intellij/lang/ASTNode;", "notEmptyPar", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            private final boolean emptyPar(ASTNode node2) {
                for (ASTNode c2 = node2.getFirstChildNode(); c2 != null; c2 = c2.getTreeNext()) {
                    IElementType t;
                    boolean nothing;
                    Intrinsics.checkNotNullExpressionValue((Object)c2.getElementType(), (String)"getElementType(...)");
                    boolean bl = nothing = t == SqlTokens.SQL_LEFT_PAREN || t == SqlTokens.SQL_RIGHT_PAREN || SqlTokens.WS_OR_COMMENTS.contains(t) || c2 instanceof PsiErrorElement;
                    if (nothing) continue;
                    return false;
                }
                return true;
            }

            private final boolean notEmptyPar(ASTNode node2) {
                return !this.emptyPar(node2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            public static final /* synthetic */ boolean access$emptyPar(Companion $this, ASTNode node2) {
                return $this.emptyPar(node2);
            }

            public static final /* synthetic */ boolean access$notEmptyPar(Companion $this, ASTNode node2) {
                return $this.notEmptyPar(node2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.BODY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.AMENDMENT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "", "isEgyptian", "", "intellij.database.sql.core.impl"})
    private static interface SectionElement {
        default public boolean isEgyptian() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "essence", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getEssence$intellij_database_sql_core_impl", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setEssence$intellij_database_sql_core_impl", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "isAsterisk", "", "isAsterisk$intellij_database_sql_core_impl", "()Z", "setAsterisk$intellij_database_sql_core_impl", "(Z)V", "considerBlock", "", "block", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getDebugNameSuffix", "", "isEgyptian", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n*L\n1#1,1708:1\n831#2,2:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement\n*L\n1375#1:1709,2\n*E\n"})
    private static final class SelectElement
    extends SqlRangeBlock
    implements SectionElement {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock essence;
        private boolean isAsterisk;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Nullable
        public final SqlBlock getEssence$intellij_database_sql_core_impl() {
            return this.essence;
        }

        public final void setEssence$intellij_database_sql_core_impl(@Nullable SqlBlock sqlBlock) {
            this.essence = sqlBlock;
        }

        public final boolean isAsterisk$intellij_database_sql_core_impl() {
            return this.isAsterisk;
        }

        public final void setAsterisk$intellij_database_sql_core_impl(boolean bl) {
            this.isAsterisk = bl;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SqlBlock makeBlock(@NotNull ASTNode node2) {
            SqlBlock sqlBlock;
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            if (node2 instanceof SqlExpression) {
                void var2_2;
                SqlNodeBlock $this$withSetup$iv = new SelectElementEssence();
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(this, node2);
                sqlBlock = SqlBlockKt.withRole((SqlBlock)var2_2, BlockRole.BODY);
            } else {
                sqlBlock = super.makeBlock(node2);
            }
            return sqlBlock;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            SqlBlock sqlBlock = block;
            if (sqlBlock instanceof SelectElementEssence) {
                this.essence = block;
                this.isAsterisk = this.isAsterisk || ((SelectElementEssence)block).isAsterisk$intellij_database_sql_core_impl();
            } else if (sqlBlock instanceof SqlAliasBlock) {
                block.setRole(this.essence == null ? BlockRole.ALIAS1 : BlockRole.ALIAS2);
            }
        }

        @Override
        public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
                SqlBlock sqlBlock = this.getParent();
                SqlFlowBlock sqlFlowBlock = sqlBlock instanceof SqlFlowBlock ? (SqlFlowBlock)sqlBlock : null;
                if (sqlFlowBlock == null) break block0;
                sqlFlowBlock.countRole$intellij_database_sql_core_impl(role);
            }
        }

        @Override
        public boolean isEgyptian() {
            SqlBlock sqlBlock = this.essence;
            IElementType t = sqlBlock != null ? SqlFormattingModelFun.primaryElementType(sqlBlock) : null;
            return Intrinsics.areEqual((Object)t, (Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) && this.getContext().getSql().SUBQUERY_CONTENT == 2;
        }

        @Override
        @Nullable
        protected String getDebugNameSuffix() {
            return this.isAsterisk ? "*" : null;
        }

        static {
            Object[] objectArray = new SingletonPattern[6];
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_IDENTIFIER");
            objectArray[0] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            SqlTokenType sqlTokenType = SqlTokens.SQL_OP_EQ;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_OP_EQ");
            objectArray[1] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.EQ, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_AS");
            objectArray[2] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_COLUMN_REFERENCE");
            objectArray[3] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            SqlReferenceElementType sqlReferenceElementType2 = SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType2, (String)"SQL_COLUMN_SHORT_REFERENCE");
            objectArray[4] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlReferenceElementType2), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[5] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElement$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElementAmendment;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "intellij.database.sql.core.impl"})
    private static final class SelectElementAmendment
    extends SqlNodeBlock {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectElementEssence;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "isAsterisk", "", "isAsterisk$intellij_database_sql_core_impl", "()Z", "listTheChildren", "", "Lcom/intellij/lang/ASTNode;", "intellij.database.sql.core.impl"})
    private static final class SelectElementEssence
    extends SqlNodeBlock {
        public final boolean isAsterisk$intellij_database_sql_core_impl() {
            char[] cArray = new char[]{'*'};
            return SqlUtilFun.isSymbol(this.getBlockNode(), cArray);
        }

        @Override
        @NotNull
        protected List<ASTNode> listTheChildren() {
            return this.isAsterisk$intellij_database_sql_core_impl() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.getBlockNode());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0014J\b\u0010\u0019\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "firstIsAsterisk", "", "canBeSelectSectionOnly", "canBeSelectSectionOnly$intellij_database_sql_core_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineWrapFirstElement", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "keepFirstAsteriskInline", "patchFormattingAttributesForChildren", "", "produceNestedBlocks", "userCommaSetting", "", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "userWrapSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1708:1\n1855#2,2:1709\n248#3:1711\n38#4:1712\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection\n*L\n1000#1:1709,2\n1039#1:1711\n966#1:1712\n*E\n"})
    private static final class SelectSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private boolean firstIsAsterisk;
        @NotNull
        private static final List<TypePattern> patterns1phrases;
        @NotNull
        private static final List<TypePattern> patterns2phrases;
        @NotNull
        private static final List<FlowPattern> commonPatterns;
        @NotNull
        private static final List<FlowPattern> patterns1;
        @NotNull
        private static final List<FlowPattern> patterns2;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return this.userElementsLineSetting() == 101 || !this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT ? patterns1 : patterns2;
        }

        @Override
        protected void produceNestedBlocks() {
            super.produceNestedBlocks();
            SqlBlock b1e = (SqlBlock)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).first();
            if (b1e instanceof SelectElement) {
                ((SelectElement)b1e).grow();
                this.firstIsAsterisk = ((SelectElement)b1e).isAsterisk$intellij_database_sql_core_impl();
            }
        }

        @Override
        protected boolean determineWrapFirstElement() {
            return !this.keepFirstAsteriskInline() && super.determineWrapFirstElement();
        }

        private final boolean keepFirstAsteriskInline() {
            return this.firstIsAsterisk && !this.getContext().getSql().SELECT_ASTERISK_REGULAR;
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            if (s2.SELECT_ALIGN_AS && s2.SELECT_EL_WRAP != 3) {
                boolean hasAliases1 = false;
                boolean hasAliases2 = false;
                JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).filter(SqlFlowBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlFlowBlock it2 = (SqlFlowBlock)element$iv;
                    boolean bl = false;
                    hasAliases1 = hasAliases1 || SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)it2.getNestedBlocks(), BlockRole.ALIAS1).isNotEmpty();
                    hasAliases2 = hasAliases2 || SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)it2.getNestedBlocks(), BlockRole.ALIAS2).isNotEmpty();
                }
                if (hasAliases1) {
                    if (!s2.QUERY_ALIGN_ELEMENTS) {
                        this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS1);
                    }
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
                }
                if (hasAliases1 && hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.BODY);
                }
                if (hasAliases2) {
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
                    this.tabifyInner(BlockRole.ELEMENT, BlockRole.ALIAS2);
                }
                for (SqlBlock b2 : this.getNestedBlocks()) {
                    SqlBlock inn;
                    if (b2.getMyAlign() == null || b2.isLeaf() || b2.getFirstNestedSqlBlock() == null || inn.getMyAlign() == null) continue;
                    b2.setMyAlign(null);
                }
            }
        }

        @Override
        protected boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse() && this.getMinLength() < this.getContext().getLengthThresholdMin()) {
                return false;
            }
            return this.getContext().getSql().SELECT_EL_WRAP == 1 && this.getCountOfElements() > this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return Math.max(this.getContext().getSql().SELECT_KEEP_N_ITEMS_IN_LINE, this.userElementsLineSetting() == 101 ? SqlUtilFun.toInt(this.firstIsAsterisk) : 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SELECT_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SELECT_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SELECT_EL_COMMA;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return block1 instanceof SelectSeparatedPrefix ? (this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null)) : super.decideSpacing(block1, block2);
        }

        public final boolean canBeSelectSectionOnly$intellij_database_sql_core_impl() {
            return true;
        }

        static {
            Byte by = 0;
            Byte by2 = 1;
            Object[] objectArray = new IElementType[3];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_SELECT, (String)"SQL_SELECT");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_SELECT_OPTION, (String)"SQL_SELECT_OPTION");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_TOP_CLAUSE, (String)"SQL_TOP_CLAUSE");
            patterns1phrases = CollectionsKt.listOf((Object)new TypePattern(by, by2, NodeMatcherKt.matchType((IElementType[])objectArray), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns1phrases.1.INSTANCE)));
            objectArray = new TypePattern[2];
            Byte by3 = 0;
            Byte by4 = 1;
            SqlTokenType sqlTokenType = SqlTokens.SQL_SELECT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_SELECT");
            objectArray[0] = new TypePattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2phrases.1.INSTANCE));
            Byte by5 = 1;
            Byte by6 = 1;
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_SELECT_OPTION, (String)"SQL_SELECT_OPTION");
            Intrinsics.checkNotNullExpressionValue((Object)SqlCompositeElementTypes.SQL_TOP_CLAUSE, (String)"SQL_TOP_CLAUSE");
            objectArray[1] = new TypePattern(by5, by6, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns2phrases.2.INSTANCE));
            patterns2phrases = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new FlowPattern[6];
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
            Byte by7 = 1;
            Byte by8 = 2;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_AS_EXPRESSION");
            objectArray[1] = new SingletonExpandPattern(by7, by8, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
            boolean $i$f$matchElementClass = false;
            objectArray[2] = new SingletonPattern((byte)1, (byte)2, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
            Byte by9 = 2;
            Byte by10 = 2;
            NodeMatcher nodeMatcher = NodeMatcherKt.matchEverything(true);
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
            objectArray[3] = new SingletonPattern(by9, by10, NodeMatcherKt.matchExcept(nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlTokenType3)), BlockRole.AMENDMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
            Byte by11 = 2;
            Byte by12 = 1;
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_COMMA");
            objectArray[4] = new SingletonPattern(by11, by12, NodeMatcherKt.matchType((IElementType)sqlTokenType4), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.5.INSTANCE));
            Byte by13 = 1;
            Byte by14 = 1;
            SqlTokenType sqlTokenType5 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_COMMA");
            objectArray[5] = new SingletonPattern(by13, by14, NodeMatcherKt.matchType((IElementType)sqlTokenType5), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.6.INSTANCE));
            commonPatterns = CollectionsKt.listOf((Object[])objectArray);
            patterns1 = CollectionsKt.plus((Collection)patterns1phrases, (Iterable)commonPatterns);
            patterns2 = CollectionsKt.plus((Collection)patterns2phrases, (Iterable)commonPatterns);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSection$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getCommonPatterns", "()Ljava/util/List;", "patterns1", "getPatterns1", "patterns1phrases", "Lcom/intellij/sql/formatter/model/TypePattern;", "getPatterns1phrases", "patterns2", "getPatterns2", "patterns2phrases", "getPatterns2phrases", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<TypePattern> getPatterns1phrases() {
                return patterns1phrases;
            }

            @NotNull
            public final List<TypePattern> getPatterns2phrases() {
                return patterns2phrases;
            }

            @NotNull
            public final List<FlowPattern> getCommonPatterns() {
                return commonPatterns;
            }

            @NotNull
            public final List<FlowPattern> getPatterns1() {
                return patterns1;
            }

            @NotNull
            public final List<FlowPattern> getPatterns2() {
                return patterns2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SelectSeparatedPrefix;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
    private static final class SelectSeparatedPrefix
    extends SqlRangeBlock {
        @Override
        @NotNull
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return this.getContext().makeSafeSpacing(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetAssignment;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "intellij.database.sql.core.impl"})
    private static final class SetAssignment
    extends SqlNodeBlock {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "patchFormattingAttributesForChildren", "", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SetSection\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n248#2:1709\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SetSection\n*L\n892#1:1709\n*E\n"})
    private static final class SetSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Set<SqlTokenType> additionalPrefixWords;
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().SET_ALIGN_EQUAL_SIGN) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.EQ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().SET_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().SET_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().SET_EL_COMMA;
        }

        static {
            Object[] objectArray = new SqlTokenType[]{SqlTokens.SQL_ON, SqlTokens.SQL_DUPLICATE, SqlTokens.SQL_KEY, SqlTokens.SQL_UPDATE};
            additionalPrefixWords = SetsKt.setOf((Object[])objectArray);
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            objectArray = new FlowPattern[2];
            Object[] objectArray2 = new NodeMatcher[]{NodeMatcherKt.matchAnyKeyword(), NodeMatcherKt.matchType(additionalPrefixWords)};
            objectArray[0] = new RowPattern((byte)0, (byte)1, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_SET_ASSIGNMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_SET_ASSIGNMENT");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SetSection$Companion;", "", "()V", "additionalPrefixWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0014J\b\u0010\u0015\u001a\u00020\u0004H\u0014J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedListBlock;", "()V", "countOfFields", "", "getCountOfFields", "()I", "fields", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getFields", "()Lcom/intellij/util/containers/JBIterable;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "userClosingSetting", "userContentSetting", "userDelimiterSetting", "userOpeningSetting", "userSpaceWithinParentheses", "", "userWrapSetting", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n249#2:1709\n248#2:1710\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock\n*L\n813#1:1709\n819#1:1710\n*E\n"})
    public static final class SqlCortegeLikeParenthesizedListBlock
    extends SqlParenthesizedListBlock {
        @NotNull
        public final JBIterable<SqlBlock> getFields() {
            return SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
        }

        public final int getCountOfFields() {
            return this.getCountOfElements$intellij_database_sql_core_impl();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public BlockRole determineRole(@NotNull ASTNode node2) {
            void what$iv;
            void $this$change$iv;
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            BlockRole blockRole = super.determineRole(node2);
            BlockRole blockRole2 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            boolean $i$f$change = false;
            return Intrinsics.areEqual((Object)$this$change$iv, (Object)what$iv) ? with$iv : blockRole;
        }

        @Override
        protected int userOpeningSetting() {
            return this.getContext().getSql().INSERT_OPENING;
        }

        @Override
        protected int userContentSetting() {
            return this.getContext().getSql().INSERT_CONTENT;
        }

        @Override
        protected int userClosingSetting() {
            return this.getContext().getSql().INSERT_CLOSING;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().INSERT_EL_WRAP;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userDelimiterSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_EL_COMMA;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_COMMA;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public boolean userSpaceWithinParentheses() {
            return this.getContext().getSql().INSERT_SPACE_WITHIN_PARENTHESES;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return block2.getRole() == BlockRole.ELEMENT && block1.getRole() == BlockRole.DELIMITER && this.getContext().getSql().INSERT_MATRIX_ALIGN ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnionSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "userElementsLineSetting", "", "intellij.database.sql.core.impl"})
    private static final class UnionSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        @NotNull
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UnknownSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "whetherSectionToIndent", "", "intellij.database.sql.core.impl"})
    private static final class UnknownSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 0;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$UpdateSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "userElementsLineSetting", "", "intellij.database.sql.core.impl"})
    private static final class UpdateSection
    extends QuerySection {
        @Override
        public int userElementsLineSetting() {
            return 1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0014J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "countOfRows", "", "getCountOfRows$intellij_database_sql_core_impl", "()I", "rows", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SqlCortegeLikeParenthesizedListBlock;", "getRows$intellij_database_sql_core_impl", "()Lcom/intellij/util/containers/JBIterable;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "tailFormed", "", "userCommaSetting", "userElementsLineSetting", "userNumberOfElementsToKeepCollapsed", "userWrapSetting", "whetherSectionToIndent", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n467#2,3:1709\n248#3:1712\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection\n*L\n769#1:1709,3\n782#1:1712\n*E\n"})
    public static final class ValuesSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @NotNull
        public final JBIterable<SqlCortegeLikeParenthesizedListBlock> getRows$intellij_database_sql_core_impl() {
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
            JBIterable jBIterable2 = jBIterable.filter(SqlCortegeLikeParenthesizedListBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            return jBIterable2;
        }

        public final int getCountOfRows$intellij_database_sql_core_impl() {
            return this.getCountOfElements();
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        public int userNumberOfElementsToKeepCollapsed() {
            return this.getContext().getSql().INSERT_COLLAPSE_MULTI_ROW_VALUES ? (this.getContext().getLengthThresholdMax() - 7) / 4 : 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().INSERT_VALUES_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getCountOfElements() <= this.userNumberOfElementsToKeepCollapsed() ? 2 : 1;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().INSERT_CLOSING >= 3 && this.getContext().getSql().INSERT_OPENING == 1 ? 4 : this.getContext().getSql().INSERT_EL_COMMA;
        }

        @Override
        public boolean tailFormed() {
            SqlBlock sqlBlock = this.getLastNestedSqlBlock();
            if (sqlBlock == null) {
                return false;
            }
            SqlBlock last2 = sqlBlock;
            return switch (WhenMappings.$EnumSwitchMapping$0[last2.getRole().ordinal()]) {
                case 1, 2, 3 -> false;
                default -> true;
            };
        }

        static {
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARENTHESIZED_EXPRESSION");
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new SingletonExpandPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.DELIMITER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0004H\u0014J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "delimiterLength", "", "getDelimiterLength", "()I", "<set-?>", "Lcom/intellij/sql/psi/SqlTokenType;", "delimiterType", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "setDelimiterType", "(Lcom/intellij/sql/psi/SqlTokenType;)V", "adjustNestedNodes", "", "determinePrimaryDelimiter", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userCommaSetting", "userElementsLineSetting", "userWrapSetting", "whetherSectionToIndent", "", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 NodeMatcher.kt\ncom/intellij/sql/formatter/model/NodeMatcherKt\n*L\n1#1,1708:1\n1#2:1709\n248#3:1710\n38#4:1711\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection\n*L\n1154#1:1710\n1124#1:1711\n*E\n"})
    private static final class WhereSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private SqlTokenType delimiterType;
        @NotNull
        private static final List<FlowPattern> patterns;

        public WhereSection() {
            SqlTokenType sqlTokenType = SqlTokens.SQL_NO;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_NO");
            this.delimiterType = sqlTokenType;
        }

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public boolean whetherSectionToIndent() {
            return true;
        }

        @Override
        @NotNull
        protected SqlTokenType getDelimiterType() {
            return this.delimiterType;
        }

        public void setDelimiterType(@NotNull SqlTokenType sqlTokenType) {
            Intrinsics.checkNotNullParameter((Object)sqlTokenType, (String)"<set-?>");
            this.delimiterType = sqlTokenType;
        }

        @Override
        protected int getDelimiterLength() {
            SqlTokenType sqlTokenType = this.getDelimiterType();
            return Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlTokens.SQL_OR) ? 2 : (Intrinsics.areEqual((Object)sqlTokenType, (Object)SqlTokens.SQL_AND) ? 3 : 1);
        }

        @Override
        protected void adjustNestedNodes() {
            super.adjustNestedNodes();
            this.determinePrimaryDelimiter();
            if (this.getDelimiterType() != SqlTokens.SQL_NO) {
                this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)new Function1<ASTNode, Boolean>(this){
                    final /* synthetic */ WhereSection this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ASTNode it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(it2.getElementType()) && SqlUtilFun.hasChildNode(it2, (IElementType)this.this$0.getDelimiterType());
                    }
                }));
            }
        }

        private final void determinePrimaryDelimiter() {
            Object v0;
            block3: {
                Iterable iterable = this.getNestedNodes();
                for (Object t : iterable) {
                    ASTNode it2 = (ASTNode)t;
                    boolean bl = false;
                    if (!SqlCompositeElementTypes.SQL_BINARY_EXPRESSION.contains(it2.getElementType())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            ASTNode aSTNode = v0;
            if (aSTNode == null) {
                return;
            }
            ASTNode conditionNode = aSTNode;
            for (ASTNode child : SqlUtilFun.children(conditionNode)) {
                IElementType type2;
                Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"getElementType(...)");
                if (type2 != SqlTokens.SQL_OR && type2 != SqlTokens.SQL_AND) continue;
                this.setDelimiterType((SqlTokenType)type2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WHERE_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WHERE_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WHERE_EL_BOUND;
        }

        static {
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            Object[] objectArray = new SingletonPattern[2];
            boolean $i$f$matchElementClass = false;
            objectArray[0] = new SingletonPattern((byte)1, null, NodeMatcherKt.matchElementClass(SqlExpression.class), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by = 1;
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_OR, (String)"SQL_OR");
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_AND, (String)"SQL_AND");
            objectArray[1] = new SingletonPattern(by, null, NodeMatcherKt.matchType(iElementTypeArray), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WhereSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u00012\u00020\u0002:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowEntry;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$SectionElement;", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
    private static final class WindowEntry
    extends SqlNodeBlock
    implements SectionElement {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        static {
            Object[] objectArray = new FlowPattern[4];
            Byte by = 0;
            Byte by2 = 1;
            SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_WINDOW_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SQL_WINDOW_REFERENCE");
            objectArray[0] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlReferenceElementType), BlockRole.ALIAS1, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
            Byte by3 = 1;
            Byte by4 = 2;
            SqlTokenType sqlTokenType = SqlTokens.SQL_AS;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_AS");
            objectArray[1] = new SingletonPattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.AS, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
            Byte by5 = 2;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
            NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
            SqlTokenType sqlTokenType3 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_RIGHT_PAREN");
            objectArray[2] = new StartStopPattern(by5, null, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.BODY, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
            Byte by6 = 2;
            SqlTokenType sqlTokenType4 = SqlTokens.SQL_LEFT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_LEFT_PAREN");
            objectArray[3] = new UntilPattern(by6, null, NodeMatcherKt.matchType((IElementType)sqlTokenType4), true, BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
            patterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowEntry$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userDelimiterSetting", "", "userElementsLineSetting", "Companion", "intellij.database.sql.core.impl"})
    private static final class WindowSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        public int userElementsLineSetting() {
            return -1;
        }

        @Override
        public int userDelimiterSetting() {
            return 0;
        }

        @Override
        protected void configureFormattingAttributes() {
            super.configureFormattingAttributes();
            this.getNestedBlocks();
        }

        static {
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_GENERIC_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_GENERIC_DEFINITION");
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WindowSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014J\b\u0010\b\u001a\u00020\u0004H\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "()V", "analyseOriginalCodeStyle", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "patchFormattingAttributesForChildren", "userCommaSetting", "", "userElementsLineSetting", "userWrapSetting", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WithSection\n+ 2 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,1708:1\n467#2,3:1709\n467#2,3:1712\n248#3:1715\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WithSection\n*L\n931#1:1709,3\n932#1:1712,3\n945#1:1715\n*E\n"})
    private static final class WithSection
    extends WordAndListSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            if (this.getCountOfElements() >= 2 && this.getContext().getSql().WITH_EL_WRAP == 1) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            boolean toAlignClosingParen;
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().WITH_ALIGN_AS) {
                this.tabifyInner(BlockRole.ELEMENT, BlockRole.AS);
            }
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            boolean toAlignInnerQueries = s2.SUBQUERY_CONTENT >= 2;
            boolean bl = toAlignClosingParen = s2.SUBQUERY_CLOSING >= 2;
            if (this.getCountOfElements() >= 2 && (toAlignInnerQueries || toAlignClosingParen) && s2.QUERY_ALIGN_ELEMENTS) {
                Alignment closingParenAlignment;
                Alignment innerQueriesAlignment = toAlignInnerQueries ? SqlFormattingModelFun.makeLeftAlignment() : null;
                Object object = closingParenAlignment = toAlignClosingParen ? SqlFormattingModelFun.makeLeftAlignment() : null;
                if (toAlignInnerQueries && toAlignClosingParen && s2.SUBQUERY_CLOSING == 6) {
                    closingParenAlignment = innerQueriesAlignment;
                }
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(CTE.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                for (CTE cte : jBIterable2) {
                    Iterable $this$filter$iv2 = cte.getNestedBlocks();
                    boolean $i$f$filter2 = false;
                    Iterable $this$jbi$iv$iv2 = $this$filter$iv2;
                    boolean $i$f$getJbi2 = false;
                    JBIterable jBIterable3 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"from(...)");
                    JBIterable jBIterable4 = jBIterable3.filter(SqlParenthesizedSubqueryBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
                    for (SqlParenthesizedSubqueryBlock pb : jBIterable4) {
                        for (SqlBlock b2 : pb.getNestedBlocks()) {
                            switch (WhenMappings.$EnumSwitchMapping$0[b2.getRole().ordinal()]) {
                                case 1: {
                                    b2.setMyAlign(innerQueriesAlignment);
                                    break;
                                }
                                case 2: {
                                    b2.setMyAlign(closingParenAlignment);
                                }
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int userElementsLineSetting() {
            void what$iv;
            void $this$change$iv;
            int n = this.getContext().getSql().WITH_EL_LINE;
            int n3 = -1;
            int with$iv = this.getContext().getSql().QUERY_EL_LINE;
            boolean $i$f$change = false;
            return $this$change$iv == what$iv ? with$iv : n;
        }

        @Override
        public int userWrapSetting() {
            return this.getContext().getSql().WITH_EL_WRAP;
        }

        @Override
        protected int userCommaSetting() {
            return this.getContext().getSql().WITH_EL_COMMA;
        }

        static {
            Collection collection2 = WordAndListSection.Companion.getCommonPatterns();
            Byte by = 1;
            SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_NAMED_QUERY_DEFINITION");
            patterns = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object)new SingletonPattern(by, null, NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE))));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WithSection$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.BODY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.SUFFIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 A2\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0004H\u0002J\b\u0010+\u001a\u00020&H\u0014J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020 H\u0014J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020 H\u0016J\b\u00102\u001a\u00020\u0004H\u0014J\u0010\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104H$J\b\u00106\u001a\u00020\u0004H\u0014J\b\u00107\u001a\u000208H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010(2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020&H\u0014J\b\u0010=\u001a\u00020\u0004H\u0014J\b\u0010>\u001a\u00020\nH\u0015J\b\u0010?\u001a\u00020\nH\u0016J\b\u0010@\u001a\u00020\u0004H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R$\u0010\t\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006B"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection;", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$QuerySection;", "()V", "comma1st", "", "getComma1st", "()Z", "commaLast", "getCommaLast", "commaPlace", "", "getCommaPlace$annotations", "getCommaPlace", "()I", "setCommaPlace", "(I)V", "countOfDelimiters", "getCountOfDelimiters", "setCountOfDelimiters", "countOfElements", "getCountOfElements", "setCountOfElements", "countOfLineComments", "getCountOfLineComments", "setCountOfLineComments", "delimiterLength", "getDelimiterLength", "delimiterType", "Lcom/intellij/sql/psi/SqlTokenType;", "getDelimiterType", "()Lcom/intellij/sql/psi/SqlTokenType;", "prefix", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getPrefix", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setPrefix", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "analyseOriginalCodeStyle", "", "computeElementIndent", "", "offset", "trueIndent", "configureFormattingAttributes", "considerBlock", "block", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "determineWrapFirstElement", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "flowToProduceCommentsFlowBlocks", "getChildAttributesForNewElementAtTheEnd", "Lcom/intellij/formatting/ChildAttributes;", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "patchFormattingAttributesForChildren", "toAlignElements", "userCommaSetting", "userNumberOfElementsToKeepCollapsed", "userRequiresExpand", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlQueryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n1#1,1708:1\n1#2:1709\n1855#3,2:1710\n1855#3,2:1712\n1855#3,2:1714\n1855#3,2:1716\n1855#3,2:1718\n1855#3,2:1720\n1855#3,2:1722\n1855#3,2:1724\n1855#3,2:1729\n1855#3,2:1734\n467#4,3:1726\n467#4,3:1731\n473#4:1736\n473#4:1737\n*S KotlinDebug\n*F\n+ 1 SqlQueryBlock.kt\ncom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection\n*L\n531#1:1710,2\n534#1:1712,2\n535#1:1714,2\n543#1:1716,2\n549#1:1718,2\n552#1:1720,2\n573#1:1722,2\n586#1:1724,2\n587#1:1729,2\n600#1:1734,2\n587#1:1726,3\n598#1:1731,3\n672#1:1736\n673#1:1737\n*E\n"})
    public static abstract class WordAndListSection
    extends QuerySection {
        @NotNull
        protected static final Companion Companion = new Companion(null);
        @Nullable
        private SqlBlock prefix;
        private int countOfElements;
        private int countOfDelimiters;
        private int countOfLineComments;
        private int commaPlace;
        @NotNull
        private static final List<FlowPattern> commonPatterns;

        @Nullable
        public final SqlBlock getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(@Nullable SqlBlock sqlBlock) {
            this.prefix = sqlBlock;
        }

        public final int getCountOfElements() {
            return this.countOfElements;
        }

        public final void setCountOfElements(int n) {
            this.countOfElements = n;
        }

        public final int getCountOfDelimiters() {
            return this.countOfDelimiters;
        }

        public final void setCountOfDelimiters(int n) {
            this.countOfDelimiters = n;
        }

        public final int getCountOfLineComments() {
            return this.countOfLineComments;
        }

        public final void setCountOfLineComments(int n) {
            this.countOfLineComments = n;
        }

        @NotNull
        protected SqlTokenType getDelimiterType() {
            SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_COMMA");
            return sqlTokenType;
        }

        protected int getDelimiterLength() {
            return 1;
        }

        @Override
        @Nullable
        protected abstract List<FlowPattern> flowPatterns();

        @Override
        protected boolean flowToProduceCommentsFlowBlocks() {
            return false;
        }

        @Override
        protected void considerBlock(@NotNull SqlBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            super.considerBlock(block);
            switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
                case 1: {
                    this.prefix = block;
                    break;
                }
                case 2: {
                    int n = this.countOfElements;
                    this.countOfElements = n + 1;
                    break;
                }
                case 3: {
                    int n = this.countOfDelimiters;
                    this.countOfDelimiters = n + 1;
                    break;
                }
                case 4: {
                    int n = this.countOfLineComments;
                    this.countOfLineComments = n + 1;
                }
            }
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected int userCommaSetting() {
            return 0;
        }

        protected final int getCommaPlace() {
            return this.commaPlace;
        }

        protected final void setCommaPlace(int n) {
            this.commaPlace = n;
        }

        @SqlCodeStyleConst.CommaPlusMagicValues
        protected static /* synthetic */ void getCommaPlace$annotations() {
        }

        protected boolean getComma1st() {
            return this.commaPlace == 1;
        }

        protected boolean getCommaLast() {
            return this.commaPlace == 2;
        }

        @Override
        protected void analyseOriginalCodeStyle() {
            super.analyseOriginalCodeStyle();
            SqlBlock p2 = this.prefix;
            if (p2 != null) {
                p2.analyze();
                this.setPrefixLength$intellij_database_sql_core_impl(p2.getMinLength());
                if (p2 instanceof SqlSingleNodeBlock) {
                    this.setPrefixSize$intellij_database_sql_core_impl(1);
                    this.setFirstWord$intellij_database_sql_core_impl(SqlFormattingModelFun.primaryElementType(p2));
                    this.setFirstWordLength$intellij_database_sql_core_impl(this.getPrefixLength$intellij_database_sql_core_impl());
                } else {
                    SqlBlock firstWordBlock;
                    List<SqlBlock> pBlocks = p2.getNestedBlocks();
                    this.setPrefixSize$intellij_database_sql_core_impl(pBlocks.size());
                    SqlBlock sqlBlock = firstWordBlock = (SqlBlock)CollectionsKt.firstOrNull(pBlocks);
                    this.setFirstWord$intellij_database_sql_core_impl((IElementType)(sqlBlock != null ? SqlFormattingModelFun.primaryElementType(sqlBlock) : null));
                    SqlBlock sqlBlock2 = firstWordBlock;
                    this.setFirstWordLength$intellij_database_sql_core_impl(sqlBlock2 != null ? sqlBlock2.getRange().getLength() : 0);
                }
            }
            if (this.countOfDelimiters > 0) {
                this.commaPlace = this.userCommaSetting();
                if (this.commaPlace == -1) {
                    this.commaPlace = this.getContext().getSql().QUERY_EL_COMMA;
                }
                if (this.commaPlace == 0) {
                    this.commaPlace = SqlCommonHandlersKt.autodetectDelimiter(this.getContext(), (Iterable<? extends SqlBlock>)this.getNestedBlocks());
                }
                if (this.commaPlace == -1 || this.commaPlace == 0) {
                    this.commaPlace = 2;
                }
            } else {
                this.commaPlace = 0;
            }
            int wrapSetting = this.userWrapSetting();
            if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) <= 0 && this.countOfElements >= 2 && (wrapSetting == 0 || wrapSetting == 3 || wrapSetting == 1) && this.getContext().getKlb() && this.getHasUserBreaks()) {
                this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
            }
        }

        @Override
        protected void configureFormattingAttributes() {
            block53: {
                SqlCodeStyleSettings s2 = this.getContext().getSql();
                boolean firstIsAllOrDistinct = false;
                boolean wrapFirst = this.determineWrapFirstElement();
                if (this.commaPlace != 4) {
                    WrapType wt = switch (WhenMappings.$EnumSwitchMapping$1[this.getShape().ordinal()]) {
                        case 1 -> {
                            switch (this.userWrapSetting()) {
                                case 1: 
                                case 2: {
                                    yield WrapType.CHOP_DOWN_IF_LONG;
                                }
                                case 3: {
                                    yield WrapType.NORMAL;
                                }
                            }
                            if (this.countOfElements <= this.userNumberOfElementsToKeepCollapsed()) {
                                yield null;
                            }
                            yield WrapType.NORMAL;
                        }
                        case 2 -> {
                            switch (this.userWrapSetting()) {
                                case 1: 
                                case 2: {
                                    yield WrapType.ALWAYS;
                                }
                            }
                            yield WrapType.NORMAL;
                        }
                        default -> null;
                    };
                    Wrap w = SqlFlowBlock.makeWrap$default(this, wt, false, 2, null);
                    Wrap wrap2 = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
                    Intrinsics.checkNotNull((Object)wrap2);
                    Wrap dontWrap = wrap2;
                    int k = 0;
                    for (SqlBlock b2 : this.getNestedBlocks()) {
                        block11 : switch (WhenMappings.$EnumSwitchMapping$0[b2.getRole().ordinal()]) {
                            case 2: {
                                switch (++k) {
                                    case 1: {
                                        b2.setMyWrap(wrapFirst ? w : dontWrap);
                                        if (SqlFormattingModelFun.primaryElementType(b2) != SqlCompositeElementTypes.SQL_SELECT_OPTION) break block11;
                                        firstIsAllOrDistinct = true;
                                        break;
                                    }
                                    case 2: {
                                        if (firstIsAllOrDistinct && this.getContext().getSql().SELECT_NEW_LINE_AFTER_ALL_DISTINCT) {
                                            b2.setMyWrap(w);
                                            break;
                                        }
                                        b2.setMyWrap(this.getCommaLast() ? w : dontWrap);
                                        break;
                                    }
                                    default: {
                                        b2.setMyWrap(this.getCommaLast() ? w : dontWrap);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 5: {
                                b2.setMyIndent(SqlFormattingFunKt.getCONTINUATION_INDENT());
                                break;
                            }
                            case 3: {
                                b2.setMyWrap(this.getComma1st() ? w : dontWrap);
                            }
                        }
                    }
                }
                if (this.commaPlace == 1) {
                    if (wrapFirst) {
                        if (s2.QUERY_ALIGN_ELEMENTS) {
                            int indentSize = this.getContext().getIndentSize();
                            Indent iE = Indent.getNormalIndent((boolean)s2.QUERY_TRUE_INDENT);
                            Indent iD = indentSize >= 2 ? Indent.getSpaceIndent((int)(indentSize - 2), (boolean)s2.QUERY_TRUE_INDENT) : SqlFormattingFunKt.getNONE_INDENT();
                            SqlBlock sqlBlock = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                            if (sqlBlock != null) {
                                SqlBlock b2;
                                b2 = sqlBlock;
                                SqlBlock it2 = b2;
                                boolean bl = false;
                                it2.setMyIndent(iE);
                            }
                            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                SqlBlock it3 = (SqlBlock)element$iv;
                                boolean bl = false;
                                it3.setMyIndent(iD);
                            }
                        } else {
                            SqlBlock it4;
                            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                            boolean $i$f$forEach = false;
                            for (Iterator element$iv : $this$forEach$iv) {
                                it4 = (SqlBlock)((Object)element$iv);
                                boolean bl = false;
                                it4.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT_ETC());
                            }
                            $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                            $i$f$forEach = false;
                            for (Iterator element$iv : $this$forEach$iv) {
                                it4 = (SqlBlock)((Object)element$iv);
                                boolean bl = false;
                                it4.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                            }
                        }
                    } else {
                        i = this.userElementsLineSetting() == 1 ? Indent.getSpaceIndent((int)(this.getPrefixLength$intellij_database_sql_core_impl() - this.getDelimiterLength()), (boolean)true) : Indent.getNormalIndent((boolean)true);
                        $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER, BlockRole.LINE_COMMENT);
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            SqlBlock it5 = (SqlBlock)element$iv;
                            boolean bl = false;
                            it5.setMyIndent(i);
                        }
                    }
                } else {
                    i = Indent.getNormalIndent((s2.QUERY_TRUE_INDENT && this.countOfElements + this.countOfDelimiters > 1 ? 1 : 0) != 0);
                    $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT, BlockRole.LINE_COMMENT);
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it6 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it6.setMyIndent(i);
                    }
                    Indent i2 = Indent.getContinuationIndent();
                    Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it7 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it7.setMyIndent(i2);
                    }
                }
                if (!this.toAlignElements()) break block53;
                if (this.getComma1st()) {
                    if (wrapFirst || firstIsAllOrDistinct) {
                        alignForDelimiter = SqlFormattingModelFun.makeRightAlignment();
                        Alignment alignForElements = SqlFormattingModelFun.makeLeftAlignmentBS();
                        for (SqlBlock b3 : this.getNestedBlocks()) {
                            switch (WhenMappings.$EnumSwitchMapping$0[b3.getRole().ordinal()]) {
                                case 3: {
                                    SqlLeafBlock sqlLeafBlock = b3.getLastLeafBlock();
                                    if (sqlLeafBlock == null) break;
                                    sqlLeafBlock.setMyAlign(alignForDelimiter);
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    b3.setMyAlign(alignForElements);
                                }
                            }
                        }
                    } else {
                        Alignment alignment;
                        if (this.getPrefixSize$intellij_database_sql_core_impl() == 1) {
                            alignment = this.getThisQuery$intellij_database_sql_core_impl().getCommonFirstWordRightAlign();
                            if (alignment == null) {
                                alignment = SqlFormattingModelFun.makeRightAlignment();
                            }
                        } else {
                            alignment = SqlFormattingModelFun.makeRightAlignment();
                        }
                        alignForDelimiter = alignment;
                        Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.PREFIX, BlockRole.DELIMITER);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            SqlBlock it8 = (SqlBlock)element$iv;
                            boolean bl = false;
                            SqlLeafBlock sqlLeafBlock = it8.getLastLeafBlock();
                            if (sqlLeafBlock == null) continue;
                            sqlLeafBlock.setMyAlign(alignForDelimiter);
                        }
                    }
                } else {
                    SqlBlock b4;
                    Alignment a = null;
                    a = SqlFormattingModelFun.makeLeftAlignment();
                    if (this.countOfLineComments > 0 && this.countOfElements > 0 && this.getNestedBlocks().size() >= 3 && (b4 = this.getNestedBlocks().get(1)) instanceof SqlLineCommentBlock) {
                        a = SqlFormattingModelFun.makeLeftAlignmentBS();
                        b4.setMyAlign(a);
                    }
                    Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlBlock it9 = (SqlBlock)element$iv;
                        boolean bl = false;
                        it9.setMyAlign(a);
                    }
                    Iterable $this$filter$iv = this.getNestedBlocks();
                    boolean $i$f$filter = false;
                    Iterable $this$jbi$iv$iv = $this$filter$iv;
                    boolean $i$f$getJbi = false;
                    JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                    JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                    JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> WordAndListSection.configureFormattingAttributes$lambda$9(configureFormattingAttributes.10.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
                    $this$forEach$iv = (Iterable)jBIterable3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlLineCommentBlock it10 = (SqlLineCommentBlock)element$iv;
                        boolean bl = false;
                        it10.setMyAlign(a);
                    }
                }
            }
        }

        @Override
        protected void patchFormattingAttributesForChildren() {
            super.patchFormattingAttributesForChildren();
            if (this.getContext().getSql().QUERY_ALIGN_LINE_COMMENTS) {
                Alignment a = SqlFormattingModelFun.makeLeftAlignmentBS();
                Iterable $this$filter$iv = this.getNestedBlocks();
                boolean $i$f$filter = false;
                Iterable $this$jbi$iv$iv = $this$filter$iv;
                boolean $i$f$getJbi = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
                JBIterable jBIterable2 = jBIterable.filter(SqlLineCommentBlock.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
                JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> WordAndListSection.patchFormattingAttributesForChildren$lambda$11(patchFormattingAttributesForChildren.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlLineCommentBlock it2 = (SqlLineCommentBlock)element$iv;
                    boolean bl = false;
                    if (it2.getMyAlign() != null) continue;
                    it2.setMyAlign(a);
                }
            }
        }

        protected boolean determineWrapFirstElement() {
            return this.userElementsLineSetting() == 101;
        }

        protected boolean toAlignElements() {
            return this.getContext().getSql().QUERY_ALIGN_ELEMENTS;
        }

        public int userNumberOfElementsToKeepCollapsed() {
            return this.userElementsLineSetting() >= 101 ? 0 : 1;
        }

        @Override
        protected boolean userRequiresExpand() {
            if (this.getThisQuery$intellij_database_sql_core_impl().allowedToCollapse()) {
                return false;
            }
            return this.countOfElements > this.userNumberOfElementsToKeepCollapsed() && this.userWrapSetting() == 1 || this.countOfElements >= 1 && this.userElementsLineSetting() >= 101;
        }

        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            BlockRole r1 = block1.getRole();
            BlockRole r2 = block2.getRole();
            boolean y1 = block1 instanceof SectionElement && ((SectionElement)((Object)block1)).isEgyptian();
            boolean y2 = block2 instanceof SectionElement && ((SectionElement)((Object)block2)).isEgyptian();
            if (r1 == BlockRole.PREFIX && this.determineWrapFirstElement() && this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS) {
                SqlLeafBlock sqlLeafBlock = block2.getFirstLeafBlock();
                if (!Intrinsics.areEqual((Object)(sqlLeafBlock != null ? sqlLeafBlock.getElementType() : null), (Object)SqlTokens.SQL_ASTERISK) && !y2) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
            }
            if (r1 == BlockRole.ELEMENT && block1.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y1 && this.getComma1st()) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (r2 == BlockRole.ELEMENT && block2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && !y2 && this.getCommaLast() && r1 != BlockRole.PREFIX) {
                return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
            }
            if (block1 instanceof SqlComma) {
                int wrapSetting = this.userWrapSetting();
                return this.getComma1st() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : (this.getCommaLast() ? SqlFormattingContext.makeSpace$default(this.getContext(), false, (wrapSetting == 0 || wrapSetting == 3) && this.getContext().getKlb(), 1, null) : SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null));
            }
            if (block2 instanceof SqlComma) {
                if (this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS && this.getComma1st() && SqlFormattingModelFun.isAlways(block2.getMyWrap())) {
                    return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
                }
                return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
            }
            return super.decideSpacing(block1, block2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
            Object newIndent = SqlFormattingFunKt.getNONE_INDENT();
            Alignment newAlignment = null;
            if (this.countOfElements + this.countOfDelimiters == 0 && this.userBreakFirstElement()) {
                newIndent = SqlFormattingFunKt.getNORMAL_INDENT();
            } else if (this.countOfDelimiters >= this.countOfElements && this.countOfElements > 1) {
                SqlBlock b2;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2;
                block5: {
                    List<SqlBlock> list = this.getNestedBlocks();
                    ListIterator<SqlBlock> listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        SqlBlock sqlBlock3;
                        SqlBlock it2 = sqlBlock3 = listIterator.previous();
                        boolean bl = false;
                        if (!(it2.getRole() == BlockRole.ELEMENT)) continue;
                        sqlBlock2 = sqlBlock3;
                        break block5;
                    }
                    sqlBlock2 = null;
                }
                if ((sqlBlock = (b2 = (SqlBlock)sqlBlock2)) == null || (sqlBlock = sqlBlock.getIndent()) == null) {
                    sqlBlock = SqlFormattingFunKt.getNONE_INDENT();
                }
                newIndent = sqlBlock;
                SqlBlock sqlBlock4 = b2;
                newAlignment = sqlBlock4 != null ? sqlBlock4.getAlignment() : null;
            }
            return new ChildAttributes(newIndent, newAlignment);
        }

        @Override
        @Nullable
        public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
            String string;
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            this.analyze();
            SqlBlock b1 = blocks.getBlock1();
            SqlBlock b2 = blocks.getBlock2();
            if (b1 instanceof SqlCommentBlock) {
                int k;
                SqlBlock p2 = ((SqlCommentBlock)b1).getParent();
                for (k = p2.getNestedBlocks().indexOf(b1); k > 0 && p2.getNestedBlocks().get(k) instanceof SqlCommentBlock; --k) {
                }
                b1 = p2.getNestedBlocks().get(k);
            }
            SqlBlock $this$role$iv = b1;
            boolean $i$f$getRole = false;
            Object object = $this$role$iv;
            if (object == null || (object = ((SqlBlock)object).getRole()) == null) {
                object = BlockRole.NOTHING;
            }
            Object r1 = object;
            SqlBlock $this$role$iv2 = b2;
            boolean $i$f$getRole2 = false;
            Object object2 = $this$role$iv2;
            if (object2 == null || (object2 = object2.getRole()) == null) {
                object2 = BlockRole.NOTHING;
            }
            Object r2 = object2;
            boolean trueIndent = this.getContext().getSql().QUERY_TRUE_INDENT;
            if (r2 == BlockRole.NOTHING) {
                switch (WhenMappings.$EnumSwitchMapping$0[((Enum)r1).ordinal()]) {
                    case 1: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
                        break;
                    }
                    case 2: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, false, false, 12, null);
                        break;
                    }
                    case 3: {
                        string = this.computeElementIndent(this.getRange().getEndOffset(), trueIndent);
                        break;
                    }
                    default: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, false, false, 12, null);
                        break;
                    }
                }
            } else if (r2 == BlockRole.ELEMENT || r1 == BlockRole.DELIMITER) {
                SqlBlock sqlBlock = b1;
                string = this.computeElementIndent(sqlBlock != null && (sqlBlock = sqlBlock.getRange()) != null ? sqlBlock.getStartOffset() : this.getRange().getEndOffset(), trueIndent);
            } else if (r2 == BlockRole.DELIMITER) {
                if (this.getComma1st()) {
                    int plusSpaces = Math.max(this.getPrefixLength$intellij_database_sql_core_impl() - this.getDelimiterLength(), 0);
                    string = this.getContext().currIndentOf(this, trueIndent, plusSpaces);
                } else {
                    string = this.userElementsLineSetting() == 1 ? this.getContext().currIndentOf(this, trueIndent, this.getPrefixLength$intellij_database_sql_core_impl() + 1) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
                }
            } else {
                string = null;
            }
            return string;
        }

        private final String computeElementIndent(int offset, boolean trueIndent) {
            int x = offset;
            if (this.getContext().getText().charAt(x) == '\n') {
                --x;
            }
            if (this.getContext().getText().charAt(x) == '\r') {
                --x;
            }
            SqlBlock firstElementOnThisLine2 = SqlFormattingModelFun.findFirstInnerBlockOnTheSameLine(this, x, (Function1<? super SqlBlock, Boolean>)((Function1)computeElementIndent.firstElementOnThisLine.1.INSTANCE));
            return firstElementOnThisLine2 != null ? SqlFormattingContext.currIndentOf$default(this.getContext(), firstElementOnThisLine2, true, false, false, 12, null) : SqlFormattingContext.currIndentOf$default(this.getContext(), this, trueIndent, true, false, 8, null);
        }

        private static final boolean configureFormattingAttributes$lambda$9(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean patchFormattingAttributesForChildren$lambda$11(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            Object[] objectArray = new FlowPattern[4];
            SqlTokenType sqlTokenType = SqlTokens.SQL_LINE_COMMENT;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LINE_COMMENT");
            objectArray[0] = new SingletonPattern(null, null, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.LINE_COMMENT, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.1.INSTANCE));
            Byte by = 0;
            Byte by2 = 1;
            Object[] objectArray2 = new NodeMatcher[2];
            objectArray2[0] = NodeMatcherKt.matchAnyKeyword();
            IElementType[] iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_BY, (String)"SQL_BY");
            Intrinsics.checkNotNullExpressionValue((Object)SqlTokens.SQL_WITH, (String)"SQL_WITH");
            objectArray2[1] = NodeMatcherKt.matchType(iElementTypeArray);
            objectArray[1] = new RowPattern(by, by2, CollectionsKt.listOf((Object[])objectArray2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.2.INSTANCE));
            objectArray[2] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchAnyKeyword(), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.3.INSTANCE));
            Byte by3 = 1;
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_COMMA");
            objectArray[3] = new SingletonPattern(by3, null, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.commonPatterns.4.INSTANCE));
            commonPatterns = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlQueryBlock$WordAndListSection$Companion;", "", "()V", "commonPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getCommonPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        protected static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getCommonPatterns() {
                return commonPatterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[BlockRole.values().length];
                try {
                    nArray[BlockRole.PREFIX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.ELEMENT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.DELIMITER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.LINE_COMMENT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockRole.AMENDMENT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[BlockShape.values().length];
                try {
                    nArray[BlockShape.DECIDE_LATER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BlockShape.DECIDED_TO_MULTI_ROWS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

