/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlParenthesizedBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedBlock;", "()V", "closingBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "defaultIndent", "Lcom/intellij/formatting/Indent;", "openingBlock", "queryBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "adjustNestedNodes", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "defaultChildIndent", "block", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "tuneNestedNodesAfterAnalysis", "userRequiresExpand", "", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlParenthesizedBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n288#2,2:204\n*S KotlinDebug\n*F\n+ 1 SqlParenthesizedBlock.kt\ncom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock\n*L\n56#1:204,2\n*E\n"})
public class SqlParenthesizedSubqueryBlock
extends SqlParenthesizedBlock {
    @Nullable
    private SqlBlock openingBlock;
    @Nullable
    private SqlBlock closingBlock;
    @Nullable
    private SqlQueryBlock queryBlock;
    @NotNull
    private Indent defaultIndent = SqlFormattingFunKt.getNORMAL_INDENT();

    @Override
    protected void adjustNestedNodes() {
        super.adjustNestedNodes();
        if (this.getNestedNodes().size() == 1 && this.getNestedNodes().get(0).getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)adjustNestedNodes.1.INSTANCE));
        }
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        SqlBlock b2 = super.makeBlock(node2);
        char[] cArray = new char[]{'('};
        if (SqlUtilFun.isSymbol(node2, cArray)) {
            if (this.openingBlock == null) {
                this.openingBlock = b2;
            }
        } else {
            cArray = new char[]{')'};
            if (SqlUtilFun.isSymbol(node2, cArray)) {
                this.closingBlock = b2;
            } else if (b2 instanceof SqlQueryBlock) {
                this.queryBlock = (SqlQueryBlock)b2;
            }
        }
        return b2;
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        Object v0;
        block4: {
            super.tuneNestedNodesAfterAnalysis();
            if (this.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
                return;
            }
            Iterable $this$firstOrNull$iv = this.getNestedBlocks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                if (!(it2 instanceof SqlQueryBlock)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        SqlBlock sqlBlock = v0;
        if (sqlBlock == null) {
            return;
        }
        SqlBlock q2 = sqlBlock;
        if (q2.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
            q2.setShape(this.getShape());
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        block16: {
            SqlBlock sqlBlock;
            Indent indent;
            SqlCodeStyleSettings s2 = this.getContext().getSql();
            Wrap w = SqlFlowBlock.makeWrap$default(this, this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
            switch (s2.SUBQUERY_CONTENT) {
                case 3: {
                    Indent indent2 = Indent.getSpaceIndent((int)0, (boolean)true);
                    indent = indent2;
                    Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getSpaceIndent(...)");
                    break;
                }
                case 4: {
                    Indent indent3 = Indent.getNormalIndent((boolean)true);
                    indent = indent3;
                    Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"getNormalIndent(...)");
                    break;
                }
                default: {
                    indent = SqlFormattingFunKt.getNORMAL_INDENT();
                }
            }
            this.defaultIndent = indent;
            Alignment a1 = null;
            SqlBlock sqlBlock2 = this.openingBlock;
            if (sqlBlock2 != null) {
                Alignment parentAlignment;
                SqlBlock sqlBlock3;
                SqlBlock it2 = sqlBlock3 = sqlBlock2;
                boolean bl = false;
                it2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                Alignment alignment = parentAlignment = SqlFormattingModelFun.isAlways(this.getParent().getMyWrap()) ? this.getParent().getMyAlign() : null;
                if (parentAlignment == null) {
                    a1 = SqlFormattingModelFun.makeLeftAlignment();
                    it2.setMyAlign(a1);
                } else {
                    a1 = parentAlignment;
                    it2.setMyAlign(null);
                }
            }
            Alignment a2 = null;
            SqlQueryBlock sqlQueryBlock = this.queryBlock;
            if (sqlQueryBlock != null) {
                sqlBlock = sqlQueryBlock;
                SqlQueryBlock it3 = sqlBlock;
                boolean bl = false;
                it3.setMyWrap((Wrap)(s2.SUBQUERY_CONTENT >= 2 ? w : null));
                a2 = s2.SUBQUERY_CONTENT == 3 ? a1 : (s2.SUBQUERY_CLOSING == 6 ? SqlFormattingModelFun.makeLeftAlignment() : null);
                it3.setMyIndent(this.defaultIndent);
                it3.setMyAlign(a2);
            }
            SqlBlock sqlBlock4 = this.closingBlock;
            if (sqlBlock4 == null) break block16;
            SqlBlock it4 = sqlBlock = sqlBlock4;
            boolean bl = false;
            it4.setMyWrap((Wrap)(s2.SUBQUERY_CLOSING >= 2 ? w : null));
            it4.setMyIndent(switch (s2.SUBQUERY_CLOSING) {
                case 3, 4 -> Indent.getSpaceIndent((int)0, (boolean)true);
                case 6 -> this.defaultIndent;
                default -> SqlFormattingFunKt.getNONE_INDENT();
            });
            it4.setMyAlign(switch (s2.SUBQUERY_CLOSING) {
                case 4 -> a1;
                case 6 -> a2;
                default -> null;
            });
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.defaultIndent;
    }

    @Override
    protected boolean userRequiresExpand() {
        return this.getContext().getSql().QUERY_IN_ONE_STRING == 1 || this.getContext().getSql().SUBQUERY_CONTENT >= 2;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        return block2 == this.queryBlock ? this.getContext().makeSpace(s2.SUBQUERY_PAR_SPACE_INSIDE, s2.SUBQUERY_CONTENT > 1) : (block2 == this.closingBlock ? this.getContext().makeSpace(s2.SUBQUERY_PAR_SPACE_INSIDE, s2.SUBQUERY_CLOSING > 1) : super.decideSpacing(block1, block2));
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock b1 = blocks.getBlock1();
        Object object = b1;
        if (object == null || (object = object.getRole()) == null) {
            object = BlockRole.NOTHING;
        }
        Object r1 = object;
        if (r1 == BlockRole.PREFIX && this.queryBlock != null) {
            SqlFormattingContext sqlFormattingContext = this.getContext();
            SqlQueryBlock sqlQueryBlock = this.queryBlock;
            Intrinsics.checkNotNull((Object)sqlQueryBlock);
            string = SqlFormattingContext.currIndentOf$default(sqlFormattingContext, sqlQueryBlock, true, false, false, 12, null);
        } else if (r1 == BlockRole.BODY) {
            SqlBlock sqlBlock = b1;
            if ((sqlBlock == null || (sqlBlock = sqlBlock.getLastNestedSqlBlock()) == null) && (sqlBlock = b1) == null) {
                return null;
            }
            SqlBlock b2 = sqlBlock;
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), b2, true, false, false, 12, null);
        } else {
            string = super.getNewLineIndent(blocks);
        }
        return string;
    }
}

