/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0014J\b\u0010\u0017\u001a\u00020\u000fH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/SqlLoopBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "myBody", "Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock;", "myHead", "Lcom/intellij/sql/formatter/model/SqlBlock;", "myLabel", "myPrefix", "getMyPrefix", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setMyPrefix", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "mySuffix", "prefixIsWrapped", "", "analyseOriginalCodeStyle", "", "configureFormattingAttributes", "configureFormattingAttributesWithHead", "configureFormattingAttributesWithoutHead", "considerBlock", "block", "userRequiresExpand", "Lcom/intellij/sql/formatter/model/SqlHeadLoopBlock;", "Lcom/intellij/sql/formatter/model/SqlRepeatLoopBlock;", "Lcom/intellij/sql/formatter/model/SqlSimpleLoopBlock;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlLoopBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlLoopBlock.kt\ncom/intellij/sql/formatter/model/SqlLoopBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,183:1\n111#2,5:184\n111#2,5:189\n111#2,5:194\n111#2,5:199\n111#2,5:204\n111#2,5:209\n111#2,5:214\n111#2,5:219\n111#2,5:224\n111#2,5:229\n111#2,5:234\n*S KotlinDebug\n*F\n+ 1 SqlLoopBlock.kt\ncom/intellij/sql/formatter/model/SqlLoopBlock\n*L\n58#1:184,5\n59#1:189,5\n66#1:194,5\n67#1:199,5\n68#1:204,5\n72#1:209,5\n73#1:214,5\n79#1:219,5\n80#1:224,5\n81#1:229,5\n82#1:234,5\n*E\n"})
public abstract class SqlLoopBlock
extends SqlNodeBlock {
    @Nullable
    private SqlBlock myLabel;
    @Nullable
    private SqlBlock myHead;
    @Nullable
    private SqlBlock myPrefix;
    @Nullable
    private SqlCodeFlowBlock myBody;
    @Nullable
    private SqlBlock mySuffix;
    private boolean prefixIsWrapped;

    private SqlLoopBlock() {
    }

    @Nullable
    protected final SqlBlock getMyPrefix() {
        return this.myPrefix;
    }

    protected final void setMyPrefix(@Nullable SqlBlock sqlBlock) {
        this.myPrefix = sqlBlock;
    }

    @Override
    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.considerBlock(block);
        switch (WhenMappings.$EnumSwitchMapping$0[block.getRole().ordinal()]) {
            case 1: {
                if (this.myLabel != null) break;
                this.myLabel = block;
                break;
            }
            case 2: {
                if (this.myHead != null) break;
                this.myHead = block;
                break;
            }
            case 3: {
                if (this.myPrefix != null) break;
                this.myPrefix = block;
                break;
            }
            case 4: {
                if (this.myBody != null || !(block instanceof SqlCodeFlowBlock)) break;
                this.myBody = (SqlCodeFlowBlock)block;
                break;
            }
            case 5: {
                this.mySuffix = block;
            }
        }
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        super.analyseOriginalCodeStyle();
        SqlBlock sqlBlock = this.myHead;
        if (sqlBlock == null) {
            return;
        }
        SqlBlock theHead = sqlBlock;
        SqlBlock sqlBlock2 = this.myPrefix;
        if (sqlBlock2 == null) {
            return;
        }
        SqlBlock thePrefix = sqlBlock2;
        this.prefixIsWrapped = this.getContext().textContains(theHead.getRange().getStartOffset(), thePrefix.getRange().getStartOffset(), '\n');
    }

    @Override
    protected void configureFormattingAttributes() {
        if (this.myHead != null) {
            this.configureFormattingAttributesWithHead();
        } else {
            this.configureFormattingAttributesWithoutHead();
        }
    }

    private final void configureFormattingAttributesWithHead() {
        block7: {
            boolean $i$f$setAttributes;
            Alignment align$iv;
            Indent indent$iv;
            Wrap wrap2;
            SqlBlock theSuffix;
            SqlCodeFlowBlock theBody;
            SqlBlock thePrefix;
            block6: {
                Indent prefixIndent;
                boolean $i$f$setAttributes2;
                SqlBlock sqlBlock = this.myHead;
                if (sqlBlock == null) {
                    return;
                }
                SqlBlock theHead = sqlBlock;
                thePrefix = this.myPrefix;
                theBody = this.myBody;
                theSuffix = this.mySuffix;
                boolean toWrap = this.prefixIsWrapped && this.getContext().getKlb() || !this.getContext().getSql().IMP_LOOP_COLLAPSE || this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS;
                wrap2 = this.makeWrap(toWrap ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false);
                SqlBlock sqlBlock2 = this.myLabel;
                if (sqlBlock2 != null) {
                    Indent indent$iv2 = SqlFormattingFunKt.getNONE_INDENT();
                    Alignment align$iv2 = sqlBlock2.getMyAlign();
                    $i$f$setAttributes2 = false;
                    sqlBlock2.setMyWrap(wrap2);
                    sqlBlock2.setMyIndent(indent$iv2);
                    sqlBlock2.setMyAlign(align$iv2);
                }
                indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = theHead.getMyAlign();
                $i$f$setAttributes = false;
                theHead.setMyWrap(wrap2);
                theHead.setMyIndent(indent$iv);
                theHead.setMyAlign(align$iv);
                if (!this.getContext().getSql().IMP_LOOP_LOOP_WRAP && (!this.prefixIsWrapped || !this.getContext().getKlb())) break block6;
                Indent bodyIndent = this.getContext().getSql().IMP_LOOP_LOOP_INDENT ? Indent.getSpaceIndent((int)(this.getContext().getIndentSize() * 2)) : SqlFormattingFunKt.getNORMAL_INDENT();
                Indent indent = prefixIndent = this.getContext().getSql().IMP_LOOP_LOOP_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT();
                if (thePrefix != null) {
                    Alignment align$iv3 = thePrefix.getMyAlign();
                    $i$f$setAttributes2 = false;
                    thePrefix.setMyWrap(wrap2);
                    thePrefix.setMyIndent(prefixIndent);
                    thePrefix.setMyAlign(align$iv3);
                }
                if (theBody != null) {
                    Alignment align$iv4 = ((SqlBlock)theBody).getMyAlign();
                    $i$f$setAttributes2 = false;
                    ((SqlBlock)theBody).setMyWrap(wrap2);
                    ((SqlBlock)theBody).setMyIndent(bodyIndent);
                    ((SqlBlock)theBody).setMyAlign(align$iv4);
                }
                if (theSuffix == null) break block7;
                Indent indent$iv3 = this.getContext().getSql().IMP_LOOP_END_INDENT ? bodyIndent : prefixIndent;
                Alignment align$iv5 = theSuffix.getMyAlign();
                boolean $i$f$setAttributes3 = false;
                theSuffix.setMyWrap(wrap2);
                theSuffix.setMyIndent(indent$iv3);
                theSuffix.setMyAlign(align$iv5);
                break block7;
            }
            SqlBlock sqlBlock = thePrefix;
            if (sqlBlock != null) {
                sqlBlock.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
            }
            if (theBody != null) {
                indent$iv = SqlFormattingFunKt.getNORMAL_INDENT();
                align$iv = ((SqlBlock)theBody).getMyAlign();
                $i$f$setAttributes = false;
                ((SqlBlock)theBody).setMyWrap(wrap2);
                ((SqlBlock)theBody).setMyIndent(indent$iv);
                ((SqlBlock)theBody).setMyAlign(align$iv);
            }
            if (theSuffix == null) break block7;
            indent$iv = this.getContext().getSql().IMP_LOOP_END_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT();
            align$iv = theSuffix.getMyAlign();
            $i$f$setAttributes = false;
            theSuffix.setMyWrap(wrap2);
            theSuffix.setMyIndent(indent$iv);
            theSuffix.setMyAlign(align$iv);
        }
    }

    private final void configureFormattingAttributesWithoutHead() {
        block3: {
            boolean $i$f$setAttributes;
            Alignment align$iv;
            Indent indent$iv;
            Wrap wrap2 = this.makeWrap(this.getContext().getSql().IMP_LOOP_COLLAPSE ? WrapType.CHOP_DOWN_IF_LONG : WrapType.ALWAYS, false);
            SqlBlock sqlBlock = this.myLabel;
            if (sqlBlock != null) {
                indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = sqlBlock.getMyAlign();
                $i$f$setAttributes = false;
                sqlBlock.setMyWrap(wrap2);
                sqlBlock.setMyIndent(indent$iv);
                sqlBlock.setMyAlign(align$iv);
            }
            sqlBlock = this.myPrefix;
            if (sqlBlock != null) {
                indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = sqlBlock.getMyAlign();
                $i$f$setAttributes = false;
                sqlBlock.setMyWrap(wrap2);
                sqlBlock.setMyIndent(indent$iv);
                sqlBlock.setMyAlign(align$iv);
            }
            sqlBlock = this.myBody;
            if (sqlBlock != null) {
                indent$iv = SqlFormattingFunKt.getNORMAL_INDENT();
                align$iv = sqlBlock.getMyAlign();
                $i$f$setAttributes = false;
                sqlBlock.setMyWrap(wrap2);
                sqlBlock.setMyIndent(indent$iv);
                sqlBlock.setMyAlign(align$iv);
            }
            sqlBlock = this.mySuffix;
            if (sqlBlock == null) break block3;
            indent$iv = this.getContext().getSql().IMP_LOOP_END_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT();
            align$iv = sqlBlock.getMyAlign();
            $i$f$setAttributes = false;
            sqlBlock.setMyWrap(wrap2);
            sqlBlock.setMyIndent(indent$iv);
            sqlBlock.setMyAlign(align$iv);
        }
    }

    @Override
    protected boolean userRequiresExpand() {
        return !this.getContext().getSql().IMP_LOOP_COLLAPSE;
    }

    public /* synthetic */ SqlLoopBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockRole.values().length];
            try {
                nArray[BlockRole.ALIAS1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.HEAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.PREFIX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.BODY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.SUFFIX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

