/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentGroupPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBatchBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementGroupBlock;
import com.intellij.sql.formatter.model.SqlFileBlockKt;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlBatchBlock;", "Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock;", "()V", "isTsql", "", "adjustProducedNestedBlocks", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacingRegular", "decideSpacingTSQL", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/AdjacentGroupPattern;", "Companion", "intellij.database.sql.core.impl"})
public final class SqlBatchBlock
extends SqlCodeFlowBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isTsql;
    @NotNull
    private static final List<AdjacentGroupPattern> patterns;

    @Override
    protected void adjustProducedNestedBlocks() {
        super.adjustProducedNestedBlocks();
        this.isTsql = this.getContext().getDialect().getDbms().isTransactSql();
    }

    @NotNull
    protected List<AdjacentGroupPattern> flowPatterns() {
        return patterns;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return this.isTsql ? this.decideSpacingTSQL(block1, block2) : this.decideSpacingRegular(block1, block2);
    }

    private final Spacing decideSpacingRegular(SqlBlock block1, SqlBlock block2) {
        return block1 instanceof SqlDeclareStatementGroupBlock ? (SqlFormattingModelFun.primaryElementType(block2) == SqlCommonTokens.SQL_SEMICOLON ? this.getContext().makeSafeSpaceOrBreak() : SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null)) : (block2 instanceof SqlDeclareStatementGroupBlock ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2));
    }

    private final Spacing decideSpacingTSQL(SqlBlock block1, SqlBlock block2) {
        boolean sc1 = SqlFormattingModelFun.primaryElementType(block1) == SqlCommonTokens.SQL_SEMICOLON;
        boolean sc2 = SqlFormattingModelFun.primaryElementType(block2) == SqlCommonTokens.SQL_SEMICOLON;
        return sc1 && sc2 ? this.getContext().makeNoSpace(true) : (sc2 ? SqlFileBlockKt.makeSpacingBeforeStatementDelimiter(this.getContext(), block2) : (sc1 ? SqlFileBlockKt.makeSpacingBetweenStatements(this.getContext()) : (block1 instanceof SqlDeclareStatementGroupBlock ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : (block2 instanceof SqlDeclareStatementGroupBlock ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2)))));
    }

    static {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_DECLARE_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_DECLARE_STATEMENT");
        patterns = CollectionsKt.listOf((Object)new AdjacentGroupPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), true, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlBatchBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/AdjacentGroupPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<AdjacentGroupPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

