/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.util.TextWithRanges;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.model.SqlFormattingModelMaker;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        return SqlFormattingModelBuilder.makeModel(formattingContext.getPsiElement(), formattingContext.getFormattingMode(), null, formattingContext.getFormattingRange(), formattingContext.getCodeStyleSettings());
    }

    @NotNull
    public static FormattingModel createDocumentFormattingModel(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull TextWithRanges textWithRanges, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if (dialect == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (textWithRanges == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)textWithRanges.toString(), true);
        int offset = 0;
        for (TextWithRanges.Chunk chunk : textWithRanges.getChunks()) {
            int length = chunk.getText().length();
            if (chunk.readonly()) {
                document.createGuardedBlock(offset, offset + length);
            }
            offset += length;
        }
        String text2 = textWithRanges.toString();
        return SqlFormattingModelBuilder.createModel(project, dialect, text2, (Document)document, settings);
    }

    @NotNull
    public static FormattingModel createModel(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull CharSequence text2, @NotNull Document document, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (document == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(dialect, text2);
        file.putUserData(FileDocumentManagerBase.HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        return SqlFormattingModelBuilder.makeModel((PsiElement)file, FormattingMode.REFORMAT, document, null, settings);
    }

    @NotNull
    static FormattingModel makeModel(@NotNull PsiElement element2, @NotNull FormattingMode mode, @Nullable Document document, @Nullable TextRange interestingRange, @Nullable CodeStyleSettings settings) {
        if (element2 == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        PsiFile file = element2.getContainingFile();
        CodeStyleSettings settings1 = settings != null ? settings : CodeStyle.getSettings((PsiFile)file);
        CharSequence text2 = document != null ? document.getCharsSequence() : file.getText();
        Class<? extends SqlCodeStyleSettings> settingsClass = SqlFormattingModelBuilder.getSettingsClassConsideringInheritance(file.getLanguage(), settings1);
        TextRange ir = interestingRange != null ? interestingRange : element2.getTextRange();
        SqlFormattingModelMaker modelMaker = new SqlFormattingModelMaker(text2, file, settings1, settingsClass, mode, ir);
        SqlRootBlock rootBlock = modelMaker.makeModel((ASTNode)file.getNode());
        if (document != null) {
            return new DocumentBasedFormattingModel((Block)rootBlock, document, file.getProject(), settings1, file.getFileType(), file);
        }
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)rootBlock, (CodeStyleSettings)settings1);
        if (formattingModel == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        return formattingModel;
    }

    @NotNull
    private static Class<? extends SqlCodeStyleSettings> getSettingsClassConsideringInheritance(@NotNull Language language, @NotNull CodeStyleSettings settings) {
        Class sc2;
        if (language == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(12);
        }
        if ((sc2 = SqlCodeStyles.getSettingsClass((Language)language)) == SqlCodeStyleSettings.class) {
            Class clazz = sc2;
            if (clazz == null) {
                SqlFormattingModelBuilder.$$$reportNull$$$0(13);
            }
            return clazz;
        }
        SqlCodeStyleSettings s2 = (SqlCodeStyleSettings)settings.getCustomSettings(sc2);
        if (s2.USE_GENERAL_STYLE) {
            return SqlCodeStyleSettings.class;
        }
        Class clazz = sc2;
        if (clazz == null) {
            SqlFormattingModelBuilder.$$$reportNull$$$0(14);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithRanges";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlFormattingModelBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlFormattingModelBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClassConsideringInheritance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFormattingModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeModel";
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsClassConsideringInheritance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 14 -> new IllegalStateException(string);
        };
    }
}

