/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\f0\u0011\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getLineMarkerInfo", "element", "getName", "", "Lorg/jetbrains/annotations/Nls;", "isRecursiveCall", "", "refExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "SqlRecursiveCallMarkerInfo", "intellij.database.sql.impl"})
public final class SqlRecursiveCallLineMakerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = SqlBundle.message((String)"SqlRecursiveCallLineMakerProvider.gutter.name.recursive.call", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RecursiveMethod");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    private final boolean isRecursiveCall(SqlReferenceExpression refExpr) {
        ResolveResult[] resolveResultArray = refExpr.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        for (ResolveResult result2 : resolveResultArray) {
            PsiElement target2;
            block10: {
                block9: {
                    if (result2.getElement() == null) continue;
                    if (!(target2 instanceof SqlRoutineDefinition)) break block9;
                    PsiElement psiElement = refExpr.getParent();
                    SqlFunctionCallExpression sqlFunctionCallExpression = psiElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)psiElement : null;
                    if (Intrinsics.areEqual((Object)(sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getNameElement() : null), (Object)refExpr)) break block10;
                }
                if (!(target2 instanceof SqlAsExpression)) continue;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)refExpr), (boolean)true)) {
                return true;
            }
            PsiFile psiFile = refExpr.getContainingFile();
            SqlCodeFragment sqlCodeFragment = psiFile instanceof SqlCodeFragment ? (SqlCodeFragment)psiFile : null;
            if (sqlCodeFragment == null) {
                return false;
            }
            SqlCodeFragment file = sqlCodeFragment;
            if (!SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDbms().isSnowflake()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)file.getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION)) {
                return false;
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
            if (psiLanguageInjectionHost == null) {
                return false;
            }
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            return PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)injectionHost), (boolean)true);
        }
        return false;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        for (PsiElement psiElement : elements2) {
            SqlReferenceExpression refExpr;
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = psiElement.getParent();
            SqlIdentifier sqlIdentifier = psiElement2 instanceof SqlIdentifier ? (SqlIdentifier)psiElement2 : null;
            PsiElement psiElement22 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
            SqlReferenceExpression sqlReferenceExpression = psiElement22 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement22 : null;
            if (sqlReferenceExpression == null || !this.isRecursiveCall(refExpr = sqlReferenceExpression)) continue;
            result2.add(new SqlRecursiveCallMarkerInfo(psiElement));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider$SqlRecursiveCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "name", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.database.sql.impl"})
    private static final class SqlRecursiveCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public SqlRecursiveCallMarkerInfo(@NotNull PsiElement name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2, name2.getTextRange(), AllIcons.Gutter.RecursiveMethod, arg_0 -> SqlRecursiveCallMarkerInfo._init_$lambda$0(1.INSTANCE, arg_0), null, GutterIconRenderer.Alignment.RIGHT);
        }

        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){

                @Nullable
                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }
    }
}

