/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.BraceMatcherBasedSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class SqlBraceMatcherBasedSelectioner
extends BraceMatcherBasedSelectioner {
    public boolean canSelect(@NotNull PsiElement e2) {
        if (e2 == null) {
            SqlBraceMatcherBasedSelectioner.$$$reportNull$$$0(0);
        }
        return e2 instanceof SqlElement;
    }

    public List<TextRange> select(@NotNull PsiElement e2, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        if (e2 == null) {
            SqlBraceMatcherBasedSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            SqlBraceMatcherBasedSelectioner.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            SqlBraceMatcherBasedSelectioner.$$$reportNull$$$0(3);
        }
        List result2 = Objects.requireNonNull(super.select(e2, editorText, cursorOffset, editor2));
        if (e2 instanceof SqlStatement || e2 instanceof SqlBatchBlock) {
            ASTNode eNode;
            result2.addAll(SqlBraceMatcherBasedSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)e2.getTextRange()));
            SqlLanguageDialect dialect = SqlLanguageSubstitutor.getSqlLanguageDialect(e2.getContainingFile().getVirtualFile(), e2.getProject());
            TokenSet closingTokens = dialect.getStatementSeparators();
            for (ASTNode node2 = eNode = e2.getNode(); node2 != null; node2 = node2.getTreeNext()) {
                if (!closingTokens.contains(node2.getElementType())) continue;
                TextRange range = new TextRange(eNode.getStartOffset(), node2.getStartOffset() + node2.getTextLength());
                result2.add(range);
                result2.addAll(SqlBraceMatcherBasedSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)range));
                break;
            }
        } else if (e2 instanceof SqlStringTokenElement) {
            TextRange range;
            SqlStringTokenElement element2 = (SqlStringTokenElement)e2;
            result2.add(element2.getRangeInElement().shiftRight(element2.getStartOffset()));
            SqlStringLiteralExpressionImpl literal = (SqlStringLiteralExpressionImpl)((Object)ObjectUtils.tryCast((Object)e2.getParent(), SqlStringLiteralExpressionImpl.class));
            if (literal != null && !(range = SqlStringLiteralManipulator.getStringContentRange((PsiElement)literal).shiftRight(literal.getStartOffset())).equals(result2.get(result2.size() - 1))) {
                result2.add(range);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlBraceMatcherBasedSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

