/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlBaseValidationDelegate;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDeclareConditionHandlerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016R\u0015\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/sql/editor/SqlBaseValidationDelegate;", "Lcom/intellij/sql/editor/SqlValidatingHighlightVisitor$Delegate;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "minDbmsVersion", "Lcom/intellij/database/util/Version;", "Lorg/jetbrains/annotations/Nullable;", "checkBadErrorCode", "", "errorCodeExpr", "Lcom/intellij/sql/psi/SqlExpression;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkBadSqlState", "sqlStateExpr", "checkErrorCodeExpr", "checkSignalStatement", "o", "Lcom/intellij/sql/psi/impl/SqlSignalStatement;", "getOptionKeywords", "Lcom/intellij/util/containers/JBIterable;", "statement", "Lcom/intellij/sql/psi/SqlRaiseStatement;", "isGoodSqlState", "", "expression", "visitSqlCreateTableStatement", "Lcom/intellij/sql/psi/SqlCreateTableStatement;", "visitSqlCreateViewStatement", "Lcom/intellij/sql/psi/SqlCreateViewStatement;", "visitSqlDeclareConditionHandlerStatement", "Lcom/intellij/sql/psi/SqlDeclareConditionHandlerStatement;", "visitSqlDefinition", "Lcom/intellij/sql/psi/SqlDefinition;", "visitSqlIdentifier", "Lcom/intellij/sql/psi/SqlIdentifier;", "visitSqlRaiseStatement", "SeparateSelectFromCreateFix", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlBaseValidationDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlBaseValidationDelegate.kt\ncom/intellij/sql/editor/SqlBaseValidationDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1#2:224\n1855#3,2:225\n288#3,2:227\n1747#3,3:229\n*S KotlinDebug\n*F\n+ 1 SqlBaseValidationDelegate.kt\ncom/intellij/sql/editor/SqlBaseValidationDelegate\n*L\n129#1:225,2\n144#1:227,2\n163#1:229,3\n*E\n"})
public class SqlBaseValidationDelegate
extends SqlValidatingHighlightVisitor.Delegate {
    @Nullable
    private final Version minDbmsVersion;

    public SqlBaseValidationDelegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(dialect, holder);
        List<DbDataSource> list = SqlImplUtil.getDataSources((PsiElement)holder.getContextFile());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        this.minDbmsVersion = (Version)SequencesKt.minOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)minDbmsVersion.1.INSTANCE));
    }

    private final boolean isGoodSqlState(SqlExpression expression) {
        if (!(expression instanceof SqlStringLiteralExpression)) {
            return false;
        }
        String string = ((SqlStringLiteralExpression)expression).getValue();
        if (string == null) {
            return false;
        }
        String value2 = string;
        return value2.length() == 5 && !StringsKt.startsWith$default((String)value2, (String)"00", (boolean)false, (int)2, null);
    }

    private final void checkBadSqlState(SqlExpression sqlStateExpr, PsiElement reportOn) {
        if (!this.isGoodSqlState(sqlStateExpr)) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            String string = SqlBundle.message((String)"inspection.message.sqlstate.value.must.be.character.string.literal.may.not.start.with", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, reportOn, string, null, 4, null);
        }
    }

    static /* synthetic */ void checkBadSqlState$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBadSqlState");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkBadSqlState(sqlExpression, psiElement);
    }

    private final void checkBadErrorCode(SqlExpression errorCodeExpr, PsiElement reportOn) {
        String string = errorCodeExpr.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n != null && n == 0) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            String string2 = SqlBundle.message((String)"inspection.message.error.code.may.not.be.zero", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, reportOn, string2, null, 4, null);
        }
    }

    static /* synthetic */ void checkBadErrorCode$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBadErrorCode");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkBadErrorCode(sqlExpression, psiElement);
    }

    private final void checkErrorCodeExpr(SqlExpression errorCodeExpr, PsiElement reportOn) {
        SqlExpression sqlExpression = errorCodeExpr;
        if (sqlExpression instanceof SqlStringLiteralExpression) {
            this.checkBadSqlState(errorCodeExpr, reportOn);
        } else if (sqlExpression instanceof SqlLiteralExpression) {
            this.checkBadErrorCode(errorCodeExpr, reportOn);
        }
    }

    static /* synthetic */ void checkErrorCodeExpr$default(SqlBaseValidationDelegate sqlBaseValidationDelegate, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkErrorCodeExpr");
        }
        if ((n & 2) != 0) {
            psiElement = (PsiElement)sqlExpression;
        }
        sqlBaseValidationDelegate.checkErrorCodeExpr(sqlExpression, psiElement);
    }

    private final JBIterable<PsiElement> getOptionKeywords(SqlRaiseStatement statement2) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)statement2.getOptionsClause()).filter(SqlSetAssignment.class).map(arg_0 -> SqlBaseValidationDelegate.getOptionKeywords$lambda$0(getOptionKeywords.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    private final void checkSignalStatement(SqlSignalStatement o2) {
        SqlDeclareConditionHandlerStatement parentHandler;
        Class[] classArray;
        SqlErrorSpec errorSpec = o2.getErrorSpec();
        if (errorSpec instanceof SqlErrorCodeSpec) {
            SqlExpression sqlExpression = ((SqlErrorCodeSpec)errorSpec).getErrorCode();
            if (sqlExpression != null) {
                SqlExpression it2 = sqlExpression;
                boolean bl = false;
                SqlBaseValidationDelegate.checkBadSqlState$default(this, it2, null, 2, null);
            }
        } else if (errorSpec instanceof SqlConditionErrorSpec) {
            SqlExpression errorCodeExpr;
            PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
            SqlConditionDefinition condition2 = psiElement instanceof SqlConditionDefinition ? (SqlConditionDefinition)psiElement : null;
            SqlCompositeElementImpl sqlCompositeElementImpl = condition2;
            SqlExpression sqlExpression = sqlCompositeElementImpl != null && (sqlCompositeElementImpl = ((SqlConditionDefinition)sqlCompositeElementImpl).getErrorSpec()) != null ? ((SqlErrorCodeSpec)sqlCompositeElementImpl).getErrorCode() : (errorCodeExpr = null);
            if (errorCodeExpr != null && !(errorCodeExpr instanceof SqlStringLiteralExpression)) {
                SqlValidatingHighlightVisitor.Delegate delegate = this;
                PsiElement psiElement2 = (PsiElement)errorSpec;
                String string = SqlBundle.message((String)"inspection.message.condition.used.in.signal.statement.must.be.associated.with.sqlstate.value", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement2, string, null, 4, null);
            }
        }
        if (this.getDialect().getDbms().isMysql()) {
            HashSet<String> visitedNames = new HashSet<String>();
            classArray = this.getOptionKeywords(o2).iterator();
            while (classArray.hasNext()) {
                String optionName;
                PsiElement optionKeyword;
                PsiElement psiElement = optionKeyword = (PsiElement)classArray.next();
                String string = psiElement != null ? psiElement.getText() : null;
                if (string == null || visitedNames.add(optionName = string)) continue;
                SqlValidatingHighlightVisitor.Delegate delegate = this;
                Object[] objectArray = new Object[]{optionName};
                String string2 = SqlBundle.message((String)"inspection.message.duplicate.condition.information.item", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, optionKeyword, string2, null, 4, null);
            }
        }
        if (o2.isReraise() && (parentHandler = (SqlDeclareConditionHandlerStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o2), SqlDeclareConditionHandlerStatement.class, (boolean)true, (Class[])(classArray = new Class[]{SqlDefinition.class}))) == null) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement = (PsiElement)o2;
            String string = SqlBundle.message((String)"inspection.message.resignal.may.not.be.used.outside.condition.handler.context", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
        }
    }

    public void visitSqlDefinition(@NotNull SqlDefinition o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        if (o2 instanceof SqlConditionDefinition) {
            SqlErrorCodeSpec sqlErrorCodeSpec = ((SqlConditionDefinition)o2).getErrorSpec();
            if (sqlErrorCodeSpec == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) {
                return;
            }
            SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
            SqlBaseValidationDelegate.checkErrorCodeExpr$default(this, (SqlExpression)errorCodeExpr, null, 2, null);
        } else {
            super.visitSqlDefinition(o2);
        }
    }

    public void visitSqlDeclareConditionHandlerStatement(@NotNull SqlDeclareConditionHandlerStatement o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        for (SqlErrorSpec errorSpec : o2.getErrorSpecs()) {
            SqlErrorCodeSpec sqlErrorCodeSpec;
            SqlErrorCodeSpec errorCodeSpec = null;
            PsiElement reportOn = null;
            SqlErrorSpec sqlErrorSpec = errorSpec;
            if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
                Intrinsics.checkNotNull((Object)errorSpec);
                errorCodeSpec = (SqlErrorCodeSpec)errorSpec;
            } else if (sqlErrorSpec instanceof SqlConditionErrorSpec) {
                PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
                SqlConditionDefinition sqlConditionDefinition = psiElement instanceof SqlConditionDefinition ? (SqlConditionDefinition)psiElement : null;
                errorCodeSpec = sqlConditionDefinition != null ? sqlConditionDefinition.getErrorSpec() : null;
                reportOn = (PsiElement)errorSpec;
            }
            if ((sqlErrorCodeSpec = errorCodeSpec) == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) continue;
            SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
            PsiElement psiElement = reportOn;
            if (psiElement == null) {
                psiElement = (PsiElement)errorCodeExpr;
            }
            this.checkErrorCodeExpr((SqlExpression)errorCodeExpr, psiElement);
        }
        Dbms dbms = this.getDialect().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if ((dbms2.isMysql() || dbms2.isDb2()) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)o2.getKindKeyword()), (Object)SqlCommonKeywords.SQL_UNDO)) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement = o2.getKindKeyword();
            Intrinsics.checkNotNull((Object)psiElement);
            String string = SqlBundle.message((String)"inspection.message.undo.handlers.are.not.supported", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
        }
        JBIterable jBIterable = o2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlStatement it2 = (SqlStatement)element$iv;
            boolean bl = false;
            it2.accept((SqlVisitor)this);
        }
    }

    public void visitSqlRaiseStatement(@NotNull SqlRaiseStatement o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        if (o2 instanceof SqlSignalStatement) {
            this.checkSignalStatement((SqlSignalStatement)o2);
        } else {
            Dbms dbms = this.getDialect().getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if ((dbms2.isOracle() || dbms2.isPostgres()) && o2.getFirstChild().getNextSibling() == null && SqlImplUtil.sqlParents((PsiElement)o2).filter(SqlExceptionWhenClause.class).isEmpty()) {
                SqlValidatingHighlightVisitor.Delegate delegate = this;
                PsiElement psiElement = (PsiElement)o2;
                String string = SqlBundle.message((String)"inspection.message.raise.without.arguments.may.not.be.used.outside.exception.handler", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
            }
            if (dbms2.isPostgres() && o2.getErrorSpec() != null) {
                Object v4;
                block6: {
                    Iterable $this$firstOrNull$iv = (Iterable)this.getOptionKeywords(o2);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it2 = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_ERRCODE)) continue;
                        v4 = element$iv;
                        break block6;
                    }
                    v4 = null;
                }
                PsiElement errorCodeOption = v4;
                if (errorCodeOption != null) {
                    SqlValidatingHighlightVisitor.Delegate delegate = this;
                    PsiElement psiElement = errorCodeOption.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                    String string = SqlBundle.message((String)"inspection.message.raise.error.code.already.specified", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
                }
            }
        }
    }

    public void visitSqlIdentifier(@NotNull SqlIdentifier o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        int maxLength = this.getDialect().getMaxIdentifierLength(o2, this.minDbmsVersion);
        if (o2.getName().length() > maxLength) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement = (PsiElement)o2;
            Object[] objectArray = new Object[]{maxLength};
            String string = SqlBundle.message((String)"inspection.message.identifier.too.long.should.not.exceed.characters", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void visitSqlCreateTableStatement(@NotNull SqlCreateTableStatement o) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlCreateTableStatement(o);
                if (!SqlImplUtil.isRecursive((SqlTableDefinition)o)) break block6;
                query = o.getQueryExpression();
                if (query == null) ** GOTO lbl-1000
                v0 = SqlImplUtil.revSiblings((PsiElement)query);
                Intrinsics.checkNotNullExpressionValue(v0, (String)"revSiblings(...)");
                $this$any$iv = (Iterable)v0;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-any-SqlBaseValidationDelegate$visitSqlCreateTableStatement$fix$1 = false;
                        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlCommonKeywords.SQL_AS)) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = false;
                }
            }
            if (!v1) {
                v2 = new SeparateSelectFromCreateFix(query);
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            fix = v2;
            v3 = (SqlReferenceExpression)o.getNameElement();
            var4_3 = v3 != null ? (PsiElement)v3 : o.getFirstChild();
            Intrinsics.checkNotNull((Object)var4_3);
            var5_5 = new Object[]{o.getKind().getPresentableName()};
            v4 = SqlBundle.message((String)"inspection.message.recursive.table", (Object[])var5_5);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
            this.reportWarning(var4_3, v4, fix);
        }
    }

    public void visitSqlCreateViewStatement(@NotNull SqlCreateViewStatement o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        super.visitSqlCreateViewStatement(o2);
        if (SqlImplUtil.isRecursive((SqlTableDefinition)o2)) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)o2.getNameElement();
            PsiElement psiElement = sqlReferenceExpression != null ? (PsiElement)sqlReferenceExpression : o2.getFirstChild();
            Intrinsics.checkNotNull((Object)psiElement);
            Object[] objectArray = new Object[]{o2.getKind().getPresentableName()};
            String string = SqlBundle.message((String)"inspection.message.recursive.table", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportWarning$default(delegate, psiElement, string, null, 4, null);
        }
    }

    private static final PsiElement getOptionKeywords$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiElement)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\u000eH\u0016J\u0012\u0010\u000f\u001a\f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\u000eH\u0016J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u001b\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/editor/SqlBaseValidationDelegate$SeparateSelectFromCreateFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "queryExpression", "Lcom/intellij/sql/psi/SqlExpression;", "(Lcom/intellij/sql/psi/SqlExpression;)V", "Lorg/jetbrains/annotations/Nullable;", "getQueryExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "queryPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.database.sql.core.impl"})
    private static final class SeparateSelectFromCreateFix
    implements IntentionAction {
        @NotNull
        private final SmartPsiElementPointer<SqlExpression> queryPointer;

        public SeparateSelectFromCreateFix(@NotNull SqlExpression queryExpression) {
            Intrinsics.checkNotNullParameter((Object)queryExpression, (String)"queryExpression");
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)queryExpression));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            this.queryPointer = smartPsiElementPointer;
        }

        private final SqlExpression getQueryExpression() {
            return (SqlExpression)this.queryPointer.getElement();
        }

        public boolean startInWriteAction() {
            return true;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.separate.query.from.table", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return editor2 != null && this.getQueryExpression() != null;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
            char ch;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (editor2 == null) {
                return;
            }
            SqlExpression sqlExpression = this.getQueryExpression();
            if (sqlExpression == null) {
                return;
            }
            SqlExpression query = sqlExpression;
            String string = DbSqlUtilCore.getDelimiterAt(file, query.getTextRange().getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDelimiterAt(...)");
            String delimiter = string;
            PsiElement asClause = query.getParent();
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)asClause);
            if (psiElement == null) {
                return;
            }
            PsiElement anchor2 = psiElement;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int from = anchor2.getTextRange().getEndOffset();
            int to = asClause.getTextRange().getStartOffset();
            CharSequence toReplace = document2.getCharsSequence().subSequence(from, to);
            String replacement = delimiter + toReplace;
            boolean hasTrailingNewLine = false;
            for (int i2 = StringsKt.getLastIndex((CharSequence)toReplace); -1 < i2 && CharsKt.isWhitespace((char)(ch = toReplace.charAt(i2))); --i2) {
                if (ch != '\n') continue;
                hasTrailingNewLine = true;
                break;
            }
            if (!hasTrailingNewLine) {
                replacement = replacement + "\n";
            }
            document2.replaceString(from, to, (CharSequence)replacement);
        }
    }
}

