/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.dialects.postgres.psi.PgOuterCodeBlockElementType;
import com.intellij.sql.dialects.postgres.psi.PgPsiUtil;
import com.intellij.sql.dialects.postgres.psi.PgRoutineDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgCreateFunctionStatementImpl
extends SqlCreateFunctionStatementImpl
implements PgRoutineDefinition {
    public PgCreateFunctionStatementImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(0);
        }
        super(node2);
    }

    public PgCreateFunctionStatementImpl(SqlNamedElementStub<?> stub) {
        super(stub);
    }

    @NotNull
    public JBIterable<SqlStatement> getBody() {
        JBIterable jBIterable = JBIterable.of((Object)PgPsiUtil.getPgBody(this));
        if (jBIterable == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression ref2;
        if (!SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.TABLE, ObjectKind.COLUMN)) {
            return true;
        }
        boolean inBody = lastParent.getParent() == this && PsiUtilCore.getElementType((PsiElement)lastParent) instanceof PgOuterCodeBlockElementType;
        SqlReturnsClause returnArgument2 = this.getReturnArgument();
        if (inBody && returnArgument2 != null && SqlImplUtil.getSqlDialectSafe((PsiElement)this).getTypeSystem().isTriggerFunctionType(returnArgument2.getDasType()) && !this.processTriggerDeclarations(processor2, state, place)) {
            return false;
        }
        if (inBody && (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class)) != null && !SqlImplUtil.processQualifier(ref2, processor2, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    private boolean processTriggerDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement place) {
        SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler handler2 = this.getFakeHandler();
        if (handler2 != null && (handler2.getProvider() instanceof PgCreateTriggerStatementImpl ? !((PgCreateTriggerStatementImpl)handler2.getProvider()).processDeclarations(processor2, state, handler2.getProvider().getLastChild(), place) : !handler2.processSimple(processor2, state))) {
            return false;
        }
        SqlScopeProcessorBase sqlProcessor = (SqlScopeProcessorBase)ObjectUtils.tryCast((Object)processor2, SqlScopeProcessorBase.class);
        if (sqlProcessor != null) {
            PgDialectBase dialect = (PgDialectBase)sqlProcessor.getDialect();
            if (handler2 == null) {
                if (!sqlProcessor.executeTarget(dialect.getNewTableAlias(), (DasType)SqlTableTypeBase.EMPTY_TABLE, null, state)) {
                    return false;
                }
                if (!sqlProcessor.executeTarget(dialect.getOldTableAlias(), (DasType)SqlTableTypeBase.EMPTY_TABLE, null, state)) {
                    return false;
                }
            }
            DasTypeSystemBase typeSystem = dialect.getTypeSystem();
            for (ReservedEntity entity : dialect.getTriggerStringImplicits().values()) {
                if (sqlProcessor.executeTarget(entity, typeSystem.getStringType(), null, state)) continue;
                return false;
            }
            if (!sqlProcessor.executeTarget(dialect.getTriggerNArgsColumn(), typeSystem.getIntType(), null, state) || !sqlProcessor.executeTarget(dialect.getTriggerArgVColumn(), typeSystem.getAnyArrayType(), null, state)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler getFakeHandler() {
        return (SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findOrCreateHandler(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler findOrCreateHandler() {
        DbTable table;
        PgCreateTriggerStatementImpl sqlTrigger = this.findSqlTrigger();
        if (sqlTrigger != null) {
            return sqlTrigger.getHandler();
        }
        DbTrigger trigger2 = this.findDbTrigger();
        DbTable dbTable = table = trigger2 == null ? null : trigger2.getTable();
        if (table == null) {
            return null;
        }
        return PgCreateTriggerStatementImpl.createHandler((PsiElement)this, table);
    }

    @Nullable
    private DbTrigger findDbTrigger() {
        SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class);
        if (ref2 == null) {
            return null;
        }
        SqlReferenceExpression unboundedRef = SqlPsiElementFactory.createReferenceFromText(ref2.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)ref2), ref2.getReferenceElementType(), (PsiElement)this);
        if (unboundedRef == null) {
            return null;
        }
        for (ResolveResult result2 : unboundedRef.multiResolve(false)) {
            DbDataSource dataSource2;
            DasTrigger trigger2;
            DasObject routine2;
            PsiElement resolved = result2.getElement();
            if (!(resolved instanceof DbRoutine) || (routine2 = DbUtil.getDasObject(resolved)) == null || (trigger2 = (DasTrigger)(dataSource2 = ((DbRoutine)resolved).getDataSource()).getDelegate().getModel().traverser().filter(DasTrigger.class).filter(o2 -> DbSqlUtilCore.referencesTarget(o2, routine2, ObjectKind.ROUTINE)).first()) == null) continue;
            return (DbTrigger)dataSource2.findElement(trigger2);
        }
        return null;
    }

    @Nullable
    private PgCreateTriggerStatementImpl findSqlTrigger() {
        PgCreateTriggerStatementImpl statement2 = null;
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFile.class);
        if (file != null) {
            SqlCreateFunctionStatementImpl target2 = (SqlCreateFunctionStatementImpl)CompletionUtil.getOriginalOrSelf((PsiElement)this);
            statement2 = (PgCreateTriggerStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)target2, PgCreateTriggerStatementImpl.class);
            if (statement2 != null) {
                return statement2;
            }
            for (SqlElement element2 : file.getDdl()) {
                SqlFunctionCallExpression call2;
                SqlReferenceExpression ref2;
                PgCreateTriggerStatementImpl trigger2 = (PgCreateTriggerStatementImpl)((Object)ObjectUtils.tryCast((Object)element2, PgCreateTriggerStatementImpl.class));
                if (trigger2 == null || (ref2 = (call2 = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)trigger2.getTriggerProcedure(), SqlFunctionCallExpression.class)) == null ? null : call2.getNameElement()) == null || !ref2.getReference().isReferenceTo((PsiElement)target2)) continue;
                statement2 = trigger2;
                break;
            }
        }
        return statement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

