/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OraBinaryExpressionImpl
extends SqlBinaryExpressionImpl {
    private static final Map<DasBuiltinType<?>, DasBuiltinType<?>> numberRoots = Map.of(OraTypeSystem.NATURAL, OraTypeSystem.BINARY_INTEGER, OraTypeSystem.POSITIVE, OraTypeSystem.BINARY_INTEGER, OraTypeSystem.SIGNTYPE, OraTypeSystem.BINARY_INTEGER, OraTypeSystem.NATURALN, OraTypeSystem.SIMPLE_INTEGER, OraTypeSystem.POSITIVEN, OraTypeSystem.SIMPLE_INTEGER);

    private static boolean isBinaryInt(@NotNull DasBuiltinType<?> type2) {
        if (type2 == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        return type2 == OraTypeSystem.BINARY_INTEGER || type2 == OraTypeSystem.SIMPLE_INTEGER;
    }

    public OraBinaryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        super(elementType);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this, () -> {
            IElementType sign = this.getOpSign();
            if (sign == SqlCommonKeywords.SQL_AND || sign == SqlCommonKeywords.SQL_OR) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == SqlCommonKeywords.SQL_IS) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == SqlCommonKeywords.SQL_IN) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OP_EQ || sign == OraTypes.ORA_OP_GE || sign == OraTypes.ORA_SQL_OP_GE_WS || sign == OraTypes.ORA_OP_GT || sign == OraTypes.ORA_OP_LE || sign == OraTypes.ORA_SQL_OP_LE_WS || sign == OraTypes.ORA_OP_LT || sign == OraTypes.ORA_OP_NEQ || sign == OraTypes.ORA_OP_NEQ2 || sign == OraTypes.ORA_OP_NEQ3 || sign == OraTypes.ORA_OP_NEQ4 || sign == OraTypes.ORA_SQL_OP_NEQ_WS || sign == OraTypes.ORA_SQL_OP_NEQ2_WS || sign == OraTypes.ORA_SQL_OP_NEQ3_WS || sign == OraTypes.ORA_SQL_OP_NEQ4_WS) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == OraTypes.ORA_LIKE || sign == OraTypes.ORA_LIKEC || sign == OraTypes.ORA_LIKE2 || sign == OraTypes.ORA_LIKE4) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == OraTypes.ORA_MEMBER || sign == OraTypes.ORA_SUBMULTISET) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OVERLAPS) {
                return OraTypeSystem.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OP_CONCAT) {
                return OraTypeSystem.VARCHAR2;
            }
            SqlExpression lOperand = this.getLOperand();
            if (sign == SqlCommonTokens.SQL_LEFT_BRACKET) {
                return lOperand.getDasType();
            }
            DasBuiltinType lType = (DasBuiltinType)ObjectUtils.tryCast((Object)lOperand.getDasType(), DasBuiltinType.class);
            if (lType == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            SqlExpression rOperand = this.getROperand();
            if (rOperand == null) {
                return lType;
            }
            DasBuiltinType rType = (DasBuiltinType)ObjectUtils.tryCast((Object)rOperand.getDasType(), DasBuiltinType.class);
            if (rType == null) {
                return DasTypeSystemBase.UNKNOWN;
            }
            if (lType.getTypeClass().getCategory().isNumber() && rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS || sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV || sign == OraTypes.ORA_POWER)) {
                lType = numberRoots.getOrDefault(lType, lType);
                rType = numberRoots.getOrDefault(rType, rType);
                if (lType.equals(OraTypeSystem.BINARY_DOUBLE) || rType.equals(OraTypeSystem.BINARY_DOUBLE)) {
                    return OraTypeSystem.BINARY_DOUBLE;
                }
                if (lType.equals(OraTypeSystem.BINARY_FLOAT) || rType.equals(OraTypeSystem.BINARY_FLOAT)) {
                    return OraTypeSystem.BINARY_FLOAT;
                }
                if (sign == OraTypes.ORA_OP_DIV) {
                    return OraTypeSystem.NUMBER;
                }
                if (lType.equals(OraTypeSystem.SIMPLE_INTEGER) && rType.equals(OraTypeSystem.SIMPLE_INTEGER)) {
                    return OraTypeSystem.SIMPLE_INTEGER;
                }
                if (OraBinaryExpressionImpl.isBinaryInt(lType) && OraBinaryExpressionImpl.isBinaryInt(rType)) {
                    return OraTypeSystem.BINARY_INTEGER;
                }
                return OraTypeSystem.NUMBER;
            }
            if (lType.getTypeClass().getCategory() == DasTypeCategory.DATE) {
                if (rType.getTypeClass().getCategory() == DasTypeCategory.DATE && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeSystem.NUMBER;
                }
                if (!(!rType.getTypeClass().getCategory().isNumber() && rType.getTypeClass().getCategory() != DasTypeCategory.INTERVAL || sign != OraTypes.ORA_OP_PLUS && sign != OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if (rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeSystem.INTERVAL_DAY_TO_SECOND;
                }
            }
            if (lType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP) {
                if (rType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if (rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return OraTypeSystem.DATE;
                }
                if ((rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP || rType.getTypeClass().getCategory() == DasTypeCategory.DATE) && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeSystem.INTERVAL_DAY_TO_SECOND;
                }
            }
            if (lType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL) {
                if (rType.equals(lType) && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if ((rType.getTypeClass().getCategory() == DasTypeCategory.DATE || rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP) && sign == OraTypes.ORA_OP_PLUS) {
                    return rType;
                }
                if (rType.getTypeClass().getCategory().isNumber() && (sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV)) {
                    return lType;
                }
            }
            if (lType.getTypeClass().getCategory().isNumber()) {
                if ((rType.getTypeClass().getCategory() == DasTypeCategory.TIMESTAMP || rType.getTypeClass().getCategory() == DasTypeCategory.DATE) && sign == OraTypes.ORA_OP_PLUS) {
                    return OraTypeSystem.DATE;
                }
                if (rType.getTypeClass().getCategory() == DasTypeCategory.INTERVAL && sign == OraTypes.ORA_OP_MUL) {
                    return rType;
                }
            }
            return DasTypeSystemBase.UNKNOWN;
        });
        if (dasType == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return dasType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryInt";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

