/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.actions.members.SqlMembersHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.inspections.OraUnmatchedForwardDeclarationInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "AddDefinitionFix", "intellij.database.dialects.oracle"})
public final class OraUnmatchedForwardDeclarationInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        NavigationHelper helper = NavigationHelper.EP.forDbms(dialect.getDbms());
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, helper, onTheFly){
            final /* synthetic */ NavigationHelper $helper;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$helper = $helper;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlBlockStatement(@NotNull SqlBlockStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlBlockStatement(o2);
                this.checkBlock((SqlElement)o2);
            }

            public void visitSqlCreateStatement(@NotNull SqlCreateStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateStatement(o2);
                if (Intrinsics.areEqual((Object)o2.getKind(), (Object)ObjectKind.BODY)) {
                    this.checkBlock((SqlElement)o2);
                }
            }

            private final void checkBlock(SqlElement block) {
                for (PsiElement child : SqlImplUtil.sqlChildren((PsiElement)block)) {
                    Pair<String, JBIterable<? extends DasObject>> definitions;
                    if (!(child instanceof SqlRoutineDefinition) || ((SqlRoutineDefinition)child).getBody().isNotEmpty() || (definitions = this.$helper.findDefinitions((DasObject)child, false)) != null && !((JBIterable)definitions.second).isEmpty()) continue;
                    this.reportUnmatchedForward((SqlRoutineDefinition)child);
                }
            }

            private final void reportUnmatchedForward(SqlRoutineDefinition routine2) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{AddDefinitionFix.INSTANCE};
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)routine2, (PsiElement)routine2, SqlBundle.message((String)"inspection.message.unmatched.forward", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, localQuickFixArray));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraUnmatchedForwardDeclarationInspection$AddDefinitionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isLeaf", "", "Lcom/intellij/psi/PsiElement;", "text", "intellij.database.dialects.oracle"})
    public static final class AddDefinitionFix
    implements LocalQuickFix {
        @NotNull
        public static final AddDefinitionFix INSTANCE = new AddDefinitionFix();

        private AddDefinitionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"quickfix.name.add.definition", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private final boolean isLeaf(PsiElement $this$isLeaf, String text2) {
            return $this$isLeaf instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)$this$isLeaf).getText(), (Object)text2);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)descriptor2.getStartElement();
            if (sqlRoutineDefinition == null) {
                return;
            }
            SqlRoutineDefinition header = sqlRoutineDefinition;
            if (header.getBody().isNotEmpty()) {
                return;
            }
            PsiElement psiElement2 = SqlImplUtil.sqlParent((PsiElement)header);
            if (psiElement2 == null) {
                return;
            }
            PsiElement parent2 = psiElement2;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)header);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            SqlMembersHelper sqlMembersHelper = SqlMembersHelper.EP.forDbms(dialect.getDbms());
            if (sqlMembersHelper == null) {
                return;
            }
            SqlMembersHelper helper = sqlMembersHelper;
            PsiFile psiFile = header.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlFile");
            String delimiter = dialect.getDelimiterAt((SqlFile)psiFile, header.getTextRange().getStartOffset());
            JBIterable jBIterable = SqlImplUtil.siblings((PsiElement)header).skip(1).filter(arg_0 -> AddDefinitionFix.applyFix$lambda$0(applyFix.siblings.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable siblings2 = jBIterable;
            PsiElement psiElement3 = (PsiElement)siblings2.first();
            if (psiElement3 != null) {
                Intrinsics.checkNotNull((Object)delimiter);
                bl = this.isLeaf(psiElement3, delimiter);
            } else {
                bl = false;
            }
            if (!bl) {
                psiElement = parent2.addAfter(SqlPsiElementFactory.createLeafFromText(project, dialect, delimiter), (PsiElement)header);
            } else {
                Object object = siblings2.takeWhile(arg_0 -> AddDefinitionFix.applyFix$lambda$1((Function1)new Function1<PsiElement, Boolean>(delimiter){
                    final /* synthetic */ String $delimiter;
                    {
                        this.$delimiter = $delimiter;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(PsiElement it2) {
                        Intrinsics.checkNotNull((Object)it2);
                        String string = this.$delimiter;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$delimiter");
                        return AddDefinitionFix.access$isLeaf(AddDefinitionFix.INSTANCE, it2, string);
                    }
                }, arg_0)).last();
                Intrinsics.checkNotNull((Object)object);
                psiElement = (PsiElement)object;
            }
            PsiElement anchor2 = psiElement;
            SqlRoutineDefinition sqlRoutineDefinition2 = helper.generateImplementation(header);
            Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition2, (String)"generateImplementation(...)");
            SqlRoutineDefinition definition2 = sqlRoutineDefinition2;
            PsiElement definitionInPlace = anchor2 != null ? parent2.addAfter((PsiElement)definition2, anchor2) : parent2.add((PsiElement)definition2);
            PsiElement psiElement4 = SqlPsiElementFactory.newLine(project);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"newLine(...)");
            PsiElement newLine = psiElement4;
            parent2.addAfter(newLine, anchor2);
            parent2.addAfter(newLine, anchor2);
            PsiDocumentManager $this$applyFix_u24lambda_u242 = PsiDocumentManager.getInstance((Project)project);
            boolean bl2 = false;
            Document document = $this$applyFix_u24lambda_u242.getDocument(header.getContainingFile());
            if (document != null) {
                $this$applyFix_u24lambda_u242.doPostponedOperationsAndUnblockDocument(document);
            }
            CodeStyleManager.getInstance((Project)project).reformat(definitionInPlace);
        }

        private static final boolean applyFix$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean applyFix$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isLeaf(AddDefinitionFix $this, PsiElement $receiver, String text2) {
            return $this.isLeaf($receiver, text2);
        }
    }
}

