/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.actions.NavigationHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraMemberFunctionDefinitionImpl;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/oracle/inspections/OraMissingBodyInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.oracle"})
public final class OraMissingBodyInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        NavigationHelper helper = NavigationHelper.EP.forDbms(dialect.getDbms());
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, helper, onTheFly){
            final /* synthetic */ NavigationHelper $helper;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$helper = $helper;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlCreateStatement(@NotNull SqlCreateStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                super.visitSqlCreateStatement(o2);
                if (o2 instanceof OraCreatePackageStatementImpl || o2 instanceof SqlCreateTypeStatement && OraTypeSystem.Companion.isObjectType((DasUserDefinedType)o2)) {
                    this.checkDeclaration((SqlDefinition)o2);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasCallSpec(SqlDefinition $this$hasCallSpec) {
                PsiElement it2;
                if (!($this$hasCallSpec instanceof OraMemberFunctionDefinitionImpl)) return false;
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)((OraMemberFunctionDefinitionImpl)$this$hasCallSpec).getReturnArgument());
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"sqlChildren(...)");
                Iterable $this$any$iv = (Iterable)jBIterable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    it2 = (PsiElement)element$iv;
                    boolean bl = false;
                } while (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it2), (Object)OraTypes.ORA_LANGUAGE));
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void checkDeclaration(SqlDefinition declaration) {
                JBIterable bodies;
                boolean bl;
                boolean isObjectType = Intrinsics.areEqual((Object)declaration.getKind(), (Object)ObjectKind.OBJECT_TYPE);
                JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)declaration).filter(SqlDefinition.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$any$iv = (Iterable)jBIterable;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    block9: {
                        block8: {
                            SqlDefinition it2;
                            block7: {
                                if (!iterator.hasNext()) return;
                                T element$iv = iterator.next();
                                it2 = (SqlDefinition)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it2.getKind(), (Object)ObjectKind.ROUTINE)) break block7;
                                if (!isObjectType) break block8;
                                Intrinsics.checkNotNull((Object)it2);
                                if (!this.hasCallSpec(it2)) break block8;
                            }
                            if (!Intrinsics.areEqual((Object)it2.getKind(), (Object)SqlDbElementType.CURSOR)) break block9;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                boolean bl3 = true;
                if (!bl3) {
                    return;
                }
                Pair<String, JBIterable<? extends DasObject>> pair = this.$helper.findDefinitions((DasObject)declaration, false);
                Object object = pair != null ? (JBIterable)pair.second : null;
                if (object == null) {
                    JBIterable jBIterable2 = JBIterable.empty();
                    object = jBIterable2;
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
                }
                if (!(bodies = object).isEmpty()) return;
                this.reportMissingBody(declaration);
            }

            private final void reportMissingBody(SqlDefinition declaration) {
                PsiElement psiElement;
                SqlNameElement nameElement;
                boolean isObjectType = Intrinsics.areEqual((Object)declaration.getKind(), (Object)ObjectKind.OBJECT_TYPE);
                SqlNameElement sqlNameElement = nameElement = declaration.getNameElement();
                PsiElement startAnchor = sqlNameElement != null ? (PsiElement)sqlNameElement : declaration.getFirstChild();
                SqlNameElement sqlNameElement2 = nameElement;
                if (sqlNameElement2 != null) {
                    psiElement = (PsiElement)sqlNameElement2;
                } else {
                    T element$iv2;
                    block4: {
                        JBIterable<PsiElement> jBIterable = SqlImplUtil.siblings(startAnchor);
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"siblings(...)");
                        Iterable $this$first$iv = (Iterable)jBIterable;
                        boolean $i$f$first = false;
                        for (T element$iv2 : $this$first$iv) {
                            PsiElement e2 = (PsiElement)element$iv2;
                            boolean bl = false;
                            IElementType it2 = PsiTreeUtilKt.getElementType((PsiElement)e2);
                            boolean bl2 = false;
                            boolean bl3 = Intrinsics.areEqual((Object)it2, (Object)OraTypes.ORA_PACKAGE) || Intrinsics.areEqual((Object)it2, (Object)OraTypes.ORA_TYPE);
                            if (!bl3) continue;
                            break block4;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    psiElement = (PsiElement)element$iv2;
                    if (psiElement == null) {
                        psiElement = startAnchor;
                    }
                }
                PsiElement endAnchor = psiElement;
                String messageKey = isObjectType ? "inspection.message.missing.type.body" : "inspection.message.missing.package.body";
                this.addDescriptor(this.myManager.createProblemDescriptor(startAnchor, endAnchor, SqlBundle.message((String)messageKey, (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
        };
    }
}

