/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.database.dialects.oracle.OraDbSqlUtils;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNavigationUtils;
import com.intellij.sql.dialects.base.NavigationHelperBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraNavigationHelper
extends NavigationHelperBase {
    @Override
    public @Nullable Pair<@NlsContexts.PopupTitle String, JBIterable<? extends DasObject>> findSuperDefinitions(@NotNull DasObject def, boolean checkOnly) {
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(0);
        }
        if (def.getKind() == ObjectKind.BODY) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.specification", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodySpecifications(def));
        }
        if (OraDbSqlUtils.isBodyRoutine(def, false)) {
            JBIterable<? extends DasObject> specifications = OraNavigationHelper.findRoutineSpecifications(def);
            if (checkOnly && specifications.isEmpty()) {
                return null;
            }
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.specification", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : specifications);
        }
        if (def.getKind() == ObjectKind.OBJECT_TYPE) {
            if (checkOnly && !OraNavigationHelper.hasSuperTypes(def)) {
                return null;
            }
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.super.type", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findSuperTypes(def));
        }
        return null;
    }

    @Override
    public @Nullable Pair<@NlsContexts.PopupTitle String, JBIterable<? extends DasObject>> findDefinitions(@NotNull DasObject def, boolean checkOnly) {
        ObjectKind pKind;
        ObjectKind kind;
        if (def == null) {
            OraNavigationHelper.$$$reportNull$$$0(1);
        }
        if ((kind = def.getKind()) == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.body", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodies(def));
        }
        DasObject parent2 = def.getDasParent();
        ObjectKind objectKind = pKind = parent2 == null ? null : parent2.getKind();
        if (kind == ObjectKind.ROUTINE && (pKind == ObjectKind.PACKAGE || pKind == ObjectKind.OBJECT_TYPE || OraNavigationHelper.isBlockRoutineDefinition(def))) {
            return Pair.create((Object)SqlBundle.message((String)"popup.title.go.to.routine.definition", (Object[])new Object[0]), checkOnly ? JBIterable.empty() : OraNavigationHelper.findBodyRoutines(def));
        }
        return null;
    }

    private static boolean isBlockRoutineDefinition(@NotNull DasObject object) {
        if (object == null) {
            OraNavigationHelper.$$$reportNull$$$0(2);
        }
        return object instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)object).getBody().isEmpty() && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)object)) instanceof SqlFile);
    }

    @NotNull
    private static JBIterable<? extends DasObject> findBodies(@NotNull DasObject element2) {
        JBIterable bodies;
        if (element2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(3);
        }
        if ((bodies = element2.getDasChildren(ObjectKind.BODY)).isNotEmpty()) {
            JBIterable jBIterable = bodies;
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        JBIterable<? extends DasObject> objects2 = SqlImplUtil.unwrapFake(element2);
        bodies = objects2.flatten(e2 -> e2.getDasChildren(ObjectKind.BODY));
        if (bodies.isEmpty()) {
            bodies = objects2.filter(PsiElement.class).flatten(o2 -> SqlNavigationUtils.findRelatedDbElements(o2, true)).flatten(e2 -> e2.getDasChildren(ObjectKind.BODY));
        }
        JBIterable jBIterable = bodies;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    private static JBIterable<? extends DasObject> findBodyRoutines(@NotNull DasObject element2) {
        Object condition2;
        DasObject parent2;
        ObjectKind kind;
        if (element2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(6);
        }
        ObjectKind objectKind = kind = (parent2 = element2.getDasParent()) == null ? null : parent2.getKind();
        if (kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.PACKAGE) {
            condition2 = DbSqlUtilCore.byName(element2, null, DbImplUtilCore.getCasingProvider(element2));
            JBIterable result2 = OraNavigationHelper.findBodies(parent2).flatten(b2 -> {
                DbElement db2 = (DbElement)ObjectUtils.tryCast((Object)b2, DbElement.class);
                if (db2 == null) {
                    return b2.getDasChildren(ObjectKind.ROUTINE).filter(condition2);
                }
                VirtualFile file = DbTargetUtil.getContainingFile(db2, false);
                if (file == null) {
                    return JBIterable.empty();
                }
                return JBIterable.of((Object)DbTargetUtil.calcTarget(db2.getProject(), file, element2));
            });
            if (result2.isNotEmpty()) {
                return result2;
            }
        }
        if (element2 instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)element2).getBody().isEmpty() && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)element2)) instanceof SqlFile)) {
            condition2 = OraNavigationHelper.routineSpecCondition((DasRoutine)element2);
            return SqlImplUtil.siblings((PsiElement)((SqlRoutineDefinition)element2)).skip(1).filter(DasRoutine.class).filter(condition2);
        }
        return JBIterable.empty();
    }

    @NotNull
    private static JBIterable<? extends DasObject> findBodySpecifications(@NotNull DasObject body2) {
        DasObject parent2;
        JBIterable pkgs;
        if (body2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(7);
        }
        if ((pkgs = SqlImplUtil.unwrapFake(parent2 = body2.getDasParent())).isEmpty() && body2 instanceof PsiElement) {
            pkgs = SqlNavigationUtils.findRelatedDbElements((PsiElement)body2, true).map(DbElement::getParent);
        }
        JBIterable jBIterable = pkgs;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static boolean matchArgumentTypes(@NotNull DasArgument arg1, @NotNull DasArgument arg2, @NotNull CasingProvider casingProvider) {
        if (arg1 == null) {
            OraNavigationHelper.$$$reportNull$$$0(9);
        }
        if (arg2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(10);
        }
        if (casingProvider == null) {
            OraNavigationHelper.$$$reportNull$$$0(11);
        }
        if (!(arg1 instanceof SqlParameterDefinition) || !(arg2 instanceof SqlParameterDefinition)) {
            return false;
        }
        SqlTypeElement type1 = ((SqlParameterDefinition)arg1).getTypeElement();
        SqlTypeElement type2 = ((SqlParameterDefinition)arg2).getTypeElement();
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return OraNavigationHelper.matchTypeElements(type1, type2, casingProvider);
    }

    private static boolean matchTypeElements(@NotNull SqlTypeElement type1, @NotNull SqlTypeElement type2, @NotNull CasingProvider casingProvider) {
        if (type1 == null) {
            OraNavigationHelper.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(13);
        }
        if (casingProvider == null) {
            OraNavigationHelper.$$$reportNull$$$0(14);
        }
        List children1 = SqlImplUtil.sqlChildrenNoWS((PsiElement)type1).toList();
        List children2 = SqlImplUtil.sqlChildrenNoWS((PsiElement)type2).toList();
        if (children1.size() != children2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < children1.size(); ++i2) {
            PsiElement child1 = (PsiElement)children1.get(i2);
            PsiElement child2 = (PsiElement)children2.get(i2);
            if (child1 instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref1 = (SqlReferenceExpression)child1;
                if (!(child2 instanceof SqlReferenceExpression)) {
                    return false;
                }
                SqlReferenceExpression ref2 = (SqlReferenceExpression)child2;
                NameChecker checker = new NameChecker(ref1.getName(), ref1.isQuoted(), casingProvider, SqlImplUtil.getSqlDialectSafe((PsiElement)type1));
                if (!checker.checkName((DasNamed)ref2, null)) {
                    return false;
                }
            }
            if (child1 instanceof SqlTypeElement) {
                if (!(child2 instanceof SqlTypeElement)) {
                    return false;
                }
                if (!OraNavigationHelper.matchTypeElements((SqlTypeElement)child1, (SqlTypeElement)child2, casingProvider)) {
                    return false;
                }
            }
            if (child1.getText().equalsIgnoreCase(child2.getText())) continue;
            return false;
        }
        return true;
    }

    private static Condition<DasObject> routineSpecCondition(@NotNull DasRoutine routine2) {
        if (routine2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(15);
        }
        CasingProvider casingProvider = DbImplUtilCore.getCasingProvider(routine2);
        Condition nameCondition = DbSqlUtilCore.byName(routine2, null, casingProvider);
        Collection args2 = ContainerUtil.toCollection(routine2.getArguments());
        List argConditions = ContainerUtil.map((Collection)args2, arg -> Conditions.and(DbSqlUtilCore.byName(arg, null, DbImplUtilCore.getCasingProvider(arg)), o2 -> o2 instanceof DasArgument && ((DasArgument)o2).getArgumentDirection() == arg.getArgumentDirection() && OraNavigationHelper.matchArgumentTypes((DasArgument)o2, arg, casingProvider)));
        return obj2 -> {
            if (!(obj2 instanceof DasRoutine)) {
                return false;
            }
            if (!nameCondition.value(obj2)) {
                return false;
            }
            Collection currentArgs = ContainerUtil.toCollection(((DasRoutine)obj2).getArguments());
            if (currentArgs.size() != argConditions.size()) {
                return false;
            }
            int i2 = 0;
            for (DasArgument currentArg : currentArgs) {
                Condition argCondition;
                if ((argCondition = (Condition)argConditions.get(i2++)).value((Object)currentArg)) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    private static JBIterable<? extends DasObject> findRoutineSpecifications(@NotNull DasObject routine2) {
        DasObject body2;
        if (routine2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(16);
        }
        if (!(routine2 instanceof DasRoutine)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        if (routine2 instanceof SqlRoutineDefinition && !(SqlImplUtil.sqlParent((PsiElement)((SqlRoutineDefinition)routine2)) instanceof SqlFile)) {
            Condition<DasObject> condition2 = OraNavigationHelper.routineSpecCondition((DasRoutine)routine2);
            JBIterable result2 = SqlImplUtil.revSiblings((PsiElement)((SqlRoutineDefinition)routine2)).skip(1).filter(DasRoutine.class).filter(condition2);
            if (result2.isNotEmpty()) {
                JBIterable jBIterable = result2;
                if (jBIterable == null) {
                    OraNavigationHelper.$$$reportNull$$$0(18);
                }
                return jBIterable;
            }
        }
        if ((body2 = routine2.getDasParent()) != null && body2.getKind() == ObjectKind.BODY) {
            Condition condition3 = DbSqlUtilCore.byName(routine2, null, DbImplUtilCore.getCasingProvider(routine2));
            JBIterable result3 = OraNavigationHelper.findBodySpecifications(body2).flatten(b2 -> b2.getDasChildren(ObjectKind.ROUTINE).filter(condition3));
            if (result3.isNotEmpty()) {
                JBIterable jBIterable = result3;
                if (jBIterable == null) {
                    OraNavigationHelper.$$$reportNull$$$0(19);
                }
                return jBIterable;
            }
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    private static boolean hasSuperTypes(@NotNull DasObject type2) {
        if (type2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(21);
        }
        if (type2 instanceof SqlCreateTypeStatementImpl) {
            return ((SqlCreateTypeStatementImpl)((Object)type2)).getSuperTypeReference() != null;
        }
        if (type2 instanceof DasUserDefinedType) {
            return ((DasUserDefinedType)type2).getSuperType() != null;
        }
        return false;
    }

    @NotNull
    private static JBIterable<? extends DasObject> findSuperTypes(@NotNull DasObject type2) {
        DasUserDefinedType tp;
        DasUserDefinedType st;
        if (type2 == null) {
            OraNavigationHelper.$$$reportNull$$$0(22);
        }
        DasUserDefinedType dasUserDefinedType = st = (tp = (DasUserDefinedType)ObjectUtils.tryCast((Object)type2, DasUserDefinedType.class)) == null ? null : tp.getSuperType();
        if (st == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OraNavigationHelper.$$$reportNull$$$0(23);
            }
            return jBIterable;
        }
        JBIterable<? extends DasObject> supers = SqlImplUtil.unwrapFake(st);
        if (supers.isEmpty() && st instanceof PsiElement) {
            supers = SqlNavigationUtils.findRelatedDbElements((PsiElement)st, true);
        }
        JBIterable<? extends DasObject> jBIterable = supers;
        if (jBIterable == null) {
            OraNavigationHelper.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 17, 18, 19, 20, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraNavigationHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraNavigationHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBodySpecifications";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findRoutineSpecifications";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperDefinitions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBlockRoutineDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBodies";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBodyRoutines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBodySpecifications";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchArgumentTypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "routineSpecCondition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRoutineSpecifications";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSuperTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 17, 18, 19, 20, 23, 24 -> new IllegalStateException(string);
        };
    }
}

