/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlParsingInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            MysqlParsingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MysqlParsingInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            MysqlParsingInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlFile(SqlFile o2) {
                Version min = (Version)SqlImplUtil.getDbVersions(o2).sort(Version::compareTo).first();
                if (min != null && min.isOrGreater(8, 0)) {
                    return;
                }
                super.visitSqlFile(o2);
            }

            public void visitSqlExpression(SqlExpression o2) {
                super.visitSqlExpression(o2);
                if (!this.isUnionParenExpression((PsiElement)o2)) {
                    return;
                }
                PsiElement parent2 = o2.getParent();
                if (this.isUnionParenExpression(parent2)) {
                    return;
                }
                if (parent2 instanceof SqlJoinExpression || parent2 instanceof SqlAsExpression) {
                    this.markErrorsFirstJ(o2);
                } else {
                    this.markErrorsFirstQ(o2);
                }
            }

            private boolean isUnionParenExpression(PsiElement o2) {
                return o2 instanceof SqlUnionExpression || o2 instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)o2).getExpressionList().size() == 1 && !1.isExprParens(o2);
            }

            private static boolean isExprParens(PsiElement o2) {
                return PsiUtilCore.getElementType((PsiElement)o2) == SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION || o2.getParent() instanceof SqlBinaryExpression && !(o2.getParent() instanceof SqlUnionExpression) && !(o2.getParent() instanceof SqlJoinExpression);
            }

            private void markErrorsFirstJ(SqlExpression o2) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o2)) {
                    return;
                }
                if (o2 instanceof SqlUnionExpression) {
                    List operands2 = ((SqlUnionExpression)o2).getOperands();
                    if (!operands2.isEmpty()) {
                        this.markErrorsFirstJ((SqlExpression)operands2.get(0));
                        for (int i2 = 1; i2 < operands2.size(); ++i2) {
                            this.markErrors((SqlExpression)operands2.get(i2));
                        }
                    }
                } else if (o2 instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o2).getExpressionList()).size() == 1) {
                    this.markErrorsFirstJ((SqlExpression)list.get(0));
                }
            }

            private boolean markErrorsFirstQ(SqlExpression o2) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o2)) {
                    return false;
                }
                if (o2 instanceof SqlUnionExpression) {
                    List operands2 = ((SqlUnionExpression)o2).getOperands();
                    for (SqlExpression operand : operands2) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                } else if (o2 instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o2).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }

            private boolean markErrors(SqlExpression o2) {
                List list;
                if (!this.isUnionParenExpression((PsiElement)o2)) {
                    return false;
                }
                if (o2 instanceof SqlUnionExpression) {
                    SqlUnionExpression union = (SqlUnionExpression)o2;
                    PsiElement wrongUnion = union.getOpSignElement();
                    for (SqlExpression operand : union.getOperands()) {
                        if (!this.markErrors(operand)) continue;
                        return true;
                    }
                    if (wrongUnion != null) {
                        this.addDescriptor(manager.createProblemDescriptor(wrongUnion, DatabaseBundle.message("inspection.message.supported.syntax", new Object[0]), true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[0]));
                        return true;
                    }
                }
                if (o2 instanceof SqlParenthesizedExpression && (list = ((SqlParenthesizedExpression)o2).getExpressionList()).size() == 1) {
                    return this.markErrors((SqlExpression)list.get(0));
                }
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlParsingInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

