/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.mysql.psi.MysqlLoadDmlInstructionImpl;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlLoadDataPathInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlDmlInstruction(SqlDmlInstruction o2) {
                String path;
                if (!(o2 instanceof MysqlLoadDmlInstructionImpl)) {
                    return;
                }
                SqlStringLiteralExpression pathLiteral = ((MysqlLoadDmlInstructionImpl)o2).getPath();
                String string = path = pathLiteral == null ? null : pathLiteral.getValue();
                if (path == null) {
                    return;
                }
                if (!MysqlLoadDataPathInspection.startsWithTilde(path)) {
                    return;
                }
                this.addDescriptor(manager.createProblemDescriptor((PsiElement)pathLiteral, DatabaseBundle.message("inspection.message.tilde.allowed.here", new Object[0]), (LocalQuickFix)new PathExpander(), ProblemHighlightType.WEAK_WARNING, onTheFly));
            }
        };
    }

    private static boolean startsWithTilde(@NotNull String path) {
        if (path == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(3);
        }
        return path.startsWith("~/") || path.startsWith("~\\");
    }

    @NotNull
    private static String expandTilde(@NotNull String path) {
        if (path == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(4);
        }
        Object object = MysqlLoadDataPathInspection.startsWithTilde(path) ? StringUtil.escapeChar((String)SystemProperties.getUserHome(), (char)'\\') + path.substring(1) : path;
        if (object == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(5);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTilde";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTilde";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandTilde";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class PathExpander
    implements LocalQuickFix {
        private PathExpander() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DatabaseBundle.message("intention.family.name.expand.tilde", new Object[0]);
            if (string == null) {
                PathExpander.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            SqlStringLiteralExpression literal;
            if (project == null) {
                PathExpander.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                PathExpander.$$$reportNull$$$0(2);
            }
            if ((literal = (SqlStringLiteralExpression)ObjectUtils.tryCast((Object)descriptor2.getPsiElement(), SqlStringLiteralExpression.class)) == null) {
                return;
            }
            Document document = literal.getContainingFile().getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            String value2 = literal.getValue();
            if (value2 == null) {
                return;
            }
            String result2 = MysqlLoadDataPathInspection.expandTilde(value2);
            TextRange range = literal.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("'" + result2 + "'"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection$PathExpander";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection$PathExpander";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

