/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.dateTime.SqlDtToken;
import com.intellij.sql.dialects.dateTime.psi.ParseContext;
import com.intellij.sql.dialects.dateTime.psi.ParseUtilsKt;
import com.intellij.sql.dialects.dateTime.psi.SqlDtCompositeElementType;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValue;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValueKt;
import com.intellij.sql.dialects.mysql.MysqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.mysql._MysqlDtLexer;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u000e\u0018\u00010\u001d\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u001e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/sql/dialects/mysql/MysqlDateTimeLanguageHelper;", "Lcom/intellij/sql/dialects/dateTime/SqlDateTimeLanguageHelper;", "()V", "DATE_DELIMITERS_STRICT", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "DATE_TIME_DELIMITERS", "DELIMITERS_NON_STRICT", "MAX_DURATION_HOURS", "", "ODBC_TIME_DELIMITERS", "TIME_DELIMITERS_STRICT", "createLexer", "Lcom/intellij/lexer/FlexLexer;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createParser", "Lcom/intellij/lang/PsiParser;", "getRootElementType", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtCompositeElementType;", "inspectTemporalValue", "Lcom/intellij/codeInspection/ProblemDescriptor;", "temporal", "Lcom/intellij/sql/dialects/dateTime/psi/values/SqlTemporalValue;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "validateTemporalValue", "", "Lorg/jetbrains/annotations/Nls;", "intellij.database.dialects.mysqlbase"})
public final class MysqlDateTimeLanguageHelper
extends SqlDateTimeLanguageHelper {
    @NotNull
    public static final MysqlDateTimeLanguageHelper INSTANCE = new MysqlDateTimeLanguageHelper();
    @NotNull
    private static final TokenSet DATE_TIME_DELIMITERS;
    @NotNull
    private static final TokenSet DELIMITERS_NON_STRICT;
    @NotNull
    private static final TokenSet DATE_DELIMITERS_STRICT;
    @NotNull
    private static final TokenSet TIME_DELIMITERS_STRICT;
    @NotNull
    private static final TokenSet ODBC_TIME_DELIMITERS;
    private static final int MAX_DURATION_HOURS = 838;

    private MysqlDateTimeLanguageHelper() {
    }

    @Override
    @Nullable
    public SqlDtCompositeElementType getRootElementType(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        SqlTimeAndDateLiteralExpressionImpl sqlTimeAndDateLiteralExpressionImpl = psiElement instanceof SqlTimeAndDateLiteralExpressionImpl ? (SqlTimeAndDateLiteralExpressionImpl)psiElement : null;
        return Intrinsics.areEqual((Object)(sqlTimeAndDateLiteralExpressionImpl != null ? sqlTimeAndDateLiteralExpressionImpl.getElementType() : null), (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? SqlDtCompositeElementType.Companion.getDURATION() : super.getRootElementType(host);
    }

    @Override
    @NotNull
    public FlexLexer createLexer(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
        return new _MysqlDtLexer(Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) || Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? SqlDtToken.WHITE_SPACE : (IElementType)SqlDtToken.SIGNIFICANT_WHITE_SPACE);
    }

    @Override
    @NotNull
    public PsiParser createParser(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return ParseUtilsKt.parser((Function2<? super ParseContext, ? super IElementType, Boolean>)((Function2)new Function2<ParseContext, IElementType, Boolean>(host){
            final /* synthetic */ PsiLanguageInjectionHost $host;
            {
                this.$host = $host;
                super(2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ParseContext $this$parser, @NotNull IElementType root2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$parser, (String)"$this$parser");
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                PsiElement psiElement = this.$host.getParent();
                IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                boolean isOdbc = SqlCompositeElementTypes.ODBC_DATE_TIME_TYPES.contains(hostType);
                if ($this$parser.consumeSpaces()) {
                    IElementType iElementType = root2;
                    boolean bl2 = Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getDATE())) ? !isOdbc && createParser.1.invoke$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.1.INSTANCE)) || createParser.1.invoke$parseDate(isOdbc, $this$parser, hostType) : ((Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getTIME())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getDURATION()))) ? !isOdbc && $this$parser.maybe(SqlDtToken.MINUS) && createParser.1.invoke$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.2.INSTANCE)) && createParser.1.invoke$parseFractionalPart($this$parser, hostType) || createParser.1.invoke$parseTime($this$parser, root2, hostType, isOdbc) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())) ? !isOdbc && createParser.1.invoke$parseConcatenatedValue($this$parser, (Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.3.INSTANCE)) && createParser.1.invoke$parseFractionalPart($this$parser, hostType) || createParser.1.invoke$parseTimestamp(isOdbc, $this$parser, hostType, root2) : false));
                    if (bl2 && $this$parser.consumeSpaces()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }

            private static final boolean invoke$parseConcatenatedValue(ParseContext $this_parser, Function2<? super ParseContext, ? super String, SqlDtCompositeElementType> calcType) {
                if (!Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.NUMBER))) {
                    return false;
                }
                if ($this_parser.getBuilder().rawLookup(1) == null || Intrinsics.areEqual((Object)$this_parser.getBuilder().rawLookup(1), (Object)((Object)SqlDtToken.DOT)) || Intrinsics.areEqual((Object)$this_parser.getBuilder().rawLookup(1), (Object)((Object)SqlDtToken.SIGNIFICANT_WHITE_SPACE)) && $this_parser.getBuilder().rawLookup(2) == null) {
                    String string = $this_parser.getBuilder().getTokenText();
                    Intrinsics.checkNotNull((Object)string);
                    SqlDtCompositeElementType elementType = (SqlDtCompositeElementType)((Object)calcType.invoke((Object)$this_parser, (Object)string));
                    PsiBuilder.Marker marker = $this_parser.getBuilder().mark();
                    Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                    PsiBuilder.Marker marker2 = marker;
                    $this_parser.getBuilder().advanceLexer();
                    marker2.done((IElementType)elementType);
                    return true;
                }
                return false;
            }

            private static final boolean invoke$parseDate(boolean isOdbc, ParseContext $this_parser, IElementType hostType) {
                TokenSet dateDelimiters = isOdbc ? MysqlDateTimeLanguageHelper.access$getDATE_DELIMITERS_STRICT$p() : MysqlDateTimeLanguageHelper.access$getDELIMITERS_NON_STRICT$p();
                String delimiterMessage = isOdbc ? "'-'" : "punctuation character";
                return $this_parser.elem(SqlDtCompositeElementType.Companion.getYEAR(), "positive number", (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(hostType){
                    final /* synthetic */ IElementType $hostType;
                    {
                        this.$hostType = $hostType;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ParseContext $this$elem) {
                        Intrinsics.checkNotNullParameter((Object)$this$elem, (String)"$this$elem");
                        return (!Intrinsics.areEqual((Object)this.$hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) || $this$elem.maybe(SqlDtToken.MINUS)) && ParseContext.tok$default($this$elem, SqlDtToken.NUMBER, null, 2, null);
                    }
                })) && ($this_parser.some(dateDelimiters) || isOdbc && Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.NUMBER)) || $this_parser.recoverUpTo(SqlDtToken.NUMBER, delimiterMessage)) && $this_parser.elem(SqlDtCompositeElementType.Companion.getMONTH(), "positive number", (Function1<? super ParseContext, Boolean>)((Function1)createParser.parseDate.2.INSTANCE)) && ($this_parser.some(dateDelimiters) || isOdbc && Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.NUMBER)) || $this_parser.recoverUpTo(SqlDtToken.NUMBER, delimiterMessage)) && $this_parser.elem(SqlDtCompositeElementType.Companion.getDAY_OF_MONTH(), "positive number", (Function1<? super ParseContext, Boolean>)((Function1)createParser.parseDate.3.INSTANCE));
            }

            private static final boolean invoke$parseFractionalPart(ParseContext $this_parser, IElementType hostType) {
                return ParseContext.maybe$default($this_parser, false, (Function1)new Function1<ParseContext, Boolean>(hostType){
                    final /* synthetic */ IElementType $hostType;
                    {
                        this.$hostType = $hostType;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                        return (ParseContext.tok$default($this$maybe, SqlDtToken.DOT, null, 2, null) || $this$maybe.tok(SqlDtToken.GENERIC_DELIMITER, (Function2<? super ParseContext, ? super String, String>)((Function2)createParser.parseFractionalPart.1.INSTANCE))) && $this$maybe.maybe(!Intrinsics.areEqual((Object)this.$hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP), (Function1<? super ParseContext, Boolean>)((Function1)createParser.parseFractionalPart.2.INSTANCE));
                    }
                }, 1, null);
            }

            private static final boolean invoke$parseTimeBase(IElementType hostType, ParseContext $this_parser, boolean isOdbc, IElementType $root, boolean isOptionalHour) {
                IElementType iElementType = hostType;
                Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getTIME_DELIMITERS_STRICT$p(), (Object)"':'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getODBC_TIME_DELIMITERS$p(), (Object)"':' or '.'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getTIME_DELIMITERS_STRICT$p(), (Object)"':'") : TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getDELIMITERS_NON_STRICT$p(), (Object)"punctuation character")));
                TokenSet timeDelimiters = (TokenSet)pair.component1();
                String delimiterMessage = (String)pair.component2();
                LighterASTNode lighterASTNode = $this_parser.getBuilder().getLatestDoneMarker();
                return (Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)((Object)SqlDtCompositeElementType.Companion.getDAY_OF_TIME())) || $this_parser.maybe(SqlDtToken.MINUS)) && $this_parser.maybe(isOptionalHour, (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(timeDelimiters){
                    final /* synthetic */ TokenSet $timeDelimiters;
                    {
                        this.$timeDelimiters = $timeDelimiters;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                        return $this$maybe.elem(SqlDtCompositeElementType.Companion.getHOUR(), this.$timeDelimiters.contains($this$maybe.getBuilder().getTokenType()) ? null : "positive number", (Function1<? super ParseContext, Boolean>)((Function1)createParser.parseTimeBase.1.INSTANCE));
                    }
                })) && $this_parser.maybe(!isOdbc, (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(timeDelimiters, isOdbc, delimiterMessage, $root, $this_parser, hostType){
                    final /* synthetic */ TokenSet $timeDelimiters;
                    final /* synthetic */ boolean $isOdbc;
                    final /* synthetic */ String $delimiterMessage;
                    final /* synthetic */ IElementType $root;
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ IElementType $hostType;
                    {
                        this.$timeDelimiters = $timeDelimiters;
                        this.$isOdbc = $isOdbc;
                        this.$delimiterMessage = $delimiterMessage;
                        this.$root = $root;
                        this.$this_parser = $this_parser;
                        this.$hostType = $hostType;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                        return ($this$maybe.some(this.$timeDelimiters) || this.$isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.NUMBER)) || $this$maybe.recoverUpTo(SqlDtToken.NUMBER, this.$delimiterMessage)) && $this$maybe.maybe(!this.$isOdbc && Intrinsics.areEqual((Object)this.$root, (Object)((Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())), (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(this.$isOdbc, this.$timeDelimiters, this.$delimiterMessage, this.$root, this.$this_parser, this.$hostType){
                            final /* synthetic */ boolean $isOdbc;
                            final /* synthetic */ TokenSet $timeDelimiters;
                            final /* synthetic */ String $delimiterMessage;
                            final /* synthetic */ IElementType $root;
                            final /* synthetic */ ParseContext $this_parser;
                            final /* synthetic */ IElementType $hostType;
                            {
                                this.$isOdbc = $isOdbc;
                                this.$timeDelimiters = $timeDelimiters;
                                this.$delimiterMessage = $delimiterMessage;
                                this.$root = $root;
                                this.$this_parser = $this_parser;
                                this.$hostType = $hostType;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                                Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                                return (ParseContext.elem$default($this$maybe, SqlDtCompositeElementType.Companion.getMINUTE(), null, createParser.parseTimeBase.1.INSTANCE, 2, null) || $this$maybe.recoverUpTo(SqlDtToken.NUMBER, "positive number")) && $this$maybe.maybe(!this.$isOdbc, (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(this.$timeDelimiters, this.$isOdbc, this.$delimiterMessage, this.$root, this.$this_parser, this.$hostType){
                                    final /* synthetic */ TokenSet $timeDelimiters;
                                    final /* synthetic */ boolean $isOdbc;
                                    final /* synthetic */ String $delimiterMessage;
                                    final /* synthetic */ IElementType $root;
                                    final /* synthetic */ ParseContext $this_parser;
                                    final /* synthetic */ IElementType $hostType;
                                    {
                                        this.$timeDelimiters = $timeDelimiters;
                                        this.$isOdbc = $isOdbc;
                                        this.$delimiterMessage = $delimiterMessage;
                                        this.$root = $root;
                                        this.$this_parser = $this_parser;
                                        this.$hostType = $hostType;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                                        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                                        return ($this$maybe.some(this.$timeDelimiters) || this.$isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.NUMBER)) || $this$maybe.recoverUpTo(SqlDtToken.NUMBER, this.$delimiterMessage)) && $this$maybe.maybe(!this.$isOdbc && Intrinsics.areEqual((Object)this.$root, (Object)((Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())), (Function1<? super ParseContext, Boolean>)((Function1)new Function1<ParseContext, Boolean>(this.$this_parser, this.$hostType){
                                            final /* synthetic */ ParseContext $this_parser;
                                            final /* synthetic */ IElementType $hostType;
                                            {
                                                this.$this_parser = $this_parser;
                                                this.$hostType = $hostType;
                                                super(1);
                                            }

                                            @NotNull
                                            public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                                                Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                                                return (ParseContext.elem$default($this$maybe, SqlDtCompositeElementType.Companion.getSECOND(), null, createParser.parseTimeBase.1.INSTANCE, 2, null) || $this$maybe.recoverUpTo(SqlDtToken.NUMBER, "positive number")) && createParser.1.access$invoke$parseFractionalPart(this.$this_parser, this.$hostType);
                                            }
                                        }));
                                    }
                                }));
                            }
                        }));
                    }
                }));
            }

            private static final boolean invoke$parseTime(ParseContext $this_parser, IElementType $root, IElementType hostType, boolean isOdbc) {
                return ParseContext.maybe$default($this_parser, false, (Function1)new Function1<ParseContext, Boolean>($root){
                    final /* synthetic */ IElementType $root;
                    {
                        this.$root = $root;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ParseContext $this$maybe) {
                        Intrinsics.checkNotNullParameter((Object)$this$maybe, (String)"$this$maybe");
                        return Intrinsics.areEqual((Object)this.$root, (Object)((Object)SqlDtCompositeElementType.Companion.getDURATION())) && $this$maybe.maybe(SqlDtToken.MINUS) && ParseContext.elem$default($this$maybe, SqlDtCompositeElementType.Companion.getDAY_OF_TIME(), null, createParser.parseTime.1.INSTANCE, 2, null) && $this$maybe.consumeSpaces();
                    }
                }, 1, null) && createParser.1.invoke$parseTimeBase(hostType, $this_parser, isOdbc, $root, true);
            }

            private static final boolean invoke$parseDateTimeDelimiter(IElementType hostType, ParseContext $this_parser) {
                if (Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP)) {
                    return $this_parser.singleSpace();
                }
                int tokenCount = 0;
                boolean isError = false;
                PsiBuilder.Marker marker = $this_parser.getBuilder().mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                PsiBuilder.Marker marker2 = marker;
                while (MysqlDateTimeLanguageHelper.access$getDATE_TIME_DELIMITERS$p().contains($this_parser.getBuilder().getTokenType())) {
                    if (Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenType(), (Object)((Object)SqlDtToken.IDENTIFIER))) {
                        isError = !Intrinsics.areEqual((Object)$this_parser.getBuilder().getTokenText(), (Object)"T");
                    }
                    ++tokenCount;
                    $this_parser.getBuilder().advanceLexer();
                }
                boolean bl = isError = isError || tokenCount != 1;
                if (isError) {
                    marker2.error(SqlBundle.message((String)"parsing.error.t.or.space.expected", (Object[])new Object[0]));
                } else {
                    marker2.drop();
                }
                return true;
            }

            private static final boolean invoke$parseTimestamp(boolean isOdbc, ParseContext $this_parser, IElementType hostType, IElementType $root) {
                return createParser.1.invoke$parseDate(isOdbc, $this_parser, hostType) && createParser.1.invoke$parseDateTimeDelimiter(hostType, $this_parser) && createParser.1.invoke$parseTimeBase(hostType, $this_parser, isOdbc, $root, false);
            }

            public static final /* synthetic */ boolean access$invoke$parseFractionalPart(ParseContext $this_parser, IElementType hostType) {
                return createParser.1.invoke$parseFractionalPart($this_parser, hostType);
            }
        }));
    }

    @Override
    @Nullable
    public ProblemDescriptor inspectTemporalValue(@NotNull SqlTemporalValue<?> temporal, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor problemDescriptor;
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (temporal instanceof SqlTemporalValue.TimeDuration) {
            SqlTemporalValue.Hour hour = ((SqlTemporalValue.TimeDuration)temporal).getHour();
            if (hour == null) {
                return null;
            }
            SqlTemporalValue.Hour hour2 = hour;
            Object object = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime();
            int dayOfTime = Math.abs(object != null && (object = ((SqlTemporalValue.DayOfTime)object).getValue()) != null ? (Integer)object : 0);
            int maxHours = 838 - dayOfTime * 24;
            if (maxHours < 0) {
                return null;
            }
            int minHours = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime() != null ? 0 : -maxHours;
            String string = this.validateInterval(hour2, minHours, maxHours);
            if (string == null) {
                return null;
            }
            String message2 = string;
            problemDescriptor = manager.createProblemDescriptor((PsiElement)hour2.getPsi(), SqlTemporalValueKt.getRangeInElement(hour2), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
        } else {
            problemDescriptor = super.inspectTemporalValue(temporal, manager, isOnTheFly);
        }
        return problemDescriptor;
    }

    @Override
    @Nullable
    public String validateTemporalValue(@NotNull SqlTemporalValue<?> temporal) {
        String string;
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        SqlTemporalValue<Integer> sqlTemporalValue = temporal;
        if (sqlTemporalValue instanceof SqlTemporalValue.Date) {
            int textLength = temporal.getPsi().getTextLength();
            string = SqlTemporalValueKt.isConcatenated(temporal) && textLength != 6 && textLength != 8 ? SqlBundle.message((String)"inspection.message.concatenated.date.must.take.form.either.yymmdd.or.yyyymmdd", (Object[])new Object[0]) : null;
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Year) {
            string = this.validateInterval(temporal, -9999, 9999);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.DayOfTime) {
            string = this.validateInterval(temporal, 0, 34);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Hour) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)temporal.getPsi().getParent());
            string = Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())) ? this.validateInterval(temporal, 0, 23) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlDtCompositeElementType.Companion.getTIME())) ? this.validateInterval(temporal, -838, 838) : null);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.SecondFraction) {
            IntRange intRange = new IntRange(0, 999999);
            Integer n = ((SqlTemporalValue.SecondFraction)temporal).getValue();
            string = !(n != null && intRange.contains(n.intValue())) ? SqlBundle.message((String)"inspection.message.fractions.longer.than.digits.are.rounded.off", (Object[])new Object[0]) : null;
        } else {
            string = super.validateTemporalValue(temporal);
        }
        return string;
    }

    public static final /* synthetic */ TokenSet access$getDATE_DELIMITERS_STRICT$p() {
        return DATE_DELIMITERS_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getDELIMITERS_NON_STRICT$p() {
        return DELIMITERS_NON_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getTIME_DELIMITERS_STRICT$p() {
        return TIME_DELIMITERS_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getODBC_TIME_DELIMITERS$p() {
        return ODBC_TIME_DELIMITERS;
    }

    public static final /* synthetic */ TokenSet access$getDATE_TIME_DELIMITERS$p() {
        return DATE_TIME_DELIMITERS;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{SqlDtToken.SIGNIFICANT_WHITE_SPACE, SqlDtToken.IDENTIFIER};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        DATE_TIME_DELIMITERS = tokenSet;
        iElementTypeArray = new IElementType[]{SqlDtToken.PLUS, SqlDtToken.MINUS, SqlDtToken.COLON, SqlDtToken.DOT, SqlDtToken.GENERIC_DELIMITER};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        DELIMITERS_NON_STRICT = tokenSet2;
        iElementTypeArray = new IElementType[]{SqlDtToken.MINUS};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        DATE_DELIMITERS_STRICT = tokenSet3;
        iElementTypeArray = new IElementType[]{SqlDtToken.COLON};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        TIME_DELIMITERS_STRICT = tokenSet4;
        iElementTypeArray = new IElementType[]{SqlDtToken.COLON, SqlDtToken.DOT};
        TokenSet tokenSet5 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"create(...)");
        ODBC_TIME_DELIMITERS = tokenSet5;
    }
}

