/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.dialects.mssql.formatter.MsCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.formatter.settings.SqlDialectSpecificCodeStyleScheme;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/mssql/formatter/MsVsSqlCodeStyleScheme;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Lcom/intellij/sql/formatter/settings/SqlDialectSpecificCodeStyleScheme;", "()V", "SCHEME_NAME", "", "getApplicableDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getBasePreset", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettingsDefault;", "getCodeStyleSettings", "getDisplayName", "getName", "isDefault", "", "setup", "", "sql", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "CSP", "intellij.database.dialects.mssql"})
public final class MsVsSqlCodeStyleScheme
extends CodeStyleSettings
implements SqlDialectSpecificCodeStyleScheme {
    @NotNull
    public static final MsVsSqlCodeStyleScheme INSTANCE = new MsVsSqlCodeStyleScheme();
    @NlsSafe
    @NotNull
    public static final String SCHEME_NAME = "Visual Studio Database Project";

    private MsVsSqlCodeStyleScheme() {
        super(false, false);
    }

    @NotNull
    public SqlLanguageDialect getApplicableDialect() {
        MsDialect msDialect = MsDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)msDialect, (String)"INSTANCE");
        return msDialect;
    }

    @NotNull
    public String getName() {
        return SCHEME_NAME;
    }

    @NotNull
    public String getDisplayName() {
        String string = SqlBundle.message((String)"code.style.predefined.MsVsDdl", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isDefault() {
        return false;
    }

    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        return this;
    }

    @NotNull
    public final SqlCodeStyleSettingsDefault getBasePreset() {
        SqlCodeStyleSettingsDefault sqlCodeStyleSettingsDefault = SqlCodeStyleSettingsDefault.MODERN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettingsDefault, (String)"MODERN");
        return sqlCodeStyleSettingsDefault;
    }

    public final void setup(@NotNull SqlCodeStyleSettings sql) {
        SqlCodeStyleSettings sqlCodeStyleSettings;
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        SqlCodeStyleSettings $this$setup_u24lambda_u240 = sqlCodeStyleSettings = sql;
        boolean bl = false;
        $this$setup_u24lambda_u240.USE_GENERAL_STYLE = false;
        $this$setup_u24lambda_u240.KEYWORD_CASE = 2;
        $this$setup_u24lambda_u240.IDENTIFIER_CASE = 0;
        $this$setup_u24lambda_u240.TYPE_CASE = 3;
        $this$setup_u24lambda_u240.CUSTOM_TYPE_CASE = 4;
        $this$setup_u24lambda_u240.ALIAS_CASE = 4;
        $this$setup_u24lambda_u240.BUILT_IN_CASE = 3;
        $this$setup_u24lambda_u240.QUOTED_IDENTIFIER_CASE = 0;
        $this$setup_u24lambda_u240.ORIGINAL_CASE = false;
        $this$setup_u24lambda_u240.QUOTE_IDENTIFIER = 2;
        $this$setup_u24lambda_u240.QUOTE_TYPE = 21;
        $this$setup_u24lambda_u240.TABLE_OPENING = 1;
        $this$setup_u24lambda_u240.TABLE_CONTENT = 2;
        $this$setup_u24lambda_u240.TABLE_CLOSING = 3;
        $this$setup_u24lambda_u240.TABLE_TYPES_ALIGN = true;
        $this$setup_u24lambda_u240.TABLE_DEFAULTS_ALIGN = true;
        $this$setup_u24lambda_u240.TABLE_NULLABILITIES_ALIGN = true;
        $this$setup_u24lambda_u240.TABLE_COLLAPSE = false;
        $this$setup_u24lambda_u240.CONSTRAINT_WRAP_1 = false;
        $this$setup_u24lambda_u240.CONSTRAINT_WRAP_2 = false;
        $this$setup_u24lambda_u240.CONSTRAINT_WRAP_3 = false;
        $this$setup_u24lambda_u240.CONSTRAINT_WRAP_4 = false;
        $this$setup_u24lambda_u240.SCRIPT_STMT_SEMICOLON_WRAP = 2;
        $this$setup_u24lambda_u240.SCRIPT_STMT_FOLLOWS_BLANK_LINE = 1;
        SqlCodeStyleSettings $this$setup_u24lambda_u241 = sqlCodeStyleSettings = sql.getCorrespondedCommonSettings();
        boolean bl2 = false;
        $this$setup_u24lambda_u241.KEEP_LINE_BREAKS = false;
        $this$setup_u24lambda_u241.LINE_COMMENT_AT_FIRST_COLUMN = false;
        SqlCodeStyleSettings $this$setup_u24lambda_u242 = sqlCodeStyleSettings = sql.getCorrespondedIndentOptions();
        boolean bl3 = false;
        $this$setup_u24lambda_u242.INDENT_SIZE = 4;
        $this$setup_u24lambda_u242.USE_TAB_CHARACTER = false;
    }

    static {
        INSTANCE.registerCustomSettings((CustomCodeStyleSettingsFactory)CSP.INSTANCE);
        INSTANCE.registerCommonSettings(CSP.INSTANCE);
        CustomCodeStyleSettings customCodeStyleSettings = INSTANCE.getCustomSettings(MsCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        MsCodeStyleSettings sql = (MsCodeStyleSettings)customCodeStyleSettings;
        sql.assignDefaults(INSTANCE.getBasePreset());
        INSTANCE.setup(sql);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/mssql/formatter/MsVsSqlCodeStyleScheme$CSP;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleProvider;", "()V", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getDefaultCommonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getDocCommentSettings", "Lcom/intellij/psi/codeStyle/DocCommentSettings;", "rootSettings", "getLanguage", "Lcom/intellij/lang/Language;", "getSupportedFields", "", "", "intellij.database.dialects.mssql"})
    private static final class CSP
    implements LanguageCodeStyleProvider {
        @NotNull
        public static final CSP INSTANCE = new CSP();

        private CSP() {
        }

        @NotNull
        public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return (CustomCodeStyleSettings)new MsCodeStyleSettings(settings);
        }

        @NotNull
        public Language getLanguage() {
            MsDialect msDialect = MsDialect.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)msDialect, (String)"INSTANCE");
            return (Language)msDialect;
        }

        @NotNull
        public CommonCodeStyleSettings getDefaultCommonSettings() {
            return new CommonCodeStyleSettings((Language)MsDialect.INSTANCE);
        }

        @NotNull
        public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
            Intrinsics.checkNotNullParameter((Object)rootSettings, (String)"rootSettings");
            DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
            Intrinsics.checkNotNullExpressionValue((Object)docCommentSettings, (String)"DEFAULTS");
            return docCommentSettings;
        }

        @NotNull
        public Set<String> getSupportedFields() {
            return SetsKt.emptySet();
        }
    }
}

