/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.mssql.MsDialectBase;
import com.intellij.sql.dialects.mssql.refactoring.MsBaseExtractVariableHelper;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsDialect
extends MsDialectBase {
    public static final MsDialect INSTANCE = new MsDialect();

    private MsDialect() {
        super("TSQL");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MSSQL;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return set;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        if (MsDialect.isQualifiedByLinkedServer(place)) {
            return type2 != ObjectKind.DATABASE;
        }
        return super.isResolveTargetNotAccepted(symbol, type2, expectedTypes, place, strict, isCompletion);
    }

    @Nullable
    public Condition<DasObject> getAdditionalExpandFilter(@NotNull SqlScopeProcessor processor2, @NotNull PsiElement place) {
        if (processor2 == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        if (place == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        if (MsDialect.isQualifiedByLinkedServer(place)) {
            return o2 -> o2.getKind() == ObjectKind.ROOT;
        }
        return super.getAdditionalExpandFilter(processor2, place);
    }

    private static boolean isQualifiedByLinkedServer(@Nullable PsiElement place) {
        SqlExpression qualifier = place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).getQualifierExpression() : null;
        DasSymbol qualifierSymbol = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolveSymbol() : null;
        return qualifierSymbol != null && qualifierSymbol.getKind() == ObjectKind.LINKED_SERVER;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return MsBaseExtractVariableHelper.MS_INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));

        LazyData() {
        }
    }
}

