/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.MongoJSLexerTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSLookAheadLexer;", "Lcom/intellij/lexer/LookAheadLexer;", "baseLexer", "Lcom/intellij/lexer/Lexer;", "types", "Lcom/intellij/sql/dialects/mongo/js/MongoJSLexerTypes;", "(Lcom/intellij/lexer/Lexer;Lcom/intellij/sql/dialects/mongo/js/MongoJSLexerTypes;)V", "isSpaceOrComment", "", "type", "Lcom/intellij/psi/tree/IElementType;", "isSqlTopKeyword", "text", "", "lookAhead", "", "lookAheadSqlSource", "tryProcessSqlPrefix", "isInitial", "intellij.database.dialects.mongo"})
public class MongoJSLookAheadLexer
extends LookAheadLexer {
    @NotNull
    private final MongoJSLexerTypes types;

    public MongoJSLookAheadLexer(@NotNull Lexer baseLexer, @NotNull MongoJSLexerTypes types2) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        Intrinsics.checkNotNullParameter((Object)types2, (String)"types");
        super(baseLexer);
        this.types = types2;
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        if (this.lookAheadSqlSource(baseLexer)) {
            return;
        }
        super.lookAhead(baseLexer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSqlTopKeyword(IElementType type2, String text2) {
        if (!Intrinsics.areEqual((Object)type2, (Object)this.types.getIdentifier())) return false;
        String string = text2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)"SELECT")) return false;
        return true;
    }

    private final boolean isSpaceOrComment(IElementType type2) {
        return Intrinsics.areEqual((Object)type2, (Object)this.types.getWhiteSpace()) || this.types.getComments().contains(type2);
    }

    private final boolean tryProcessSqlPrefix(Lexer baseLexer, boolean isInitial) {
        int initialCacheSize = this.getCacheSize();
        if (!isInitial) {
            this.addToken(baseLexer.getTokenStart(), this.types.getSqlSource());
        }
        IElementType iElementType = baseLexer.getTokenType();
        String string = baseLexer.getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        if (!this.isSqlTopKeyword(iElementType, string)) {
            return false;
        }
        this.advanceLexer(baseLexer);
        while (this.isSpaceOrComment(baseLexer.getTokenType())) {
            this.advanceLexer(baseLexer);
        }
        if (this.types.getBlockedFirstTypesAfterSqlTopKeyword().contains(baseLexer.getTokenType())) {
            return false;
        }
        this.resetCacheSize(initialCacheSize);
        return true;
    }

    private final boolean lookAheadSqlSource(Lexer baseLexer) {
        boolean isInitial = true;
        while (this.tryProcessSqlPrefix(baseLexer, isInitial)) {
            isInitial = false;
            while (baseLexer.getTokenType() != null && !Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getSemicolon())) {
                if (Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getIdentifier()) && Intrinsics.areEqual((Object)baseLexer.getTokenText(), (Object)"db")) {
                    int dbStartOffset = baseLexer.getTokenStart();
                    int dbEndOffset = baseLexer.getTokenEnd();
                    baseLexer.advance();
                    if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getDot())) continue;
                    this.addToken(dbStartOffset, this.types.getSqlSource());
                    this.addToken(dbEndOffset, this.types.getIdentifier());
                    return true;
                }
                baseLexer.advance();
            }
            if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getSemicolon())) continue;
            baseLexer.advance();
            while (this.isSpaceOrComment(baseLexer.getTokenType())) {
                baseLexer.advance();
            }
        }
        return !isInitial;
    }
}

