/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ES6Parser;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JSModifiersStructure;
import com.intellij.sql.dialects.mongo.js.JSParsingContextUtil;
import com.intellij.sql.dialects.mongo.js.JSPsiTypeParser;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import com.intellij.sql.dialects.mongo.js.StatementParser;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class JavaScriptParser {
    protected final PsiBuilder builder;
    protected ExpressionParser myExpressionParser;
    protected StatementParser myStatementParser;
    protected FunctionParser myFunctionParser;
    protected JSPsiTypeParser myTypeParser;

    public JavaScriptParser(PsiBuilder builder) {
        this.builder = builder;
        this.myExpressionParser = new ExpressionParser(this);
        this.myStatementParser = new StatementParser(this);
        this.myFunctionParser = new FunctionParser(this);
        this.myTypeParser = new JSPsiTypeParser(this);
    }

    public void parseJS(IElementType root2) {
        if (root2 == JSElementTypes.ARGUMENT_LIST) {
            PsiBuilder.Marker rootMarker = this.builder.mark();
            this.getExpressionParser().parseArgumentListNoParNoMarker(false);
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
            rootMarker.done(root2);
        } else if (root2 == JSElementTypes.OBJECT_LITERAL_EXPRESSION) {
            PsiBuilder.Marker rootMarker = this.builder.mark();
            if (this.builder.getTokenType() != JSElementTypes.LBRACE) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.lbrace", new Object[0]));
            } else {
                this.getExpressionParser().parseObjectLiteralExpression(false);
            }
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
            rootMarker.done(root2);
        } else {
            PsiBuilder.Marker rootMarker = this.builder.mark();
            JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
            if (forceContext != null) {
                if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                    this.builder.advanceLexer();
                } else {
                    if (forceContext == JavaScriptParserBase.ForceContext.TypeAllowEmpty && this.builder.eof()) {
                        rootMarker.done(root2);
                        return;
                    }
                    this.myTypeParser.parseType();
                }
                while (!this.builder.eof()) {
                    this.getStatementParser().parseStatement();
                }
            } else {
                this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)true);
                while (!this.builder.eof()) {
                    this.getStatementParser().parseSourceElement();
                }
            }
            rootMarker.done(root2);
        }
    }

    public ExpressionParser getExpressionParser() {
        return this.myExpressionParser;
    }

    public StatementParser getStatementParser() {
        return this.myStatementParser;
    }

    public FunctionParser getFunctionParser() {
        return this.myFunctionParser;
    }

    public JSPsiTypeParser getTypeParser() {
        return this.myTypeParser;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        return JSElementTypes.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public boolean isIdentifierName(IElementType firstToken) {
        return JSElementTypes.IDENTIFIER_NAMES.contains(firstToken);
    }

    public void buildTokenElement(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaScriptParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        marker.done(type2);
    }

    public boolean parseModifiers(@NotNull JSModifiersStructure structure, boolean dropIfEmpty, @NotNull Predicate<PsiBuilder> isPossibleStateAfterModifiers) {
        boolean lexerAdvanced;
        if (structure == null) {
            JavaScriptParser.$$$reportNull$$$0(1);
        }
        if (isPossibleStateAfterModifiers == null) {
            JavaScriptParser.$$$reportNull$$$0(2);
        }
        int offsetBefore = this.builder.getCurrentOffset();
        PsiBuilder.Marker attrList = this.builder.mark();
        this.getFunctionParser().tryParseES7Decorators();
        this.builder.putUserData(ES6Parser.ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.FALSE);
        this.myFunctionParser.setIsGenerator(false);
        boolean parsedSomething = structure.parseOptimistically(this.builder);
        if (parsedSomething && !isPossibleStateAfterModifiers.test(this.builder)) {
            attrList.rollbackTo();
            structure.resetContexts(this.builder);
            this.builder.putUserData(ES6Parser.ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.FALSE);
            this.myFunctionParser.setIsGenerator(false);
            attrList = this.builder.mark();
            this.getFunctionParser().tryParseES7Decorators();
            structure.parse(this.builder, isPossibleStateAfterModifiers);
        }
        boolean bl = lexerAdvanced = this.builder.getCurrentOffset() > offsetBefore;
        if (dropIfEmpty && !lexerAdvanced) {
            attrList.drop();
        } else {
            attrList.done(this.myFunctionParser.getAttributeListElementType());
        }
        return lexerAdvanced;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPossibleStateAfterModifiers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/mongo/js/JavaScriptParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTokenElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseModifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

