/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.DependentLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mongo.MongoSqlTokens;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoSqlDialect
extends SqlLanguageDialectBase
implements DependentLanguage {
    public static final MongoSqlDialect INSTANCE = new MongoSqlDialect();

    private MongoSqlDialect() {
        super("MongoDB");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(MongoSqlTokens.class);
        if (tokensHelper == null) {
            MongoSqlDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MONGO;
        if (dbms == null) {
            MongoSqlDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MongoSqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MongoSqlDialect.$$$reportNull$$$0(3);
        }
        if (place instanceof SqlReferenceExpression && type2 == SqlDbElementType.ANY && expectedTypes.contains(ObjectKind.COLUMN)) {
            PsiElement parent2 = place.getParent();
            while (parent2 instanceof SqlReferenceExpression) {
                ObjectKind parentKind = ((SqlReferenceExpression)parent2).getReferenceElementType().getTargetKind();
                if (parentKind == ObjectKind.COLUMN) {
                    return true;
                }
                parent2 = parent2.getParent();
            }
        }
        return super.isResolveTargetAccepted(symbol, type2, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type2) {
        T res2 = super.getParentDbTypes(result2, type2);
        if (type2 == ObjectKind.COLUMN) {
            res2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return res2;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean supportsNestedColumns() {
        return true;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "double", "double", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "string", "string", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "object", "object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "array", "array", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "binData", "binData", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "objectId", "objectId", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "bool", "bool", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "date", "date", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "regex", "regex", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "code", "code", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int", "int", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "timestamp", "timestamp", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "long", "long", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "decimal", "decimal", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "minKey", "minKey", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "maxKey", "maxKey", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "number", "number", (SqlLanguageDialectEx)this);
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;

        LazyData() {
        }
    }
}

