/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.database.dialects.cassandra.types.CassMapType;
import com.intellij.database.dialects.cassandra.types.CassSetType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlCollectionLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassSetOrMapLiteral
extends SqlCollectionLiteralExpressionImpl {
    public CassSetOrMapLiteral(@NotNull IElementType elementType) {
        if (elementType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof SqlSetAssignment) {
                SqlSetAssignment setAssignment = (SqlSetAssignment)child;
                SqlElement lValue = setAssignment.getLValue();
                if (lValue instanceof SqlReferenceExpression) {
                    return this.getSqlTableType();
                }
                DasType dasType = CassSetOrMapLiteral.getMapType(lValue, setAssignment.getRValue());
                if (dasType == null) {
                    CassSetOrMapLiteral.$$$reportNull$$$0(1);
                }
                return dasType;
            }
            if (!(child instanceof SqlExpression)) continue;
            SqlExpression expr = (SqlExpression)child;
            return new CassSetType(expr.getDasType());
        }
        return new SqlTableTypeBase.Empty();
    }

    private static DasType getMapType(@NotNull SqlElement lValue, @Nullable SqlElement rValue) {
        DasType dasType;
        DasBuiltinType<?> keyDasType;
        if (lValue == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(2);
        }
        if (lValue instanceof SqlExpression) {
            SqlExpression expr = (SqlExpression)lValue;
            v0 = expr.getDasType();
        } else {
            v0 = keyDasType = DasTypeSystemBase.UNKNOWN;
        }
        if (rValue instanceof SqlExpression) {
            SqlExpression expr = (SqlExpression)rValue;
            dasType = expr.getDasType();
        } else {
            dasType = DasTypeSystemBase.UNKNOWN;
        }
        DasBuiltinType<?> valueDasType = dasType;
        return new CassMapType(keyDasType, valueDasType);
    }

    @NotNull
    private SqlTableType getSqlTableType() {
        ArrayList<SqlImplUtil.Column> columns2 = new ArrayList<SqlImplUtil.Column>();
        SqlSetAssignment[] mapElements = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlSetAssignment.class);
        if (mapElements == null) {
            return new SqlTableTypeBase.Empty();
        }
        for (SqlSetAssignment element2 : mapElements) {
            SqlElement rValue = element2.getRValue();
            if (rValue == null) {
                return new SqlTableTypeBase.Empty();
            }
            DasBuiltinType<?> dasType = rValue instanceof SqlExpression ? ((SqlExpression)rValue).getDasType() : DasTypeSystemBase.UNKNOWN;
            columns2.add(new SqlImplUtil.Column(element2.getLValue().getName(), dasType, (PsiElement)rValue, null));
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, columns2, (PsiElement)this);
        if (sqlTableType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(3);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMapType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

