/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.SqlDialects;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectsConfigurable
extends PerFileConfigurableBase<SqlLanguageDialect> {
    private final PerFileConfigurableBase.Mapping<SqlLanguageDialect> myGlobalMapping;

    public SqlDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappingsEx)SqlDialectMappings.getInstance(project));
        this.myGlobalMapping = new PerFileConfigurableBase.Mapping(SqlBundle.message((String)"global.sql.dialect.setting.text", (Object[])new Object[0]), () -> SqlDialectMappings.getConfiguredDefaultSqlDialect(), o2 -> SqlDialectMappings.setDefaultSqlDialect(o2));
    }

    protected boolean isGlobalMapping(PerFileConfigurableBase.Mapping<SqlLanguageDialect> prop) {
        return prop == this.myGlobalMapping || super.isGlobalMapping(prop);
    }

    @Nls
    public String getDisplayName() {
        return SqlBundle.message((String)"sql.dialects.configurable", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.dialects";
    }

    protected void renderValue(@Nullable Object target2, @NotNull SqlLanguageDialect dialect, @NotNull ColoredTextContainer renderer2) {
        if (dialect == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(1);
        }
        if (renderer2 == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(2);
        }
        renderer2.append(dialect.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected <S> Object getParameter(@NotNull Key<S> key2) {
        if (key2 == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(3);
        }
        if (key2 == DESCRIPTION) {
            return SqlBundle.message((String)"dialog.sql.dialects.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), StringUtil.escapeXmlEntities((String)SqlDialects.getGenericDialect().getDisplayName())});
        }
        if (key2 == MAPPING_TITLE) {
            return SqlBundle.message((String)"dialog.sql.dialects.value.title", (Object[])new Object[0]);
        }
        if (key2 == OVERRIDE_QUESTION) {
            return SqlBundle.message((String)"dialog.sql.dialects.override.question", (Object[])new Object[0]);
        }
        if (key2 == OVERRIDE_TITLE) {
            return SqlBundle.message((String)"dialog.sql.dialects.override.title", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    protected List<PerFileConfigurableBase.Mapping<SqlLanguageDialect>> getDefaultMappings() {
        List<PerFileConfigurableBase.Mapping<SqlLanguageDialect>> list = Collections.singletonList(this.myGlobalMapping);
        if (list == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void renderDefaultValue(Object target2, @NotNull ColoredTextContainer renderer2) {
        SqlLanguageDialect t;
        if (renderer2 == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(5);
        }
        if ((t = (SqlLanguageDialect)this.getNewMapping((VirtualFile)target2)) == null) {
            return;
        }
        renderer2.append(t.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    @Nullable
    protected SqlLanguageDialect getDefaultNewMapping(@Nullable VirtualFile file) {
        SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file), SqlLanguageDialect.class);
        return dialect == null ? (SqlLanguageDialect)this.myMappings.getDefaultMapping(file) : dialect;
    }

    public static void openDialectsConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(6);
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }

    public static void openDialectsConfigurable(@NotNull Project project, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(8);
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            for (VirtualFile root2 : files2) {
                configurable.selectFile(root2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderDefaultValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openDialectsConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

