/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDialectToolbarAction
extends ActionGroup
implements DumbAware {
    public ChangeDialectToolbarAction() {
        this.setPopup(true);
        this.getTemplatePresentation().setPerformGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
        if (AnAction.EMPTY_ARRAY == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(1);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        Project project = e2.getProject();
        Condition<VirtualFile> condition2 = project == null ? null : ChangeDialectAction.FILE_FILTER(project);
        VirtualFile file = project != null && psiFile != null ? psiFile.getVirtualFile() : null;
        boolean isSqlFile = file != null && condition2.value((Object)file);
        boolean isConsole = file != null && DbVFSUtils.isConsoleFile(file);
        Presentation presentation = e2.getPresentation();
        boolean notMenuOrSearch = !ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace());
        boolean enabledAndVisible = notMenuOrSearch && isSqlFile && !isConsole && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsole.findConsole(e2) == null;
        presentation.setEnabledAndVisible(enabledAndVisible);
        if (!enabledAndVisible) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((PsiElement)psiFile);
        presentation.setText(dialect == null ? DatabaseBundle.message("ChangeDialectToolbarAction.action.dialect.text", new Object[0]) : dialect.getDisplayName());
        presentation.setDescription(DatabaseBundle.message("ChangeDialectToolbarAction.action.change.sql.dialect.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        JComponent button;
        VirtualFile virtualFile;
        if (e2 == null) {
            ChangeDialectToolbarAction.$$$reportNull$$$0(3);
        }
        PsiFile file = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        Project project = e2.getProject();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : file.getVirtualFile();
        if (virtualFile == null || project == null) {
            return;
        }
        ListPopup popup2 = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile), "");
        InputEvent inputEvent = e2.getInputEvent();
        JComponent jComponent = button = inputEvent == null ? null : (JComponent)ObjectUtils.tryCast((Object)inputEvent.getSource(), JComponent.class);
        if (button == null) {
            popup2.showInBestPositionFor(e2.getDataContext());
            return;
        }
        popup2.showUnderneathOf((Component)button);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/ChangeDialectToolbarAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/ChangeDialectToolbarAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

