/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTxModelWrapper {
    private final BasicModModel myTarget;
    private final BasicModModel myScapeGoat;
    private final BasicMetaModel<?> myMetaModel;
    private final Map<ObjectKind, BasicModElement> myEmptyParents;
    private final Map<DasObject, BasicElement> mySourceMapping;
    private final Set<BasicElement> myDirty;
    private final DatabaseDialectEx myDialect;
    private final boolean mySaveSources;

    public SqlTxModelWrapper(@NotNull BasicModModel target2, @NotNull Map<DasObject, BasicElement> mapping, boolean saveSources) {
        if (target2 == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(0);
        }
        if (mapping == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(1);
        }
        this.myEmptyParents = new HashMap<ObjectKind, BasicModElement>();
        this.myDirty = new LinkedHashSet<BasicElement>();
        this.myTarget = target2;
        this.mySourceMapping = mapping;
        this.mySaveSources = saveSources;
        this.myScapeGoat = new ModelFactory(this.mySaveSources ? new MemoryTextStorage() : BlackHoleTextStorage.INSTANCE).createModel(((BasicMetaModel)this.myTarget.getMetaModel()).dbms);
        this.myScapeGoat.addListener((created2, modified, removed) -> this.myDirty.addAll(created2));
        Dbms family = this.myTarget.getDbms();
        this.myDialect = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DatabaseDialects.findByDbms(family), (Object)DatabaseDialects.getGenericDialect());
        this.myMetaModel = target2.getMetaModel();
        ((BasicModRoot)this.myTarget.getRoot()).setDefaultCasing(this.myDialect.getCasing(ObjectKind.NONE, null));
    }

    boolean withSources() {
        return this.mySaveSources;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myTarget.getDbms();
        if (dbms == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(3);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Iterable<BasicElement> getDirty() {
        Set<BasicElement> set = this.myDirty;
        if (set == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void apply() {
        new ModelApplier.TopDown(this.myDirty, this.mySaveSources).apply(this.myScapeGoat.getRoot(), (BasicModElement)((Object)this.myTarget.getRoot()));
        this.myDirty.clear();
    }

    public MetaModel getMetaModel() {
        return this.myMetaModel;
    }

    public void modify(Runnable r) {
        this.myScapeGoat.modify(BasicModRoot.class, x -> r.run());
    }

    @NotNull
    private static BasicModElement findRecipient(@NotNull ModFamily<?> target2, @NotNull BasicElement child) {
        String name2;
        boolean unnamed;
        if (target2 == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(5);
        }
        if (child == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(6);
        }
        boolean empty2 = (unnamed = StringUtil.isEmpty((String)(name2 = child.getName()))) && !(child instanceof BasicNamespace);
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)BasicMixinElement.getCasingProvider(child), (Object)DasUtil.NO_CASING_PROVIDER);
        String id = unnamed && !(child instanceof BasicArrangedElement) ? null : BasicPaths.getIdentity(child);
        Condition c2 = DbSqlUtilCore.byName(name2, DbSqlUtilCore.isQuoted(child), id, casingProvider);
        BasicModElement e2 = target2.find(x -> (!empty2 || x.isSyncPending()) && c2.value(x));
        if (e2 != null) {
            e2.resetSyncPending();
            BasicModElement basicModElement = e2;
            if (basicModElement == null) {
                SqlTxModelWrapper.$$$reportNull$$$0(7);
            }
            return basicModElement;
        }
        Object object = target2 instanceof ModSingletonFamily ? ((ModSingletonFamily)target2).createOrGet() : target2.createNewOne();
        if (object == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    public BasicModElement getRoot() {
        BasicModElement basicModElement = (BasicModElement)((Object)this.myScapeGoat.getRoot());
        if (basicModElement == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(9);
        }
        return basicModElement;
    }

    @Nullable
    public BasicModElement createEmptyChild(@Nullable BasicModElement parent2, @NotNull ObjectKind kind) {
        Family family;
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(10);
        }
        if (parent2 == null) {
            if (!this.isRootChild(kind)) {
                return null;
            }
            parent2 = this.getRoot();
        }
        if ((family = parent2.familyOf(kind)) == null) {
            return null;
        }
        BasicModElement element2 = (BasicModElement)family.jbi().filter(DasUtil.byName(DasUtil.NO_NAME)).first();
        if (element2 != null) {
            return element2;
        }
        element2 = family.createNewOne();
        return element2;
    }

    protected boolean isRootChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(11);
        }
        return BasicMetaUtils.findChild(this.myMetaModel.root, kind) != null;
    }

    @Nullable
    public BasicModElement getProcessed(@NotNull DasObject object) {
        BasicElement element2;
        if (object == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(12);
        }
        if ((element2 = this.mySourceMapping.get(object)) == null) {
            return null;
        }
        return new ModelApplier.BottomUp(this.getRoot(), this.mySaveSources).copy(element2);
    }

    @Nullable
    public BasicModElement createOrGet(@NotNull DasObject object, @Nullable BasicModElement parent2, @NotNull ObjectPath path, @NotNull ObjectKind kind) {
        if (object == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(13);
        }
        if (path == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(15);
        }
        if (parent2 == null) {
            if (!this.isRootChild(kind)) {
                return null;
            }
            parent2 = this.getRoot();
        } else assert (parent2.getModel() == this.getRoot().getModel());
        BasicModElement obj2 = this.getProcessed(object);
        if (obj2 != null) {
            boolean valid = obj2.getParent() == parent2;
            valid &= obj2.isSyncPending();
            valid &= !obj2.isDropped();
            if (valid &= obj2.getKind() == path.kind) {
                obj2.resetSyncPending();
                if (obj2 instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj2).setName(path.name);
                }
            } else {
                obj2 = null;
            }
        }
        if (obj2 == null) {
            obj2 = SqlModelBuilderUtils.createObject(parent2, path.name, path.isQuoted(), path.getIdentity(), kind);
        }
        ContainerUtil.addIfNotNull(this.myDirty, (Object)obj2);
        return obj2;
    }

    @Nullable
    public BasicModElement getEmptyParent(@NotNull ObjectKind kind) {
        BasicModElement element2;
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(16);
        }
        if ((element2 = this.myEmptyParents.get(kind)) != null) {
            return this.nullize(element2);
        }
        List path = (List)this.myMetaModel.getPathsToRoot(kind).first();
        if (ContainerUtil.isEmpty((Collection)path)) {
            return null;
        }
        if (kind != path.get(0)) {
            SqlModelBuilderUtils.hardWarning("Path not started with " + kind.code());
        }
        return this.getEmptyParent(path, 0);
    }

    @Nullable
    private BasicModElement getEmptyParent(@NotNull List<ObjectKind> path, int idx) {
        if (path == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(17);
        }
        if (idx + 1 >= path.size()) {
            return null;
        }
        ObjectKind kind = path.get(idx);
        BasicModElement element2 = this.myEmptyParents.get(kind);
        if (element2 != null) {
            return this.nullize(element2);
        }
        BasicModElement grandParent = this.getEmptyParent(path, idx + 1);
        element2 = this.createEmptyChild(grandParent, path.get(idx + 1));
        return this.putEmptyParent(kind, element2);
    }

    @Nullable
    private BasicModElement putEmptyParent(@NotNull ObjectKind kind, @Nullable BasicModElement parent2) {
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(18);
        }
        this.myEmptyParents.put(kind, this.notNullize(parent2));
        return parent2;
    }

    @NotNull
    public BasicModElement notNullize(@Nullable BasicModElement elem) {
        BasicModElement basicModElement = elem == null ? this.getRoot() : elem;
        if (basicModElement == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(19);
        }
        return basicModElement;
    }

    @Nullable
    public BasicModElement nullize(@Nullable BasicModElement elem) {
        return elem == this.getRoot() ? null : elem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8, 9, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlTxModelWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRecipient";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRecipient";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRootChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProcessed";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createOrGet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyParent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putEmptyParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8, 9, 19 -> new IllegalStateException(string);
        };
    }

    private static class ModelApplier {
        private ModelApplier() {
        }

        public static class BottomUp
        extends ModelApplier {
            private final BasicModElement myTargetRoot;
            private final boolean myWithSources;

            public BottomUp(@NotNull BasicModElement root2, boolean withSources) {
                if (root2 == null) {
                    BottomUp.$$$reportNull$$$0(0);
                }
                this.myTargetRoot = root2;
                this.myWithSources = withSources;
            }

            @Nullable
            private BasicModElement copy(@NotNull BasicElement element2) {
                if (element2 == null) {
                    BottomUp.$$$reportNull$$$0(1);
                }
                if (((BasicModElement)element2).isSyncPending()) {
                    return null;
                }
                if (element2.getKind() == ObjectKind.ROOT) {
                    return this.myTargetRoot;
                }
                BasicModElement copied = this.copy(Objects.requireNonNull(element2.getParent()));
                if (BottomUp.needsFullCopy(element2)) {
                    BasicModElement res2 = null;
                    Iterator iterator = Objects.requireNonNull(element2.getParentFamily()).iterator();
                    while (iterator.hasNext()) {
                        BasicElement e2;
                        BasicModElement c2 = this.copySingle(e2, copied, element2 != (e2 = (BasicElement)iterator.next()));
                        if (element2 != e2) continue;
                        res2 = c2;
                    }
                    return res2;
                }
                return this.copySingle(element2, copied, false);
            }

            private static boolean needsFullCopy(@NotNull BasicElement element2) {
                if (element2 == null) {
                    BottomUp.$$$reportNull$$$0(2);
                }
                return element2 instanceof BasicConstraint;
            }

            @Nullable
            private BasicModElement copySingle(@NotNull BasicElement element2, @Nullable BasicModElement parent2, boolean weak) {
                Family family;
                if (element2 == null) {
                    BottomUp.$$$reportNull$$$0(3);
                }
                Family family2 = family = parent2 == null ? null : parent2.familyOf(element2.getKind());
                if (family == null) {
                    return null;
                }
                BasicModElement recipient = (BasicModElement)ModelUtil.findObject(family, element2);
                if (recipient == null) {
                    recipient = this.createRecipient(element2, (ModFamily<?>)family);
                    recipient.setSyncPending(true);
                }
                ModelLightCopier.copyProperties(element2, recipient, this.myWithSources, true);
                return recipient;
            }

            @NotNull
            private BasicModElement createRecipient(@NotNull BasicElement element2, ModFamily<?> family) {
                if (element2 == null) {
                    BottomUp.$$$reportNull$$$0(4);
                }
                Object recipient = family.createNewOne();
                if (element2 instanceof BasicOverloadable) {
                    for (BasicElement child : element2.getChildren()) {
                        this.copySingle(child, (BasicModElement)recipient, false);
                    }
                }
                Object obj2 = recipient;
                if (obj2 == null) {
                    BottomUp.$$$reportNull$$$0(5);
                }
                return obj2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$BottomUp";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$BottomUp";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createRecipient";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "copy";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "needsFullCopy";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "copySingle";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createRecipient";
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5 -> new IllegalStateException(string);
                };
            }
        }

        public static class TopDown
        extends ModelApplier {
            private final Set<BasicElement> myDirty;
            private final Set<BasicElement> myWorkSet;
            private final boolean myWithSources;

            public TopDown(@NotNull Set<BasicElement> dirty, boolean withSources) {
                if (dirty == null) {
                    TopDown.$$$reportNull$$$0(0);
                }
                this.myDirty = dirty;
                this.myWorkSet = new HashSet<BasicElement>();
                this.myWithSources = withSources;
                for (BasicElement element2 : dirty) {
                    for (element2 = element2.getParent(); element2 != null && !dirty.contains(element2) && this.myWorkSet.add(element2); element2 = element2.getParent()) {
                    }
                }
            }

            public void apply(@NotNull BasicElement source, @NotNull BasicModElement target2) {
                if (source == null) {
                    TopDown.$$$reportNull$$$0(1);
                }
                if (target2 == null) {
                    TopDown.$$$reportNull$$$0(2);
                }
                new TwoModelVisitor(){

                    @Override
                    public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                        if (guide == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (guided == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (myDirty.contains(guide)) {
                            ModelLightCopier.copyProperties(guide, (BasicModElement)guided, false, true);
                        }
                        if (!(guided instanceof BasicNamespace) && !(guided instanceof BasicRoot)) {
                            ((BasicModElement)guided).getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                        }
                        super.visit(guide, guided);
                        if (myWithSources) {
                            BasicMetaUtils.copySources(guide, (BasicModElement)guided, true);
                        }
                    }

                    @Override
                    @Nullable
                    public BasicElement find(@NotNull Family<?> guided, @NotNull BasicElement guide) {
                        if (guided == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (guide == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (((BasicModElement)guide).isSyncPending() || !myWorkSet.contains(guide) && !myDirty.contains(guide)) {
                            return null;
                        }
                        BasicModElement recipient = SqlTxModelWrapper.findRecipient((ModFamily)guided, guide);
                        return recipient;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "guide";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "guided";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$TopDown$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visit";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "find";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.visit(source, target2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dirty";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$TopDown";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class TwoModelVisitor {
        public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(0);
            }
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(1);
            }
            for (Family<? extends BasicElement> family : guide.getFamilies()) {
                Family<? extends BasicElement> targetFamily;
                if (family.isEmpty() || (targetFamily = guided.familyOf(family.first().getKind())) == null) continue;
                this.visit(family, targetFamily);
            }
        }

        public void visit(@NotNull Family<?> guide, @NotNull Family<?> guided) {
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(2);
            }
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(3);
            }
            for (BasicElement child : guide) {
                BasicElement element2 = this.find(guided, child);
                if (element2 == null) continue;
                this.visit(child, element2);
            }
        }

        @Nullable
        public BasicElement find(@NotNull Family<?> guided, @NotNull BasicElement guide) {
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(4);
            }
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(5);
            }
            return ModelUtil.findObject(guided, guide);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guide";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guided";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$TwoModelVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

