/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceManager;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.TimeoutUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlDataSourceIntrospector {
    private static int ourSyncTimeout = 2000;
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(SqlDataSourceIntrospector.class);
    private final SqlDataSourceImpl myDataSource;
    private volatile ModelFactory myModelFactory;
    private long myFilesRevision;
    private long myNonFilesRevision;

    @TestOnly
    public static void setSyncTimeout(int timeout, @NotNull Disposable parent2) {
        if (parent2 == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(0);
        }
        int prev = ourSyncTimeout;
        ourSyncTimeout = timeout;
        Disposer.register((Disposable)parent2, () -> {
            if (timeout != ourSyncTimeout) {
                throw new AssertionError((Object)"Timeout revert failed");
            }
            ourSyncTimeout = prev;
        });
    }

    public SqlDataSourceIntrospector(@NotNull SqlDataSourceImpl dataSource2) {
        if (dataSource2 == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(1);
        }
        this.myDataSource = dataSource2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDataSource.getProject();
        if (project == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(2);
        }
        return project;
    }

    public long getFilesRevision() {
        return this.myFilesRevision;
    }

    public long getNonFilesRevision() {
        return this.myNonFilesRevision;
    }

    public void compute(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(3);
        }
        boolean done = false;
        while (!done) {
            if (this.getProject().isDisposed()) {
                return;
            }
            done = this.introspect(indicator);
            indicator.checkCanceled();
        }
    }

    private BasicModModel ensureProperModel(@NotNull Dbms dbms) {
        BasicModModel model2;
        if (dbms == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(4);
        }
        if ((model2 = this.myDataSource.getModelInner()) == null || model2.getMetaModel() != DbImplUtilCore.getMetaModel(dbms)) {
            if (model2 != null) {
                model2.shelve(true);
            }
            model2 = this.myModelFactory.createModel(dbms);
            this.myDataSource.setModel(model2);
        }
        return model2;
    }

    protected Pair<SqlFile, Long> introspectPortion(SqlModelBuilder builder, @Nullable Pair<SqlFile, Long> prev) {
        Pair incomplete;
        List<SqlFile> files2 = this.myDataSource.getSqlFiles();
        int doneIdx = this.validateAndGetPortionStart(builder, prev, files2);
        int fromIdx = doneIdx + 1;
        try {
            fromIdx = builder.introspect(files2, fromIdx, fromIdx == 0, ourSyncTimeout);
            SqlFile done = files2.isEmpty() ? null : files2.get(fromIdx - 1);
            incomplete = done == null ? null : Pair.create((Object)done, (Object)SqlDataSourceIntrospector.getPartialVersion(files2, done));
            this.myDataSource.update(builder.getMapping());
            if (fromIdx == files2.size()) {
                incomplete = null;
            }
            builder.trace("applied");
        }
        catch (ProcessCanceledException pce) {
            builder.trace("cancelled");
            throw pce;
        }
        catch (RuntimeException pce) {
            builder.trace("failed: " + pce.getMessage());
            throw pce;
        }
        return incomplete;
    }

    private int validateAndGetPortionStart(SqlModelBuilder builder, @Nullable Pair<SqlFile, Long> prev, List<SqlFile> files2) {
        if (prev == null || prev.first == null) {
            return -1;
        }
        int doneIdx = files2.indexOf(prev.first);
        long fileModCount = this.myDataSource.getFileModCount();
        if (this.myFilesRevision == fileModCount || doneIdx == -1) {
            return doneIdx;
        }
        this.myFilesRevision = fileModCount;
        if (SqlDataSourceIntrospector.getPartialVersion(files2, (SqlFile)prev.first) == (Long)prev.second) {
            builder.trace("Files modified, but processed files are not affected");
            return doneIdx;
        }
        builder.trace("Files modified, restarting");
        doneIdx = -1;
        builder.end();
        builder.begin(SqlDataSourceIntrospector.isWithSource(builder.getModel()));
        return doneIdx;
    }

    protected boolean introspect(@NotNull ProgressIndicator indicator) {
        Boolean res2;
        if (indicator == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(5);
        }
        this.myFilesRevision = this.myDataSource.getFileModCount();
        this.myNonFilesRevision = this.myDataSource.getNonFileModCount();
        indicator.setText(SqlBundle.message((String)"progress.text.building", (Object[])new Object[]{this.myDataSource.getName()}));
        Ref incomplete = Ref.create((Object)Pair.create(null, null));
        while ((res2 = this.introspect2(indicator, (Ref<Pair<SqlFile, Long>>)incomplete)) == null) {
            ProgressManager.checkCanceled();
            TimeoutUtil.sleep((long)100L);
        }
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean introspect2(@NotNull ProgressIndicator indicator, Ref<Pair<SqlFile, Long>> incomplete) {
        if (indicator == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(6);
        }
        Project project = this.getProject();
        Logger logger2 = DatabaseGlobalAuditService.logger(project, this.myDataSource, null);
        BasicModModel model2 = this.ensureProperModel();
        SqlModelBuilder builder = new SqlModelBuilder(project, model2, this.myDataSource.getElements(), logger2);
        try {
            builder.begin(SqlDataSourceIntrospector.isWithSource(model2));
            while (!incomplete.isNull()) {
                indicator.checkCanceled();
                if (this.myNonFilesRevision != this.myDataSource.getNonFileModCount()) {
                    logger2.warning("Version mismatch, restarting");
                    Boolean bl = false;
                    return bl;
                }
                SensitiveProgressWrapper subIndicator = new SensitiveProgressWrapper(indicator);
                subIndicator.setIndeterminate(false);
                Ref error2 = Ref.create();
                boolean ok2 = ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
                    try {
                        incomplete.set(this.introspectPortion(builder, (Pair<SqlFile, Long>)((Pair)incomplete.get())));
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (Throwable th) {
                        error2.set((Object)th);
                    }
                }, (ProgressIndicator)subIndicator);
                if (!error2.isNull()) {
                    LOG.error((Throwable)error2.get());
                    logger2.log(Level.SEVERE, "Failed", (Throwable)error2.get());
                    this.changed();
                    Boolean bl = true;
                    return bl;
                }
                if (ok2) {
                    logger2.fine("Finished portion");
                } else {
                    logger2.warning("Aborted by write action, retrying");
                }
                if (!ok2) {
                    Boolean bl = null;
                    return bl;
                }
                if (incomplete.isNull()) continue;
                this.changed();
            }
        }
        catch (ProcessCanceledException pce) {
            indicator.setText2(SqlBundle.message((String)"progress.details.interrupted", (Object[])new Object[0]));
            Boolean bl = false;
            return bl;
        }
        finally {
            builder.end();
        }
        return true;
    }

    public BasicModModel ensureProperModel() {
        Ref dbms = Ref.create();
        ReadAction.run(() -> {
            if (this.myDataSource.getProject().isDisposed()) {
                return;
            }
            dbms.set((Object)this.myDataSource.getDbms());
        });
        if (dbms.isNull()) {
            dbms.set((Object)Dbms.UNKNOWN);
        }
        return this.ensureProperModel((Dbms)dbms.get());
    }

    public void setModelFactory(ModelFactory factory) {
        this.myModelFactory = factory;
    }

    private static boolean isWithSource(BasicModModel model2) {
        ModelTextStorage storage = model2.getTextStorage();
        return storage != BlackHoleTextStorage.INSTANCE;
    }

    protected void changed() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            ((DataSourceManager.Listener)project.getMessageBus().syncPublisher(DataSourceManager.TOPIC)).dataSourceChanged(SqlDataSourceManager.getInstance(project), this.myDataSource);
        }, ModalityState.nonModal());
    }

    private static long getPartialVersion(@NotNull Iterable<? extends PsiFile> files2, @Nullable SqlFile latest) {
        if (files2 == null) {
            SqlDataSourceIntrospector.$$$reportNull$$$0(7);
        }
        long result2 = 0L;
        for (PsiFile psiFile : files2) {
            result2 = result2 * 31L + psiFile.getModificationStamp();
            if (psiFile != latest) continue;
            break;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceIntrospector";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceIntrospector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSyncTimeout";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureProperModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "introspect2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPartialVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

