/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent;
import com.intellij.database.dataSource.ui.DriverInstantiateComponent;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/database/SqlDataSourceDialectComponent;", "", "configurable", "Lcom/intellij/sql/database/SqlDataSourceConfigurable;", "(Lcom/intellij/sql/database/SqlDataSourceConfigurable;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getConfigurable", "()Lcom/intellij/sql/database/SqlDataSourceConfigurable;", "dialectIcon", "Ljavax/swing/JLabel;", "dialectLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "chooseDialect", "", "update", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDataSourceDialectComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDataSourceDialectComponent.kt\ncom/intellij/sql/database/SqlDataSourceDialectComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1045#2:66\n*S KotlinDebug\n*F\n+ 1 SqlDataSourceDialectComponent.kt\ncom/intellij/sql/database/SqlDataSourceDialectComponent\n*L\n46#1:66\n*E\n"})
public final class SqlDataSourceDialectComponent {
    @NotNull
    private final SqlDataSourceConfigurable configurable;
    @NotNull
    private final JComponent component;
    private LinkLabel<Object> dialectLink;
    private JLabel dialectIcon;

    public SqlDataSourceDialectComponent(@NotNull SqlDataSourceConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        this.component = (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        ActionToolbar actionToolbar;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DatabaseBundle.message("database.driver.settings.options.dialect.label", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string).gap(RightGap.SMALL);
                        dialectIcon = (JLabel)$this$row.label("").gap(RightGap.SMALL).getComponent();
                        dialectLink = (LinkLabel)$this$row.cell((JComponent)((Object)new DataSourceTestConnectionComponent.GrayLabel("", null, (LinkListener<Object>)((LinkListener)(arg_0, arg_1) -> 1.invoke$lambda$0(this, arg_0, arg_1))))).getComponent();
                        DefaultActionGroup group2 = new DefaultActionGroup();
                        AnAction anAction = this.getConfigurable().getController().createResetAction(this.getConfigurable());
                        if (anAction != null) {
                            AnAction it2 = anAction;
                            boolean bl = false;
                            group2.add(it2);
                        }
                        ActionToolbar $this$invoke_u24lambda_u242 = actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group2, true);
                        boolean bl = false;
                        $this$invoke_u24lambda_u242.setMiniMode(true);
                        $this$invoke_u24lambda_u242.setTargetComponent($this$invoke_u24lambda_u242.getComponent());
                        ActionToolbar actionToolbar2 = actionToolbar;
                        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
                        ActionToolbar toolbar2 = actionToolbar2;
                        $this$row.cell(toolbar2.getComponent()).align((Align)AlignX.RIGHT.INSTANCE);
                    }

                    private static final void invoke$lambda$0(SqlDataSourceDialectComponent this$0, LinkLabel linkLabel, Object object) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.chooseDialect();
                    }
                }), (int)1, null);
            }
        }));
        ((DialogPanel)this.component).setBorder(DriverInstantiateComponent.Companion.getTopPanelBorder());
    }

    @NotNull
    public final SqlDataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final void chooseDialect() {
        DefaultActionGroup actions = new DefaultActionGroup();
        Collection<Dbms> collection2 = Dbms.allValues();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"allValues(...)");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        for (Dbms dbms : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                Dbms it2 = (Dbms)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it2.getDisplayName());
                it2 = (Dbms)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getDisplayName())));
            }
        })) {
            String string = dbms.getDisplayName();
            Icon icon = dbms.getIcon();
            actions.add(new AnAction(this, dbms, string, icon){
                final /* synthetic */ SqlDataSourceDialectComponent this$0;
                final /* synthetic */ Dbms $dbms;
                {
                    this.this$0 = $receiver;
                    this.$dbms = $dbms;
                    super($super_call_param$1, null, $super_call_param$2);
                }

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                    this.this$0.getConfigurable().setCurrentDbms(this.$dbms);
                }
            });
        }
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        String string = DatabaseBundle.message("popup.title.set.dialect", new Object[0]);
        ActionGroup actionGroup = (ActionGroup)actions;
        DataManager dataManager = DataManager.getInstance();
        LinkLabel<Object> linkLabel = this.dialectLink;
        if (linkLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialectLink");
            linkLabel = null;
        }
        ListPopup listPopup = jBPopupFactory.createActionGroupPopup(string, actionGroup, dataManager.getDataContext((Component)linkLabel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        LinkLabel<Object> linkLabel2 = this.dialectLink;
        if (linkLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialectLink");
            linkLabel2 = null;
        }
        listPopup.showUnderneathOf((Component)linkLabel2);
    }

    public final void update() {
        Dbms dbms = this.configurable.getCurrentDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getCurrentDbms(...)");
        Dbms dbms2 = dbms;
        LinkLabel<Object> linkLabel = this.dialectLink;
        if (linkLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialectLink");
            linkLabel = null;
        }
        linkLabel.setText(dbms2.getDisplayName());
        JLabel jLabel = this.dialectIcon;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialectIcon");
            jLabel = null;
        }
        jLabel.setIcon(dbms2.getIcon());
    }
}

