/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.completion.providers.SqlFunctionDefinitionCompletions;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReferenceExpressionCompletionProvider
extends SqlCompletionProviderBase {
    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        LookupElement element3;
        Object ktt;
        SqlReferenceImpl sqlRef;
        ObjectKind inDefinitionNameKind;
        PsiElement parent2;
        SqlExpression expression;
        PsiElement prevLeaf2;
        block17: {
            block16: {
                PsiElement position;
                if (parameters2 == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(2);
                }
                if ((position = parameters2.getPosition()).getParent() instanceof PsiErrorElement) {
                    return;
                }
                prevLeaf2 = SqlCompletionUtil.getNonWSPrecedingLeaf(position);
                if (prevLeaf2 instanceof PsiErrorElement && ((PsiErrorElement)prevLeaf2).getErrorDescription().endsWith(" expected, got '" + position.getText() + "'")) {
                    return;
                }
                expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                if (expression == null) {
                    return;
                }
                if (PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression) instanceof PsiErrorElement) {
                    return;
                }
                parent2 = expression.getParent();
                inDefinitionNameKind = parent2 instanceof SqlDefinition && !(parent2 instanceof SqlRenameToClause) && ((SqlDefinition)parent2).getNameElement() == expression ? ((SqlDefinition)parent2).getKind() : null;
                PsiReference ref2 = expression.getReference();
                if (!(ref2 instanceof SqlReferenceImpl)) break block16;
                sqlRef = (SqlReferenceImpl)ref2;
                if (!SqlPsiMiscUtil.isJoinUsingColumn(position)) break block17;
            }
            return;
        }
        Set strictExpectedTargetTypes = inDefinitionNameKind != null ? sqlRef.getExpectedTargetTypes(false, true) : Collections.emptySet();
        Project project = expression.getProject();
        SqlReferenceElementType refType = sqlRef.getReferenceElementType();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)expression);
        NamingService namingService2 = NamingServices.getNamingService(dbms);
        Set columnsNamesFromSelectForTableRef = CollectionFactory.createCaseInsensitiveStringSet();
        Set columnsNamesFromSelectForColumnRef = CollectionFactory.createCaseInsensitiveStringSet();
        Ref fromType = Ref.create();
        SqlReferenceExpression qualifier = expression instanceof SqlReferenceExpression ? (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)expression).getQualifierExpression(), SqlReferenceExpression.class) : null;
        CompletionResultSet resultSet = result2.caseInsensitive();
        if (refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            String basePrefix;
            String qPrefix;
            String fullPrefix;
            List<String> items2;
            int index2;
            SqlTableExpression tableExpression;
            SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSelectClause.class);
            SqlQueryExpression query = (SqlQueryExpression)ObjectUtils.tryCast((Object)(selectClause == null ? null : selectClause.getParent()), SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = query == null ? null : query.getTableExpression();
            if (tableExpression != null) {
                fromType.set((Object)tableExpression.getDasType());
            }
            if (parent2 instanceof SqlGroupByClause && (qualifier != null || SqlImplUtil.sqlTraverser(parent2).children((Object)parent2).filter(SqlReferenceExpression.class).single() != null) && (index2 = ContainerUtil.indexOf(items2 = SqlReferenceExpressionCompletionProvider.collectGroupByItems((SqlGroupByClause)parent2), arg_0 -> SqlReferenceExpressionCompletionProvider.lambda$doAddCompletions$0(fullPrefix = (qPrefix = qualifier != null ? qualifier.getText() + "." : "") + (basePrefix = resultSet.getPrefixMatcher().getPrefix()), arg_0))) >= 0) {
                ContainerUtil.swapElements(items2, (int)0, (int)index2);
                String suggestion = StringUtil.join(items2, (String)", ");
                resultSet.addElement(SqlCompletionUtil.createTextLookup(suggestion.substring(qPrefix.length()), suggestion, 200.0));
            }
        }
        if (refType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && (parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression)) {
            SqlReferenceExpressionCompletionProvider.collectColumnsFromSelect(expression, namingService2, columnsNamesFromSelectForTableRef);
        }
        boolean triggerFunctionExpected = SqlCompletionUtil.isTriggerFunctionExpected(expression);
        boolean isValidSelectClause = refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && expression.getParent() instanceof SqlSelectClause && !SqlCompletionUtil.hasMissingFrom((SqlElement)expression);
        PsiElement qualifyingEntity = SqlReferenceExpressionCompletionProvider.getQualifyingEntity(qualifier);
        DasTable qualifierTable = SqlReferenceExpressionCompletionProvider.getQualifyingTable(qualifyingEntity);
        PsiElement originalPosition = parameters2.getOriginalPosition();
        LinkedHashSet columnsAtOnce = new LinkedHashSet();
        ArrayList<PsiElement> qualifiers = new ArrayList<PsiElement>();
        Ref hasSourceColumns = Ref.create((Object)false);
        HashSet<String> existingFunctionNames = new HashSet<String>();
        ArrayList restrainedElements = new ArrayList();
        Set<ObjectKind> strictTypes = sqlRef.getExpectedTargetTypesStrict(dialect);
        boolean restrainNonStrict = dbms.isPostgres() && refType.getTargetKind() == ObjectKind.TABLE;
        boolean weightDown = prevLeaf2 instanceof SqlIdentifierKeywordTokenType && (ktt = (SqlIdentifierKeywordTokenType)prevLeaf2).getKeyword() == SqlCommonKeywords.SQL_CONSTRAINT;
        SqlCompletionUtil.addReferenceCompletionVariants(sqlRef, resultSet.getPrefixMatcher(), weightDown, (Consumer<LookupElement>)((Consumer)element2 -> {
            SqlNameElement ne;
            ObjectKind targetKind;
            DasSymbol symbol = SqlCompletionUtil.getTargetSymbol(element2);
            DasObject dasObject = symbol != null ? symbol.getDasObject() : null;
            ObjectKind objectKind = targetKind = dasObject != null ? dasObject.getKind() : ObjectKind.NONE;
            if (dasObject != null) {
                ObjectKind kind;
                ObjectKind objectKind2 = dasObject.getKind();
                if (!(inDefinitionNameKind == null || objectKind2 != inDefinitionNameKind && strictExpectedTargetTypes.contains(objectKind2))) {
                    return;
                }
                if (!refType.isQualified() && (kind = refType.getTargetKind()) != SqlDbElementType.ANY && dialect.getSuperKind(objectKind2) != dialect.getSuperKind(kind)) {
                    return;
                }
            }
            if (triggerFunctionExpected) {
                if (!(dasObject instanceof DasRoutine)) {
                    return;
                }
                DasArgument returnArgument2 = ((DasRoutine)dasObject).getReturnArgument();
                if (returnArgument2 == null) {
                    return;
                }
                if (!dialect.getTypeSystem().isTriggerFunctionType(returnArgument2.getDasType())) {
                    return;
                }
            }
            if (dasObject instanceof DasColumn && element2 instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)element2).getPriority() >= 10.0) {
                hasSourceColumns.set((Object)true);
            }
            if (originalPosition != null && symbol instanceof SqlDefinition && (ne = ((SqlDefinition)symbol).getNameElement()) != null && PsiTreeUtil.isContextAncestor((PsiElement)ne, (PsiElement)originalPosition, (boolean)false)) {
                return;
            }
            Object lookupElement = element2;
            final String lookupString = dialect.adjustReferenceLookupString((LookupElement)element2, targetKind, sqlRef.getExpectedTargetTypesStrict(dialect));
            if (lookupString != null) {
                lookupElement = new LookupElementDecorator<LookupElement>(lookupElement){

                    @NotNull
                    public String getLookupString() {
                        String string = lookupString;
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider$1", "getLookupString"));
                    }
                };
            }
            lookupElement = SqlReferenceExpressionCompletionProvider.adjustBySimilarity(lookupElement, SqlReferenceExpressionCompletionProvider.getSimilarity(namingService2, columnsNamesFromSelectForTableRef, (SqlTableType)fromType.get(), dasObject));
            if (dasObject != null && !strictTypes.contains(targetKind) && (restrainNonStrict || targetKind == ObjectKind.SCHEMA || targetKind == ObjectKind.DATABASE)) {
                restrainedElements.add(lookupElement);
                return;
            }
            resultSet.addElement(lookupElement);
        }), parameters2, (element2, q2) -> {
            if ((element2 instanceof DasColumn || element2 instanceof SqlAsExpression && !SqlReferenceExpressionCompletionProvider.isQueryExpression(((SqlAsExpression)element2).getExpression())) && (isValidSelectClause || SqlReferenceExpressionCompletionProvider.acceptBySelectAndQualifier(namingService2, columnsNamesFromSelectForColumnRef, element2, qualifierTable))) {
                if (columnsAtOnce.add(element2)) {
                    qualifiers.add((PsiElement)q2);
                }
            } else if (element2 instanceof DasRoutine && element2 instanceof PsiNamedElement) {
                existingFunctionNames.add(element2.getName());
            }
        });
        for (LookupElement restrainedElement : restrainedElements) {
            resultSet.addElement(restrainedElement);
        }
        if (columnsAtOnce.size() > 1 && (element3 = SqlCompletionUtil.createAllColumnsLookupElement(columnsAtOnce, project, dialect, columnsNamesFromSelectForColumnRef.size() > 0 && SqlReferenceExpressionCompletionProvider.requiresFullSpecInOrderBy(dbms) ? 149 : ((Boolean)hasSourceColumns.get() != false ? 10 : 5), false, SqlCompletionUtil.canQualify((IElementType)refType), qualifiers, dbms)) != null) {
            resultSet.addElement(element3);
        }
        SqlFunctionDefinitionCompletions.addFunctionDefinitionCompletions(parameters2, result2, existingFunctionNames);
    }

    private static List<String> collectGroupByItems(SqlGroupByClause groupByClause) {
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)groupByClause, SqlQueryExpression.class);
        if (queryExpression == null) {
            return Collections.emptyList();
        }
        SqlSelectClause selectClause = queryExpression.getSelectClause();
        JBIterable expressions2 = selectClause != null ? JBIterable.from((Iterable)selectClause.getExpressions()) : JBIterable.empty();
        return (List)JBIterable.from((Iterable)expressions2).filter(e2 -> {
            final boolean[] isAggregate = new boolean[]{false};
            if (SqlImplUtil.isAsteriskRef((PsiElement)e2)) {
                return false;
            }
            e2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element2 instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)element2)) {
                        isAggregate[0] = true;
                        this.stopWalking();
                    }
                    super.visitElement(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider$2", "visitElement"));
                }
            });
            return !isAggregate[0];
        }).map(e2 -> {
            SqlExpression unwrapped = e2 instanceof SqlAsExpression ? ((SqlAsExpression)e2).getExpression() : e2;
            return unwrapped != null ? unwrapped.getText() : null;
        }).filter(Conditions.notNull()).addAllTo(new ArrayList());
    }

    private static boolean isQueryExpression(@Nullable SqlExpression expression) {
        if (expression instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)expression).getReferenceElementType().getTargetKind() != ObjectKind.COLUMN;
        }
        if (expression instanceof SqlResultSetExpression) {
            return true;
        }
        if (!(expression instanceof SqlParenthesizedExpression)) {
            return false;
        }
        List expressions2 = ((SqlParenthesizedExpression)expression).getExpressionList();
        if (expressions2.size() != 1) {
            return false;
        }
        return SqlReferenceExpressionCompletionProvider.isQueryExpression((SqlExpression)expressions2.get(0));
    }

    private static boolean requiresFullSpecInOrderBy(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(3);
        }
        return dbms.isMicrosoft() || dbms.isOracle();
    }

    private static PsiElement getQualifyingEntity(@Nullable SqlReferenceExpression qualifier) {
        return qualifier == null ? null : qualifier.resolve();
    }

    private static DasTable getQualifyingTable(@Nullable PsiElement qualifyingElement) {
        SqlExpression expression;
        PsiElement qualifier = qualifyingElement instanceof SqlAsExpression ? ((expression = ((SqlAsExpression)qualifyingElement).getExpression()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolve() : null) : qualifyingElement;
        return (DasTable)ObjectUtils.tryCast((Object)qualifier, DasTable.class);
    }

    private static boolean acceptBySelectAndQualifier(NamingService namingService2, Set<String> columnsNamesFromSelectForColumnRef, DasObject element2, DasTable qualifierTable) {
        if (!SqlReferenceExpressionCompletionProvider.isStar(columnsNamesFromSelectForColumnRef, namingService2) && !columnsNamesFromSelectForColumnRef.contains(namingService2.enquote(element2.getName(), element2.getKind()))) {
            return false;
        }
        return qualifierTable == null || qualifierTable.equals(element2.getDasParent());
    }

    private static boolean isStar(Set<String> columnRefs, NamingService namingService2) {
        return columnRefs.size() == 1 && namingService2.enquote("*", ObjectKind.COLUMN).equals(columnRefs.iterator().next());
    }

    private static void collectColumnsFromSelect(@NotNull SqlExpression expression, final @NotNull NamingService namingService2, final @NotNull Set<String> columnsNamesFromSelect) {
        SqlQueryExpression query;
        SqlSelectClause select;
        if (expression == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(4);
        }
        if (namingService2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(5);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(6);
        }
        SqlSelectClause sqlSelectClause = select = (query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlQueryExpression.class)) != null ? query.getSelectClause() : null;
        if (select != null) {
            select.accept(new SqlVisitor(){

                public void visitSqlReferenceExpression(SqlReferenceExpression e2) {
                    if (e2.getQualifierExpression() == null && e2.getReferenceElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                        columnsNamesFromSelect.add(namingService2.enquote(e2.getName(), e2.getKind()));
                    }
                }

                public void visitSqlElement(SqlElement e2) {
                    for (PsiElement element2 = e2.getFirstChild(); element2 != null; element2 = element2.getNextSibling()) {
                        if (!(element2 instanceof SqlElement)) continue;
                        ((SqlElement)element2).accept((SqlVisitor)this);
                    }
                }
            });
        }
    }

    private static int getInitialSimilarity(@Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (fromType == null) {
            return 0;
        }
        boolean isColumn = tgt instanceof DasColumn;
        boolean isTable = tgt instanceof DasTable;
        if (!isColumn && !isTable) {
            return 0;
        }
        for (int i2 = 0; i2 < fromType.getColumnCount(); ++i2) {
            if (isColumn && fromType.getColumnElement(i2).equals(tgt)) {
                return 2;
            }
            if (!isTable || !Comparing.equal((Object)fromType.getColumnQualifier(i2), (Object)tgt)) continue;
            return 1;
        }
        return 0;
    }

    private static int getSimilarity(@NotNull NamingService namingService2, @NotNull Set<String> columnsNamesFromSelect, @Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (namingService2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(7);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(8);
        }
        int similarity = SqlReferenceExpressionCompletionProvider.getInitialSimilarity(fromType, tgt);
        if (columnsNamesFromSelect.isEmpty() || !(tgt instanceof DasTable)) {
            return similarity;
        }
        for (DasColumn c2 : DasUtil.getColumns(tgt)) {
            if (!columnsNamesFromSelect.contains(namingService2.enquote(c2.getName(), c2.getKind()))) continue;
            ++similarity;
        }
        return similarity;
    }

    @NotNull
    private static LookupElement adjustBySimilarity(@NotNull LookupElement element2, int similarity) {
        if (element2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(9);
        }
        if (similarity == 0) {
            LookupElement lookupElement = element2;
            if (lookupElement == null) {
                SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(10);
            }
            return lookupElement;
        }
        int factorizedSimilarity = similarity * 10;
        double priority = element2 instanceof PrioritizedLookupElement ? ((PrioritizedLookupElement)element2).getPriority() : 0.0;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element2, (double)(priority + (double)factorizedSimilarity));
        if (lookupElement == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(11);
        }
        return lookupElement;
    }

    private static /* synthetic */ boolean lambda$doAddCompletions$0(String fullPrefix, String item) {
        return StringUtil.startsWithIgnoreCase((String)item, (String)fullPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNamesFromSelect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustBySimilarity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requiresFullSpecInOrderBy";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnsFromSelect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSimilarity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustBySimilarity";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

