/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.Dbms;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SqlFunctionDefinitionCompletions {
    private static final TokenSet FOR_FUNCTION_COMPLETION = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE, SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_REFERENCE});

    static void addFunctionDefinitionCompletions(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result, @NotNull Set<String> existingFunctionNames) {
        DasType qualType;
        IElementType fragmentType;
        SqlReferenceImpl ref2;
        PsiFile file;
        if (parameters2 == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(1);
        }
        if (existingFunctionNames == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(2);
        }
        if (!((file = parameters2.getOriginalFile()) instanceof SqlFile)) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
        SqlReferenceImpl sqlReferenceImpl = ref2 = expression == null ? null : (SqlReferenceImpl)ObjectUtils.tryCast((Object)expression.getReference(), SqlReferenceImpl.class);
        if (ref2 == null) {
            return;
        }
        IElementType iElementType = fragmentType = file instanceof SqlCodeFragment ? ((SqlCodeFragment)file).getElementType() : null;
        if (fragmentType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE || SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(fragmentType)) {
            return;
        }
        SqlExpression qualifier = ref2.getQualifier();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Dbms dbms = dialect.getDbms();
        if (qualifier != null && !dbms.isPostgres() && !dbms.isMicrosoft()) {
            return;
        }
        DasType dasType = qualType = qualifier == null ? null : qualifier.getDasType();
        if (qualType == DasTypeSystemBase.UNKNOWN) {
            return;
        }
        CompletionResultSet result2 = _result.caseInsensitive();
        SqlReferenceElementType type2 = ref2.getReferenceElementType();
        boolean triggerFunctionExpected = SqlCompletionUtil.isTriggerFunctionExpected(expression);
        if ((FOR_FUNCTION_COMPLETION.contains((IElementType)type2) || dialect.isSpecialFunctionReference((IElementType)type2)) && !SqlCompletionUtil.isModificationTarget(position) && !ref2.resolveStrict()) {
            Set<BuiltinFunction.Location> locations = dialect.getExpectedFunctionLocations(expression);
            SqlLanguageDialectEx.BuiltinFunctions builtins = ref2.getRelevantBuiltins(dialect);
            if (builtins == null) {
                builtins = dialect.getSupportedFunctions();
            }
            for (BuiltinFunction def : builtins.byMatcher(result2.getPrefixMatcher())) {
                if (existingFunctionNames.contains(def.getName())) continue;
                for (BuiltinFunction.Prototype prototype : def.getPrototypes()) {
                    if (!locations.contains(prototype.getLocation()) || qualifier != null && dbms.isPostgres() && !SqlFunctionDefinitionCompletions.isApplicable(prototype, qualifier, qualType)) continue;
                    if (triggerFunctionExpected) {
                        DasType returnDasType;
                        BuiltinFunction.Type returnType = prototype.getReturnType();
                        DasType dasType2 = returnDasType = returnType != null ? returnType.getDasType() : null;
                        if (returnDasType == null || !dialect.getTypeSystem().isTriggerFunctionType(returnDasType)) continue;
                    }
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)0.0));
                }
            }
        }
    }

    private static boolean isApplicable(BuiltinFunction.Prototype prototype, SqlExpression qual, DasType type2) {
        BuiltinFunction.Parameter[] params2 = prototype.getParams();
        if (params2.length != 1) {
            return false;
        }
        return SqlFunctionsUtil.isAssignable(params2[0], qual, type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "_result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "existingFunctionNames";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/completion/providers/SqlFunctionDefinitionCompletions";
        objectArray[2] = "addFunctionDefinitionCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

